/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network change event. This can be a change to a segment, attachment, route, etc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkChangeEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkChangeEvent.Builder, CoreNetworkChangeEvent> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CoreNetworkChangeEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(CoreNetworkChangeEvent::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> IDENTIFIER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentifierPath").getter(getter(CoreNetworkChangeEvent::identifierPath))
            .setter(setter(Builder::identifierPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifierPath").build()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventTime").getter(getter(CoreNetworkChangeEvent::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CoreNetworkChangeEvent::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CoreNetworkChangeEventValues> VALUES_FIELD = SdkField
            .<CoreNetworkChangeEventValues> builder(MarshallingType.SDK_POJO).memberName("Values")
            .getter(getter(CoreNetworkChangeEvent::values)).setter(setter(Builder::values))
            .constructor(CoreNetworkChangeEventValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTION_FIELD,
            IDENTIFIER_PATH_FIELD, EVENT_TIME_FIELD, STATUS_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String action;

    private final String identifierPath;

    private final Instant eventTime;

    private final String status;

    private final CoreNetworkChangeEventValues values;

    private CoreNetworkChangeEvent(BuilderImpl builder) {
        this.type = builder.type;
        this.action = builder.action;
        this.identifierPath = builder.identifierPath;
        this.eventTime = builder.eventTime;
        this.status = builder.status;
        this.values = builder.values;
    }

    /**
     * <p>
     * Describes the type of change event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the type of change event.
     * @see ChangeType
     */
    public final ChangeType type() {
        return ChangeType.fromValue(type);
    }

    /**
     * <p>
     * Describes the type of change event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the type of change event.
     * @see ChangeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The action taken for the change event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken for the change event.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action taken for the change event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken for the change event.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Uniquely identifies the path for a change within the changeset. For example, the <code>IdentifierPath</code> for
     * a core network segment change might be <code>"CORE_NETWORK_SEGMENT/us-east-1/devsegment"</code>.
     * </p>
     * 
     * @return Uniquely identifies the path for a change within the changeset. For example, the
     *         <code>IdentifierPath</code> for a core network segment change might be
     *         <code>"CORE_NETWORK_SEGMENT/us-east-1/devsegment"</code>.
     */
    public final String identifierPath() {
        return identifierPath;
    }

    /**
     * <p>
     * The timestamp for an event change in status.
     * </p>
     * 
     * @return The timestamp for an event change in status.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * The status of the core network change event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the core network change event.
     * @see ChangeStatus
     */
    public final ChangeStatus status() {
        return ChangeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the core network change event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the core network change event.
     * @see ChangeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details of the change event.
     * </p>
     * 
     * @return Details of the change event.
     */
    public final CoreNetworkChangeEventValues values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifierPath());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChangeEvent)) {
            return false;
        }
        CoreNetworkChangeEvent other = (CoreNetworkChangeEvent) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(identifierPath(), other.identifierPath()) && Objects.equals(eventTime(), other.eventTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkChangeEvent").add("Type", typeAsString()).add("Action", actionAsString())
                .add("IdentifierPath", identifierPath()).add("EventTime", eventTime()).add("Status", statusAsString())
                .add("Values", values()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "IdentifierPath":
            return Optional.ofNullable(clazz.cast(identifierPath()));
        case "EventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChangeEvent, T> g) {
        return obj -> g.apply((CoreNetworkChangeEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkChangeEvent> {
        /**
         * <p>
         * Describes the type of change event.
         * </p>
         * 
         * @param type
         *        Describes the type of change event.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the type of change event.
         * </p>
         * 
         * @param type
         *        Describes the type of change event.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(ChangeType type);

        /**
         * <p>
         * The action taken for the change event.
         * </p>
         * 
         * @param action
         *        The action taken for the change event.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action taken for the change event.
         * </p>
         * 
         * @param action
         *        The action taken for the change event.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Uniquely identifies the path for a change within the changeset. For example, the <code>IdentifierPath</code>
         * for a core network segment change might be <code>"CORE_NETWORK_SEGMENT/us-east-1/devsegment"</code>.
         * </p>
         * 
         * @param identifierPath
         *        Uniquely identifies the path for a change within the changeset. For example, the
         *        <code>IdentifierPath</code> for a core network segment change might be
         *        <code>"CORE_NETWORK_SEGMENT/us-east-1/devsegment"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifierPath(String identifierPath);

        /**
         * <p>
         * The timestamp for an event change in status.
         * </p>
         * 
         * @param eventTime
         *        The timestamp for an event change in status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * The status of the core network change event.
         * </p>
         * 
         * @param status
         *        The status of the core network change event.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the core network change event.
         * </p>
         * 
         * @param status
         *        The status of the core network change event.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(ChangeStatus status);

        /**
         * <p>
         * Details of the change event.
         * </p>
         * 
         * @param values
         *        Details of the change event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(CoreNetworkChangeEventValues values);

        /**
         * <p>
         * Details of the change event.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoreNetworkChangeEventValues.Builder}
         * avoiding the need to create one manually via {@link CoreNetworkChangeEventValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoreNetworkChangeEventValues.Builder#build()} is called
         * immediately and its result is passed to {@link #values(CoreNetworkChangeEventValues)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link CoreNetworkChangeEventValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(CoreNetworkChangeEventValues)
         */
        default Builder values(Consumer<CoreNetworkChangeEventValues.Builder> values) {
            return values(CoreNetworkChangeEventValues.builder().applyMutation(values).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String action;

        private String identifierPath;

        private Instant eventTime;

        private String status;

        private CoreNetworkChangeEventValues values;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChangeEvent model) {
            type(model.type);
            action(model.action);
            identifierPath(model.identifierPath);
            eventTime(model.eventTime);
            status(model.status);
            values(model.values);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getIdentifierPath() {
            return identifierPath;
        }

        public final void setIdentifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
        }

        @Override
        public final Builder identifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CoreNetworkChangeEventValues.Builder getValues() {
            return values != null ? values.toBuilder() : null;
        }

        public final void setValues(CoreNetworkChangeEventValues.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(CoreNetworkChangeEventValues values) {
            this.values = values;
            return this;
        }

        @Override
        public CoreNetworkChangeEvent build() {
            return new CoreNetworkChangeEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
