/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransitGatewayPeeringResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetTransitGatewayPeeringResponse.Builder, GetTransitGatewayPeeringResponse> {
    private static final SdkField<TransitGatewayPeering> TRANSIT_GATEWAY_PEERING_FIELD = SdkField
            .<TransitGatewayPeering> builder(MarshallingType.SDK_POJO).memberName("TransitGatewayPeering")
            .getter(getter(GetTransitGatewayPeeringResponse::transitGatewayPeering))
            .setter(setter(Builder::transitGatewayPeering)).constructor(TransitGatewayPeering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPeering").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_PEERING_FIELD));

    private final TransitGatewayPeering transitGatewayPeering;

    private GetTransitGatewayPeeringResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPeering = builder.transitGatewayPeering;
    }

    /**
     * <p>
     * Returns information about a transit gateway peering.
     * </p>
     * 
     * @return Returns information about a transit gateway peering.
     */
    public final TransitGatewayPeering transitGatewayPeering() {
        return transitGatewayPeering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayPeering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayPeeringResponse)) {
            return false;
        }
        GetTransitGatewayPeeringResponse other = (GetTransitGatewayPeeringResponse) obj;
        return Objects.equals(transitGatewayPeering(), other.transitGatewayPeering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransitGatewayPeeringResponse").add("TransitGatewayPeering", transitGatewayPeering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayPeering":
            return Optional.ofNullable(clazz.cast(transitGatewayPeering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayPeeringResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayPeeringResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransitGatewayPeeringResponse> {
        /**
         * <p>
         * Returns information about a transit gateway peering.
         * </p>
         * 
         * @param transitGatewayPeering
         *        Returns information about a transit gateway peering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayPeering(TransitGatewayPeering transitGatewayPeering);

        /**
         * <p>
         * Returns information about a transit gateway peering.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayPeering.Builder} avoiding
         * the need to create one manually via {@link TransitGatewayPeering#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayPeering.Builder#build()} is called immediately and
         * its result is passed to {@link #transitGatewayPeering(TransitGatewayPeering)}.
         * 
         * @param transitGatewayPeering
         *        a consumer that will call methods on {@link TransitGatewayPeering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayPeering(TransitGatewayPeering)
         */
        default Builder transitGatewayPeering(Consumer<TransitGatewayPeering.Builder> transitGatewayPeering) {
            return transitGatewayPeering(TransitGatewayPeering.builder().applyMutation(transitGatewayPeering).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private TransitGatewayPeering transitGatewayPeering;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayPeeringResponse model) {
            super(model);
            transitGatewayPeering(model.transitGatewayPeering);
        }

        public final TransitGatewayPeering.Builder getTransitGatewayPeering() {
            return transitGatewayPeering != null ? transitGatewayPeering.toBuilder() : null;
        }

        public final void setTransitGatewayPeering(TransitGatewayPeering.BuilderImpl transitGatewayPeering) {
            this.transitGatewayPeering = transitGatewayPeering != null ? transitGatewayPeering.build() : null;
        }

        @Override
        public final Builder transitGatewayPeering(TransitGatewayPeering transitGatewayPeering) {
            this.transitGatewayPeering = transitGatewayPeering;
            return this;
        }

        @Override
        public GetTransitGatewayPeeringResponse build() {
            return new GetTransitGatewayPeeringResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
