/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a location in AWS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AWSLocation implements SdkPojo, Serializable, ToCopyableBuilder<AWSLocation.Builder, AWSLocation> {
    private static final SdkField<String> ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Zone")
            .getter(getter(AWSLocation::zone)).setter(setter(Builder::zone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zone").build()).build();

    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetArn").getter(getter(AWSLocation::subnetArn)).setter(setter(Builder::subnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_FIELD, SUBNET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String zone;

    private final String subnetArn;

    private AWSLocation(BuilderImpl builder) {
        this.zone = builder.zone;
        this.subnetArn = builder.subnetArn;
    }

    /**
     * <p>
     * The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength Zone, or an
     * Outpost.
     * </p>
     * 
     * @return The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength
     *         Zone, or an Outpost.
     */
    public final String zone() {
        return zone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the subnet the device is located in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the subnet the device is located in.
     */
    public final String subnetArn() {
        return subnetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zone());
        hashCode = 31 * hashCode + Objects.hashCode(subnetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSLocation)) {
            return false;
        }
        AWSLocation other = (AWSLocation) obj;
        return Objects.equals(zone(), other.zone()) && Objects.equals(subnetArn(), other.subnetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AWSLocation").add("Zone", zone()).add("SubnetArn", subnetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Zone":
            return Optional.ofNullable(clazz.cast(zone()));
        case "SubnetArn":
            return Optional.ofNullable(clazz.cast(subnetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSLocation, T> g) {
        return obj -> g.apply((AWSLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AWSLocation> {
        /**
         * <p>
         * The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength Zone,
         * or an Outpost.
         * </p>
         * 
         * @param zone
         *        The Zone the device is located in. This can be the ID of an Availability Zone, Local Zone, Wavelength
         *        Zone, or an Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zone(String zone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the subnet the device is located in.
         * </p>
         * 
         * @param subnetArn
         *        The Amazon Resource Name (ARN) of the subnet the device is located in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArn(String subnetArn);
    }

    static final class BuilderImpl implements Builder {
        private String zone;

        private String subnetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSLocation model) {
            zone(model.zone);
            subnetArn(model.subnetArn);
        }

        public final String getZone() {
            return zone;
        }

        public final void setZone(String zone) {
            this.zone = zone;
        }

        @Override
        @Transient
        public final Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public final String getSubnetArn() {
            return subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        @Transient
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        @Override
        public AWSLocation build() {
            return new AWSLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
