/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway peering attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPeering implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPeering.Builder, TransitGatewayPeering> {
    private static final SdkField<Peering> PEERING_FIELD = SdkField.<Peering> builder(MarshallingType.SDK_POJO)
            .memberName("Peering").getter(getter(TransitGatewayPeering::peering)).setter(setter(Builder::peering))
            .constructor(Peering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Peering").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayArn").getter(getter(TransitGatewayPeering::transitGatewayArn))
            .setter(setter(Builder::transitGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayArn").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_PEERING_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayPeeringAttachmentId")
            .getter(getter(TransitGatewayPeering::transitGatewayPeeringAttachmentId))
            .setter(setter(Builder::transitGatewayPeeringAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPeeringAttachmentId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEERING_FIELD,
            TRANSIT_GATEWAY_ARN_FIELD, TRANSIT_GATEWAY_PEERING_ATTACHMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Peering peering;

    private final String transitGatewayArn;

    private final String transitGatewayPeeringAttachmentId;

    private TransitGatewayPeering(BuilderImpl builder) {
        this.peering = builder.peering;
        this.transitGatewayArn = builder.transitGatewayArn;
        this.transitGatewayPeeringAttachmentId = builder.transitGatewayPeeringAttachmentId;
    }

    /**
     * <p>
     * Describes a transit gateway peer connection.
     * </p>
     * 
     * @return Describes a transit gateway peer connection.
     */
    public final Peering peering() {
        return peering;
    }

    /**
     * <p>
     * The ARN of the transit gateway.
     * </p>
     * 
     * @return The ARN of the transit gateway.
     */
    public final String transitGatewayArn() {
        return transitGatewayArn;
    }

    /**
     * <p>
     * The ID of the transit gateway peering attachment.
     * </p>
     * 
     * @return The ID of the transit gateway peering attachment.
     */
    public final String transitGatewayPeeringAttachmentId() {
        return transitGatewayPeeringAttachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peering());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayPeeringAttachmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPeering)) {
            return false;
        }
        TransitGatewayPeering other = (TransitGatewayPeering) obj;
        return Objects.equals(peering(), other.peering()) && Objects.equals(transitGatewayArn(), other.transitGatewayArn())
                && Objects.equals(transitGatewayPeeringAttachmentId(), other.transitGatewayPeeringAttachmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPeering").add("Peering", peering()).add("TransitGatewayArn", transitGatewayArn())
                .add("TransitGatewayPeeringAttachmentId", transitGatewayPeeringAttachmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Peering":
            return Optional.ofNullable(clazz.cast(peering()));
        case "TransitGatewayArn":
            return Optional.ofNullable(clazz.cast(transitGatewayArn()));
        case "TransitGatewayPeeringAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayPeeringAttachmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPeering, T> g) {
        return obj -> g.apply((TransitGatewayPeering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPeering> {
        /**
         * <p>
         * Describes a transit gateway peer connection.
         * </p>
         * 
         * @param peering
         *        Describes a transit gateway peer connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peering(Peering peering);

        /**
         * <p>
         * Describes a transit gateway peer connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link Peering.Builder} avoiding the need to
         * create one manually via {@link Peering#builder()}.
         *
         * When the {@link Consumer} completes, {@link Peering.Builder#build()} is called immediately and its result is
         * passed to {@link #peering(Peering)}.
         * 
         * @param peering
         *        a consumer that will call methods on {@link Peering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #peering(Peering)
         */
        default Builder peering(Consumer<Peering.Builder> peering) {
            return peering(Peering.builder().applyMutation(peering).build());
        }

        /**
         * <p>
         * The ARN of the transit gateway.
         * </p>
         * 
         * @param transitGatewayArn
         *        The ARN of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayArn(String transitGatewayArn);

        /**
         * <p>
         * The ID of the transit gateway peering attachment.
         * </p>
         * 
         * @param transitGatewayPeeringAttachmentId
         *        The ID of the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayPeeringAttachmentId(String transitGatewayPeeringAttachmentId);
    }

    static final class BuilderImpl implements Builder {
        private Peering peering;

        private String transitGatewayArn;

        private String transitGatewayPeeringAttachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPeering model) {
            peering(model.peering);
            transitGatewayArn(model.transitGatewayArn);
            transitGatewayPeeringAttachmentId(model.transitGatewayPeeringAttachmentId);
        }

        public final Peering.Builder getPeering() {
            return peering != null ? peering.toBuilder() : null;
        }

        public final void setPeering(Peering.BuilderImpl peering) {
            this.peering = peering != null ? peering.build() : null;
        }

        @Override
        public final Builder peering(Peering peering) {
            this.peering = peering;
            return this;
        }

        public final String getTransitGatewayArn() {
            return transitGatewayArn;
        }

        public final void setTransitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
        }

        @Override
        public final Builder transitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        public final String getTransitGatewayPeeringAttachmentId() {
            return transitGatewayPeeringAttachmentId;
        }

        public final void setTransitGatewayPeeringAttachmentId(String transitGatewayPeeringAttachmentId) {
            this.transitGatewayPeeringAttachmentId = transitGatewayPeeringAttachmentId;
        }

        @Override
        public final Builder transitGatewayPeeringAttachmentId(String transitGatewayPeeringAttachmentId) {
            this.transitGatewayPeeringAttachmentId = transitGatewayPeeringAttachmentId;
            return this;
        }

        @Override
        public TransitGatewayPeering build() {
            return new TransitGatewayPeering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
