/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the VPC options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOptions implements SdkPojo, Serializable, ToCopyableBuilder<VpcOptions.Builder, VpcOptions> {
    private static final SdkField<Boolean> IPV6_SUPPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ipv6Support").getter(getter(VpcOptions::ipv6Support)).setter(setter(Builder::ipv6Support))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Support").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean ipv6Support;

    private VpcOptions(BuilderImpl builder) {
        this.ipv6Support = builder.ipv6Support;
    }

    /**
     * <p>
     * Indicates whether IPv6 is supported.
     * </p>
     * 
     * @return Indicates whether IPv6 is supported.
     */
    public final Boolean ipv6Support() {
        return ipv6Support;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Support());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOptions)) {
            return false;
        }
        VpcOptions other = (VpcOptions) obj;
        return Objects.equals(ipv6Support(), other.ipv6Support());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOptions").add("Ipv6Support", ipv6Support()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Support":
            return Optional.ofNullable(clazz.cast(ipv6Support()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcOptions, T> g) {
        return obj -> g.apply((VpcOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOptions> {
        /**
         * <p>
         * Indicates whether IPv6 is supported.
         * </p>
         * 
         * @param ipv6Support
         *        Indicates whether IPv6 is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Support(Boolean ipv6Support);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ipv6Support;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOptions model) {
            ipv6Support(model.ipv6Support);
        }

        public final Boolean getIpv6Support() {
            return ipv6Support;
        }

        public final void setIpv6Support(Boolean ipv6Support) {
            this.ipv6Support = ipv6Support;
        }

        @Override
        public final Builder ipv6Support(Boolean ipv6Support) {
            this.ipv6Support = ipv6Support;
            return this;
        }

        @Override
        public VpcOptions build() {
            return new VpcOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
