/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkResourceRelationshipsResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetNetworkResourceRelationshipsResponse.Builder, GetNetworkResourceRelationshipsResponse> {
    private static final SdkField<List<Relationship>> RELATIONSHIPS_FIELD = SdkField
            .<List<Relationship>> builder(MarshallingType.LIST)
            .memberName("Relationships")
            .getter(getter(GetNetworkResourceRelationshipsResponse::relationships))
            .setter(setter(Builder::relationships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relationships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Relationship> builder(MarshallingType.SDK_POJO)
                                            .constructor(Relationship::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetNetworkResourceRelationshipsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONSHIPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Relationship> relationships;

    private final String nextToken;

    private GetNetworkResourceRelationshipsResponse(BuilderImpl builder) {
        super(builder);
        this.relationships = builder.relationships;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Relationships property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelationships() {
        return relationships != null && !(relationships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource relationships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelationships} method.
     * </p>
     * 
     * @return The resource relationships.
     */
    public final List<Relationship> relationships() {
        return relationships;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRelationships() ? relationships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkResourceRelationshipsResponse)) {
            return false;
        }
        GetNetworkResourceRelationshipsResponse other = (GetNetworkResourceRelationshipsResponse) obj;
        return hasRelationships() == other.hasRelationships() && Objects.equals(relationships(), other.relationships())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkResourceRelationshipsResponse")
                .add("Relationships", hasRelationships() ? relationships() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Relationships":
            return Optional.ofNullable(clazz.cast(relationships()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkResourceRelationshipsResponse, T> g) {
        return obj -> g.apply((GetNetworkResourceRelationshipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNetworkResourceRelationshipsResponse> {
        /**
         * <p>
         * The resource relationships.
         * </p>
         * 
         * @param relationships
         *        The resource relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationships(Collection<Relationship> relationships);

        /**
         * <p>
         * The resource relationships.
         * </p>
         * 
         * @param relationships
         *        The resource relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationships(Relationship... relationships);

        /**
         * <p>
         * The resource relationships.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Relationship.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkmanager.model.Relationship#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Relationship.Builder#build()} is called
         * immediately and its result is passed to {@link #relationships(List<Relationship>)}.
         * 
         * @param relationships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Relationship.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationships(java.util.Collection<Relationship>)
         */
        Builder relationships(Consumer<Relationship.Builder>... relationships);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<Relationship> relationships = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkResourceRelationshipsResponse model) {
            super(model);
            relationships(model.relationships);
            nextToken(model.nextToken);
        }

        public final List<Relationship.Builder> getRelationships() {
            List<Relationship.Builder> result = RelationshipListCopier.copyToBuilder(this.relationships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationships(Collection<Relationship.BuilderImpl> relationships) {
            this.relationships = RelationshipListCopier.copyFromBuilder(relationships);
        }

        @Override
        public final Builder relationships(Collection<Relationship> relationships) {
            this.relationships = RelationshipListCopier.copy(relationships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Relationship... relationships) {
            relationships(Arrays.asList(relationships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Consumer<Relationship.Builder>... relationships) {
            relationships(Stream.of(relationships).map(c -> Relationship.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetNetworkResourceRelationshipsResponse build() {
            return new GetNetworkResourceRelationshipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
