/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGlobalNetworksResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<DescribeGlobalNetworksResponse.Builder, DescribeGlobalNetworksResponse> {
    private static final SdkField<List<GlobalNetwork>> GLOBAL_NETWORKS_FIELD = SdkField
            .<List<GlobalNetwork>> builder(MarshallingType.LIST)
            .memberName("GlobalNetworks")
            .getter(getter(DescribeGlobalNetworksResponse::globalNetworks))
            .setter(setter(Builder::globalNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeGlobalNetworksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GlobalNetwork> globalNetworks;

    private final String nextToken;

    private DescribeGlobalNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.globalNetworks = builder.globalNetworks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the GlobalNetworks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGlobalNetworks() {
        return globalNetworks != null && !(globalNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the global networks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalNetworks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the global networks.
     */
    public final List<GlobalNetwork> globalNetworks() {
        return globalNetworks;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalNetworks() ? globalNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalNetworksResponse)) {
            return false;
        }
        DescribeGlobalNetworksResponse other = (DescribeGlobalNetworksResponse) obj;
        return hasGlobalNetworks() == other.hasGlobalNetworks() && Objects.equals(globalNetworks(), other.globalNetworks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGlobalNetworksResponse")
                .add("GlobalNetworks", hasGlobalNetworks() ? globalNetworks() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworks":
            return Optional.ofNullable(clazz.cast(globalNetworks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalNetworksResponse, T> g) {
        return obj -> g.apply((DescribeGlobalNetworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGlobalNetworksResponse> {
        /**
         * <p>
         * Information about the global networks.
         * </p>
         * 
         * @param globalNetworks
         *        Information about the global networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworks(Collection<GlobalNetwork> globalNetworks);

        /**
         * <p>
         * Information about the global networks.
         * </p>
         * 
         * @param globalNetworks
         *        Information about the global networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworks(GlobalNetwork... globalNetworks);

        /**
         * <p>
         * Information about the global networks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalNetwork>.Builder} avoiding the need
         * to create one manually via {@link List<GlobalNetwork>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalNetwork>.Builder#build()} is called immediately and
         * its result is passed to {@link #globalNetworks(List<GlobalNetwork>)}.
         * 
         * @param globalNetworks
         *        a consumer that will call methods on {@link List<GlobalNetwork>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalNetworks(List<GlobalNetwork>)
         */
        Builder globalNetworks(Consumer<GlobalNetwork.Builder>... globalNetworks);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<GlobalNetwork> globalNetworks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalNetworksResponse model) {
            super(model);
            globalNetworks(model.globalNetworks);
            nextToken(model.nextToken);
        }

        public final List<GlobalNetwork.Builder> getGlobalNetworks() {
            List<GlobalNetwork.Builder> result = GlobalNetworkListCopier.copyToBuilder(this.globalNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder globalNetworks(Collection<GlobalNetwork> globalNetworks) {
            this.globalNetworks = GlobalNetworkListCopier.copy(globalNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNetworks(GlobalNetwork... globalNetworks) {
            globalNetworks(Arrays.asList(globalNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNetworks(Consumer<GlobalNetwork.Builder>... globalNetworks) {
            globalNetworks(Stream.of(globalNetworks).map(c -> GlobalNetwork.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalNetworks(Collection<GlobalNetwork.BuilderImpl> globalNetworks) {
            this.globalNetworks = GlobalNetworkListCopier.copyFromBuilder(globalNetworks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeGlobalNetworksResponse build() {
            return new DescribeGlobalNetworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
