/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkRoutesRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<GetNetworkRoutesRequest.Builder, GetNetworkRoutesRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(GetNetworkRoutesRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<RouteTableIdentifier> ROUTE_TABLE_IDENTIFIER_FIELD = SdkField
            .<RouteTableIdentifier> builder(MarshallingType.SDK_POJO).memberName("RouteTableIdentifier")
            .getter(getter(GetNetworkRoutesRequest::routeTableIdentifier)).setter(setter(Builder::routeTableIdentifier))
            .constructor(RouteTableIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableIdentifier").build())
            .build();

    private static final SdkField<List<String>> EXACT_CIDR_MATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExactCidrMatches")
            .getter(getter(GetNetworkRoutesRequest::exactCidrMatches))
            .setter(setter(Builder::exactCidrMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExactCidrMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LONGEST_PREFIX_MATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LongestPrefixMatches")
            .getter(getter(GetNetworkRoutesRequest::longestPrefixMatches))
            .setter(setter(Builder::longestPrefixMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongestPrefixMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_OF_MATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetOfMatches")
            .getter(getter(GetNetworkRoutesRequest::subnetOfMatches))
            .setter(setter(Builder::subnetOfMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetOfMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPERNET_OF_MATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupernetOfMatches")
            .getter(getter(GetNetworkRoutesRequest::supernetOfMatches))
            .setter(setter(Builder::supernetOfMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupernetOfMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PREFIX_LIST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrefixListIds")
            .getter(getter(GetNetworkRoutesRequest::prefixListIds))
            .setter(setter(Builder::prefixListIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("States")
            .getter(getter(GetNetworkRoutesRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("States").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Types")
            .getter(getter(GetNetworkRoutesRequest::typesAsStrings))
            .setter(setter(Builder::typesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> DESTINATION_FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("DestinationFilters")
            .getter(getter(GetNetworkRoutesRequest::destinationFilters))
            .setter(setter(Builder::destinationFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationFilters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            ROUTE_TABLE_IDENTIFIER_FIELD, EXACT_CIDR_MATCHES_FIELD, LONGEST_PREFIX_MATCHES_FIELD, SUBNET_OF_MATCHES_FIELD,
            SUPERNET_OF_MATCHES_FIELD, PREFIX_LIST_IDS_FIELD, STATES_FIELD, TYPES_FIELD, DESTINATION_FILTERS_FIELD));

    private final String globalNetworkId;

    private final RouteTableIdentifier routeTableIdentifier;

    private final List<String> exactCidrMatches;

    private final List<String> longestPrefixMatches;

    private final List<String> subnetOfMatches;

    private final List<String> supernetOfMatches;

    private final List<String> prefixListIds;

    private final List<String> states;

    private final List<String> types;

    private final Map<String, List<String>> destinationFilters;

    private GetNetworkRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.routeTableIdentifier = builder.routeTableIdentifier;
        this.exactCidrMatches = builder.exactCidrMatches;
        this.longestPrefixMatches = builder.longestPrefixMatches;
        this.subnetOfMatches = builder.subnetOfMatches;
        this.supernetOfMatches = builder.supernetOfMatches;
        this.prefixListIds = builder.prefixListIds;
        this.states = builder.states;
        this.types = builder.types;
        this.destinationFilters = builder.destinationFilters;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public final RouteTableIdentifier routeTableIdentifier() {
        return routeTableIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExactCidrMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExactCidrMatches() {
        return exactCidrMatches != null && !(exactCidrMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An exact CIDR block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExactCidrMatches} method.
     * </p>
     * 
     * @return An exact CIDR block.
     */
    public final List<String> exactCidrMatches() {
        return exactCidrMatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the LongestPrefixMatches property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLongestPrefixMatches() {
        return longestPrefixMatches != null && !(longestPrefixMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The most specific route that matches the traffic (longest prefix match).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLongestPrefixMatches} method.
     * </p>
     * 
     * @return The most specific route that matches the traffic (longest prefix match).
     */
    public final List<String> longestPrefixMatches() {
        return longestPrefixMatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetOfMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetOfMatches() {
        return subnetOfMatches != null && !(subnetOfMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes with a subnet that match the specified CIDR filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetOfMatches} method.
     * </p>
     * 
     * @return The routes with a subnet that match the specified CIDR filter.
     */
    public final List<String> subnetOfMatches() {
        return subnetOfMatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupernetOfMatches property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupernetOfMatches() {
        return supernetOfMatches != null && !(supernetOfMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result
     * returns 10.0.1.0/29.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupernetOfMatches} method.
     * </p>
     * 
     * @return The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the
     *         result returns 10.0.1.0/29.
     */
    public final List<String> supernetOfMatches() {
        return supernetOfMatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrefixListIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrefixListIds() {
        return prefixListIds != null && !(prefixListIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the prefix lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrefixListIds} method.
     * </p>
     * 
     * @return The IDs of the prefix lists.
     */
    public final List<String> prefixListIds() {
        return prefixListIds;
    }

    /**
     * <p>
     * The route states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return The route states.
     */
    public final List<RouteState> states() {
        return RouteStateListCopier.copyStringToEnum(states);
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The route states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return The route states.
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The route types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The route types.
     */
    public final List<RouteType> types() {
        return RouteTypeListCopier.copyStringToEnum(types);
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The route types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The route types.
     */
    public final List<String> typesAsStrings() {
        return types;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationFilters() {
        return destinationFilters != null && !(destinationFilters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationFilters} method.
     * </p>
     * 
     * @return Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or
     *         RESOURCE_TYPE.
     */
    public final Map<String, List<String>> destinationFilters() {
        return destinationFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasExactCidrMatches() ? exactCidrMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLongestPrefixMatches() ? longestPrefixMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetOfMatches() ? subnetOfMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupernetOfMatches() ? supernetOfMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrefixListIds() ? prefixListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? typesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationFilters() ? destinationFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkRoutesRequest)) {
            return false;
        }
        GetNetworkRoutesRequest other = (GetNetworkRoutesRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && Objects.equals(routeTableIdentifier(), other.routeTableIdentifier())
                && hasExactCidrMatches() == other.hasExactCidrMatches()
                && Objects.equals(exactCidrMatches(), other.exactCidrMatches())
                && hasLongestPrefixMatches() == other.hasLongestPrefixMatches()
                && Objects.equals(longestPrefixMatches(), other.longestPrefixMatches())
                && hasSubnetOfMatches() == other.hasSubnetOfMatches()
                && Objects.equals(subnetOfMatches(), other.subnetOfMatches())
                && hasSupernetOfMatches() == other.hasSupernetOfMatches()
                && Objects.equals(supernetOfMatches(), other.supernetOfMatches())
                && hasPrefixListIds() == other.hasPrefixListIds() && Objects.equals(prefixListIds(), other.prefixListIds())
                && hasStates() == other.hasStates() && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && hasTypes() == other.hasTypes() && Objects.equals(typesAsStrings(), other.typesAsStrings())
                && hasDestinationFilters() == other.hasDestinationFilters()
                && Objects.equals(destinationFilters(), other.destinationFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkRoutesRequest").add("GlobalNetworkId", globalNetworkId())
                .add("RouteTableIdentifier", routeTableIdentifier())
                .add("ExactCidrMatches", hasExactCidrMatches() ? exactCidrMatches() : null)
                .add("LongestPrefixMatches", hasLongestPrefixMatches() ? longestPrefixMatches() : null)
                .add("SubnetOfMatches", hasSubnetOfMatches() ? subnetOfMatches() : null)
                .add("SupernetOfMatches", hasSupernetOfMatches() ? supernetOfMatches() : null)
                .add("PrefixListIds", hasPrefixListIds() ? prefixListIds() : null)
                .add("States", hasStates() ? statesAsStrings() : null).add("Types", hasTypes() ? typesAsStrings() : null)
                .add("DestinationFilters", hasDestinationFilters() ? destinationFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "RouteTableIdentifier":
            return Optional.ofNullable(clazz.cast(routeTableIdentifier()));
        case "ExactCidrMatches":
            return Optional.ofNullable(clazz.cast(exactCidrMatches()));
        case "LongestPrefixMatches":
            return Optional.ofNullable(clazz.cast(longestPrefixMatches()));
        case "SubnetOfMatches":
            return Optional.ofNullable(clazz.cast(subnetOfMatches()));
        case "SupernetOfMatches":
            return Optional.ofNullable(clazz.cast(supernetOfMatches()));
        case "PrefixListIds":
            return Optional.ofNullable(clazz.cast(prefixListIds()));
        case "States":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "Types":
            return Optional.ofNullable(clazz.cast(typesAsStrings()));
        case "DestinationFilters":
            return Optional.ofNullable(clazz.cast(destinationFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkRoutesRequest, T> g) {
        return obj -> g.apply((GetNetworkRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetNetworkRoutesRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableIdentifier
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIdentifier(RouteTableIdentifier routeTableIdentifier);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteTableIdentifier.Builder} avoiding the need
         * to create one manually via {@link RouteTableIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteTableIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #routeTableIdentifier(RouteTableIdentifier)}.
         * 
         * @param routeTableIdentifier
         *        a consumer that will call methods on {@link RouteTableIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableIdentifier(RouteTableIdentifier)
         */
        default Builder routeTableIdentifier(Consumer<RouteTableIdentifier.Builder> routeTableIdentifier) {
            return routeTableIdentifier(RouteTableIdentifier.builder().applyMutation(routeTableIdentifier).build());
        }

        /**
         * <p>
         * An exact CIDR block.
         * </p>
         * 
         * @param exactCidrMatches
         *        An exact CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactCidrMatches(Collection<String> exactCidrMatches);

        /**
         * <p>
         * An exact CIDR block.
         * </p>
         * 
         * @param exactCidrMatches
         *        An exact CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactCidrMatches(String... exactCidrMatches);

        /**
         * <p>
         * The most specific route that matches the traffic (longest prefix match).
         * </p>
         * 
         * @param longestPrefixMatches
         *        The most specific route that matches the traffic (longest prefix match).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longestPrefixMatches(Collection<String> longestPrefixMatches);

        /**
         * <p>
         * The most specific route that matches the traffic (longest prefix match).
         * </p>
         * 
         * @param longestPrefixMatches
         *        The most specific route that matches the traffic (longest prefix match).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longestPrefixMatches(String... longestPrefixMatches);

        /**
         * <p>
         * The routes with a subnet that match the specified CIDR filter.
         * </p>
         * 
         * @param subnetOfMatches
         *        The routes with a subnet that match the specified CIDR filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetOfMatches(Collection<String> subnetOfMatches);

        /**
         * <p>
         * The routes with a subnet that match the specified CIDR filter.
         * </p>
         * 
         * @param subnetOfMatches
         *        The routes with a subnet that match the specified CIDR filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetOfMatches(String... subnetOfMatches);

        /**
         * <p>
         * The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result
         * returns 10.0.1.0/29.
         * </p>
         * 
         * @param supernetOfMatches
         *        The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the
         *        result returns 10.0.1.0/29.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supernetOfMatches(Collection<String> supernetOfMatches);

        /**
         * <p>
         * The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result
         * returns 10.0.1.0/29.
         * </p>
         * 
         * @param supernetOfMatches
         *        The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the
         *        result returns 10.0.1.0/29.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supernetOfMatches(String... supernetOfMatches);

        /**
         * <p>
         * The IDs of the prefix lists.
         * </p>
         * 
         * @param prefixListIds
         *        The IDs of the prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<String> prefixListIds);

        /**
         * <p>
         * The IDs of the prefix lists.
         * </p>
         * 
         * @param prefixListIds
         *        The IDs of the prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(String... prefixListIds);

        /**
         * <p>
         * The route states.
         * </p>
         * 
         * @param states
         *        The route states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * The route states.
         * </p>
         * 
         * @param states
         *        The route states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * The route states.
         * </p>
         * 
         * @param states
         *        The route states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<RouteState> states);

        /**
         * <p>
         * The route states.
         * </p>
         * 
         * @param states
         *        The route states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(RouteState... states);

        /**
         * <p>
         * The route types.
         * </p>
         * 
         * @param types
         *        The route types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(Collection<String> types);

        /**
         * <p>
         * The route types.
         * </p>
         * 
         * @param types
         *        The route types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(String... types);

        /**
         * <p>
         * The route types.
         * </p>
         * 
         * @param types
         *        The route types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<RouteType> types);

        /**
         * <p>
         * The route types.
         * </p>
         * 
         * @param types
         *        The route types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(RouteType... types);

        /**
         * <p>
         * Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or
         * RESOURCE_TYPE.
         * </p>
         * 
         * @param destinationFilters
         *        Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or
         *        RESOURCE_TYPE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFilters(Map<String, ? extends Collection<String>> destinationFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private RouteTableIdentifier routeTableIdentifier;

        private List<String> exactCidrMatches = DefaultSdkAutoConstructList.getInstance();

        private List<String> longestPrefixMatches = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetOfMatches = DefaultSdkAutoConstructList.getInstance();

        private List<String> supernetOfMatches = DefaultSdkAutoConstructList.getInstance();

        private List<String> prefixListIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> destinationFilters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkRoutesRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            routeTableIdentifier(model.routeTableIdentifier);
            exactCidrMatches(model.exactCidrMatches);
            longestPrefixMatches(model.longestPrefixMatches);
            subnetOfMatches(model.subnetOfMatches);
            supernetOfMatches(model.supernetOfMatches);
            prefixListIds(model.prefixListIds);
            statesWithStrings(model.states);
            typesWithStrings(model.types);
            destinationFilters(model.destinationFilters);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final RouteTableIdentifier.Builder getRouteTableIdentifier() {
            return routeTableIdentifier != null ? routeTableIdentifier.toBuilder() : null;
        }

        public final void setRouteTableIdentifier(RouteTableIdentifier.BuilderImpl routeTableIdentifier) {
            this.routeTableIdentifier = routeTableIdentifier != null ? routeTableIdentifier.build() : null;
        }

        @Override
        @Transient
        public final Builder routeTableIdentifier(RouteTableIdentifier routeTableIdentifier) {
            this.routeTableIdentifier = routeTableIdentifier;
            return this;
        }

        public final Collection<String> getExactCidrMatches() {
            if (exactCidrMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return exactCidrMatches;
        }

        public final void setExactCidrMatches(Collection<String> exactCidrMatches) {
            this.exactCidrMatches = StringListCopier.copy(exactCidrMatches);
        }

        @Override
        @Transient
        public final Builder exactCidrMatches(Collection<String> exactCidrMatches) {
            this.exactCidrMatches = StringListCopier.copy(exactCidrMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exactCidrMatches(String... exactCidrMatches) {
            exactCidrMatches(Arrays.asList(exactCidrMatches));
            return this;
        }

        public final Collection<String> getLongestPrefixMatches() {
            if (longestPrefixMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return longestPrefixMatches;
        }

        public final void setLongestPrefixMatches(Collection<String> longestPrefixMatches) {
            this.longestPrefixMatches = StringListCopier.copy(longestPrefixMatches);
        }

        @Override
        @Transient
        public final Builder longestPrefixMatches(Collection<String> longestPrefixMatches) {
            this.longestPrefixMatches = StringListCopier.copy(longestPrefixMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder longestPrefixMatches(String... longestPrefixMatches) {
            longestPrefixMatches(Arrays.asList(longestPrefixMatches));
            return this;
        }

        public final Collection<String> getSubnetOfMatches() {
            if (subnetOfMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetOfMatches;
        }

        public final void setSubnetOfMatches(Collection<String> subnetOfMatches) {
            this.subnetOfMatches = StringListCopier.copy(subnetOfMatches);
        }

        @Override
        @Transient
        public final Builder subnetOfMatches(Collection<String> subnetOfMatches) {
            this.subnetOfMatches = StringListCopier.copy(subnetOfMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetOfMatches(String... subnetOfMatches) {
            subnetOfMatches(Arrays.asList(subnetOfMatches));
            return this;
        }

        public final Collection<String> getSupernetOfMatches() {
            if (supernetOfMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return supernetOfMatches;
        }

        public final void setSupernetOfMatches(Collection<String> supernetOfMatches) {
            this.supernetOfMatches = StringListCopier.copy(supernetOfMatches);
        }

        @Override
        @Transient
        public final Builder supernetOfMatches(Collection<String> supernetOfMatches) {
            this.supernetOfMatches = StringListCopier.copy(supernetOfMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supernetOfMatches(String... supernetOfMatches) {
            supernetOfMatches(Arrays.asList(supernetOfMatches));
            return this;
        }

        public final Collection<String> getPrefixListIds() {
            if (prefixListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return prefixListIds;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = StringListCopier.copy(prefixListIds);
        }

        @Override
        @Transient
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = StringListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder prefixListIds(String... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        public final void setStates(Collection<String> states) {
            this.states = RouteStateListCopier.copy(states);
        }

        @Override
        @Transient
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = RouteStateListCopier.copy(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        @Transient
        public final Builder states(Collection<RouteState> states) {
            this.states = RouteStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder states(RouteState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = RouteTypeListCopier.copy(types);
        }

        @Override
        @Transient
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = RouteTypeListCopier.copy(types);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder typesWithStrings(String... types) {
            typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        @Transient
        public final Builder types(Collection<RouteType> types) {
            this.types = RouteTypeListCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder types(RouteType... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getDestinationFilters() {
            if (destinationFilters instanceof SdkAutoConstructMap) {
                return null;
            }
            return destinationFilters;
        }

        public final void setDestinationFilters(Map<String, ? extends Collection<String>> destinationFilters) {
            this.destinationFilters = FilterMapCopier.copy(destinationFilters);
        }

        @Override
        @Transient
        public final Builder destinationFilters(Map<String, ? extends Collection<String>> destinationFilters) {
            this.destinationFilters = FilterMapCopier.copy(destinationFilters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNetworkRoutesRequest build() {
            return new GetNetworkRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
