/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkRoutesResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetNetworkRoutesResponse.Builder, GetNetworkRoutesResponse> {
    private static final SdkField<String> ROUTE_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableArn").getter(getter(GetNetworkRoutesResponse::routeTableArn))
            .setter(setter(Builder::routeTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableArn").build()).build();

    private static final SdkField<String> ROUTE_TABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableType").getter(getter(GetNetworkRoutesResponse::routeTableTypeAsString))
            .setter(setter(Builder::routeTableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableType").build()).build();

    private static final SdkField<Instant> ROUTE_TABLE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RouteTableTimestamp").getter(getter(GetNetworkRoutesResponse::routeTableTimestamp))
            .setter(setter(Builder::routeTableTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableTimestamp").build())
            .build();

    private static final SdkField<List<NetworkRoute>> NETWORK_ROUTES_FIELD = SdkField
            .<List<NetworkRoute>> builder(MarshallingType.LIST)
            .memberName("NetworkRoutes")
            .getter(getter(GetNetworkRoutesResponse::networkRoutes))
            .setter(setter(Builder::networkRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_ARN_FIELD,
            ROUTE_TABLE_TYPE_FIELD, ROUTE_TABLE_TIMESTAMP_FIELD, NETWORK_ROUTES_FIELD));

    private final String routeTableArn;

    private final String routeTableType;

    private final Instant routeTableTimestamp;

    private final List<NetworkRoute> networkRoutes;

    private GetNetworkRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.routeTableArn = builder.routeTableArn;
        this.routeTableType = builder.routeTableType;
        this.routeTableTimestamp = builder.routeTableTimestamp;
        this.networkRoutes = builder.networkRoutes;
    }

    /**
     * <p>
     * The ARN of the route table.
     * </p>
     * 
     * @return The ARN of the route table.
     */
    public final String routeTableArn() {
        return routeTableArn;
    }

    /**
     * <p>
     * The route table type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeTableType}
     * will return {@link RouteTableType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routeTableTypeAsString}.
     * </p>
     * 
     * @return The route table type.
     * @see RouteTableType
     */
    public final RouteTableType routeTableType() {
        return RouteTableType.fromValue(routeTableType);
    }

    /**
     * <p>
     * The route table type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeTableType}
     * will return {@link RouteTableType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routeTableTypeAsString}.
     * </p>
     * 
     * @return The route table type.
     * @see RouteTableType
     */
    public final String routeTableTypeAsString() {
        return routeTableType;
    }

    /**
     * <p>
     * The route table creation time.
     * </p>
     * 
     * @return The route table creation time.
     */
    public final Instant routeTableTimestamp() {
        return routeTableTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkRoutes() {
        return networkRoutes != null && !(networkRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkRoutes} method.
     * </p>
     * 
     * @return The network routes.
     */
    public final List<NetworkRoute> networkRoutes() {
        return networkRoutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkRoutes() ? networkRoutes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkRoutesResponse)) {
            return false;
        }
        GetNetworkRoutesResponse other = (GetNetworkRoutesResponse) obj;
        return Objects.equals(routeTableArn(), other.routeTableArn())
                && Objects.equals(routeTableTypeAsString(), other.routeTableTypeAsString())
                && Objects.equals(routeTableTimestamp(), other.routeTableTimestamp())
                && hasNetworkRoutes() == other.hasNetworkRoutes() && Objects.equals(networkRoutes(), other.networkRoutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkRoutesResponse").add("RouteTableArn", routeTableArn())
                .add("RouteTableType", routeTableTypeAsString()).add("RouteTableTimestamp", routeTableTimestamp())
                .add("NetworkRoutes", hasNetworkRoutes() ? networkRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteTableArn":
            return Optional.ofNullable(clazz.cast(routeTableArn()));
        case "RouteTableType":
            return Optional.ofNullable(clazz.cast(routeTableTypeAsString()));
        case "RouteTableTimestamp":
            return Optional.ofNullable(clazz.cast(routeTableTimestamp()));
        case "NetworkRoutes":
            return Optional.ofNullable(clazz.cast(networkRoutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkRoutesResponse, T> g) {
        return obj -> g.apply((GetNetworkRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetNetworkRoutesResponse> {
        /**
         * <p>
         * The ARN of the route table.
         * </p>
         * 
         * @param routeTableArn
         *        The ARN of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableArn(String routeTableArn);

        /**
         * <p>
         * The route table type.
         * </p>
         * 
         * @param routeTableType
         *        The route table type.
         * @see RouteTableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTableType
         */
        Builder routeTableType(String routeTableType);

        /**
         * <p>
         * The route table type.
         * </p>
         * 
         * @param routeTableType
         *        The route table type.
         * @see RouteTableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTableType
         */
        Builder routeTableType(RouteTableType routeTableType);

        /**
         * <p>
         * The route table creation time.
         * </p>
         * 
         * @param routeTableTimestamp
         *        The route table creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableTimestamp(Instant routeTableTimestamp);

        /**
         * <p>
         * The network routes.
         * </p>
         * 
         * @param networkRoutes
         *        The network routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkRoutes(Collection<NetworkRoute> networkRoutes);

        /**
         * <p>
         * The network routes.
         * </p>
         * 
         * @param networkRoutes
         *        The network routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkRoutes(NetworkRoute... networkRoutes);

        /**
         * <p>
         * The network routes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkRoute>.Builder} avoiding the need to
         * create one manually via {@link List<NetworkRoute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkRoute>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkRoutes(List<NetworkRoute>)}.
         * 
         * @param networkRoutes
         *        a consumer that will call methods on {@link List<NetworkRoute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkRoutes(List<NetworkRoute>)
         */
        Builder networkRoutes(Consumer<NetworkRoute.Builder>... networkRoutes);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private String routeTableArn;

        private String routeTableType;

        private Instant routeTableTimestamp;

        private List<NetworkRoute> networkRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkRoutesResponse model) {
            super(model);
            routeTableArn(model.routeTableArn);
            routeTableType(model.routeTableType);
            routeTableTimestamp(model.routeTableTimestamp);
            networkRoutes(model.networkRoutes);
        }

        public final String getRouteTableArn() {
            return routeTableArn;
        }

        public final void setRouteTableArn(String routeTableArn) {
            this.routeTableArn = routeTableArn;
        }

        @Override
        @Transient
        public final Builder routeTableArn(String routeTableArn) {
            this.routeTableArn = routeTableArn;
            return this;
        }

        public final String getRouteTableType() {
            return routeTableType;
        }

        public final void setRouteTableType(String routeTableType) {
            this.routeTableType = routeTableType;
        }

        @Override
        @Transient
        public final Builder routeTableType(String routeTableType) {
            this.routeTableType = routeTableType;
            return this;
        }

        @Override
        @Transient
        public final Builder routeTableType(RouteTableType routeTableType) {
            this.routeTableType(routeTableType == null ? null : routeTableType.toString());
            return this;
        }

        public final Instant getRouteTableTimestamp() {
            return routeTableTimestamp;
        }

        public final void setRouteTableTimestamp(Instant routeTableTimestamp) {
            this.routeTableTimestamp = routeTableTimestamp;
        }

        @Override
        @Transient
        public final Builder routeTableTimestamp(Instant routeTableTimestamp) {
            this.routeTableTimestamp = routeTableTimestamp;
            return this;
        }

        public final List<NetworkRoute.Builder> getNetworkRoutes() {
            List<NetworkRoute.Builder> result = NetworkRouteListCopier.copyToBuilder(this.networkRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkRoutes(Collection<NetworkRoute.BuilderImpl> networkRoutes) {
            this.networkRoutes = NetworkRouteListCopier.copyFromBuilder(networkRoutes);
        }

        @Override
        @Transient
        public final Builder networkRoutes(Collection<NetworkRoute> networkRoutes) {
            this.networkRoutes = NetworkRouteListCopier.copy(networkRoutes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkRoutes(NetworkRoute... networkRoutes) {
            networkRoutes(Arrays.asList(networkRoutes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkRoutes(Consumer<NetworkRoute.Builder>... networkRoutes) {
            networkRoutes(Stream.of(networkRoutes).map(c -> NetworkRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetNetworkRoutesResponse build() {
            return new GetNetworkRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
