/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a site-to-site VPN attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SiteToSiteVpnAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<SiteToSiteVpnAttachment.Builder, SiteToSiteVpnAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment").getter(getter(SiteToSiteVpnAttachment::attachment)).setter(setter(Builder::attachment))
            .constructor(Attachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final SdkField<String> VPN_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionArn").getter(getter(SiteToSiteVpnAttachment::vpnConnectionArn))
            .setter(setter(Builder::vpnConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            VPN_CONNECTION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Attachment attachment;

    private final String vpnConnectionArn;

    private SiteToSiteVpnAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.vpnConnectionArn = builder.vpnConnectionArn;
    }

    /**
     * <p>
     * Provides details about a site-to-site VPN attachment.
     * </p>
     * 
     * @return Provides details about a site-to-site VPN attachment.
     */
    public final Attachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The ARN of the site-to-site VPN attachment.
     * </p>
     * 
     * @return The ARN of the site-to-site VPN attachment.
     */
    public final String vpnConnectionArn() {
        return vpnConnectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SiteToSiteVpnAttachment)) {
            return false;
        }
        SiteToSiteVpnAttachment other = (SiteToSiteVpnAttachment) obj;
        return Objects.equals(attachment(), other.attachment()) && Objects.equals(vpnConnectionArn(), other.vpnConnectionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SiteToSiteVpnAttachment").add("Attachment", attachment())
                .add("VpnConnectionArn", vpnConnectionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "VpnConnectionArn":
            return Optional.ofNullable(clazz.cast(vpnConnectionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SiteToSiteVpnAttachment, T> g) {
        return obj -> g.apply((SiteToSiteVpnAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SiteToSiteVpnAttachment> {
        /**
         * <p>
         * Provides details about a site-to-site VPN attachment.
         * </p>
         * 
         * @param attachment
         *        Provides details about a site-to-site VPN attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(Attachment attachment);

        /**
         * <p>
         * Provides details about a site-to-site VPN attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachment.Builder} avoiding the need to
         * create one manually via {@link Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attachment.Builder#build()} is called immediately and its result
         * is passed to {@link #attachment(Attachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(Attachment)
         */
        default Builder attachment(Consumer<Attachment.Builder> attachment) {
            return attachment(Attachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The ARN of the site-to-site VPN attachment.
         * </p>
         * 
         * @param vpnConnectionArn
         *        The ARN of the site-to-site VPN attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionArn(String vpnConnectionArn);
    }

    static final class BuilderImpl implements Builder {
        private Attachment attachment;

        private String vpnConnectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SiteToSiteVpnAttachment model) {
            attachment(model.attachment);
            vpnConnectionArn(model.vpnConnectionArn);
        }

        public final Attachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getVpnConnectionArn() {
            return vpnConnectionArn;
        }

        public final void setVpnConnectionArn(String vpnConnectionArn) {
            this.vpnConnectionArn = vpnConnectionArn;
        }

        @Override
        public final Builder vpnConnectionArn(String vpnConnectionArn) {
            this.vpnConnectionArn = vpnConnectionArn;
            return this;
        }

        @Override
        public SiteToSiteVpnAttachment build() {
            return new SiteToSiteVpnAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
