/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayRouteTableAttachmentRequest extends NetworkManagerRequest
        implements
        ToCopyableBuilder<CreateTransitGatewayRouteTableAttachmentRequest.Builder, CreateTransitGatewayRouteTableAttachmentRequest> {
    private static final SdkField<String> PEERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeeringId").getter(getter(CreateTransitGatewayRouteTableAttachmentRequest::peeringId))
            .setter(setter(Builder::peeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayRouteTableArn")
            .getter(getter(CreateTransitGatewayRouteTableAttachmentRequest::transitGatewayRouteTableArn))
            .setter(setter(Builder::transitGatewayRouteTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableArn")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTransitGatewayRouteTableAttachmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTransitGatewayRouteTableAttachmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEERING_ID_FIELD,
            TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String peeringId;

    private final String transitGatewayRouteTableArn;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateTransitGatewayRouteTableAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.peeringId = builder.peeringId;
        this.transitGatewayRouteTableArn = builder.transitGatewayRouteTableArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the peer for the
     * </p>
     * 
     * @return The ID of the peer for the
     */
    public final String peeringId() {
        return peeringId;
    }

    /**
     * <p>
     * The ARN of the transit gateway route table for the attachment request.
     * </p>
     * 
     * @return The ARN of the transit gateway route table for the attachment request.
     */
    public final String transitGatewayRouteTableArn() {
        return transitGatewayRouteTableArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key-value tags associated with the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value tags associated with the request.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(peeringId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayRouteTableAttachmentRequest)) {
            return false;
        }
        CreateTransitGatewayRouteTableAttachmentRequest other = (CreateTransitGatewayRouteTableAttachmentRequest) obj;
        return Objects.equals(peeringId(), other.peeringId())
                && Objects.equals(transitGatewayRouteTableArn(), other.transitGatewayRouteTableArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayRouteTableAttachmentRequest").add("PeeringId", peeringId())
                .add("TransitGatewayRouteTableArn", transitGatewayRouteTableArn()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeeringId":
            return Optional.ofNullable(clazz.cast(peeringId()));
        case "TransitGatewayRouteTableArn":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayRouteTableAttachmentRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayRouteTableAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayRouteTableAttachmentRequest> {
        /**
         * <p>
         * The ID of the peer for the
         * </p>
         * 
         * @param peeringId
         *        The ID of the peer for the
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringId(String peeringId);

        /**
         * <p>
         * The ARN of the transit gateway route table for the attachment request.
         * </p>
         * 
         * @param transitGatewayRouteTableArn
         *        The ARN of the transit gateway route table for the attachment request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableArn(String transitGatewayRouteTableArn);

        /**
         * <p>
         * The list of key-value tags associated with the request.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of key-value tags associated with the request.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of key-value tags associated with the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String peeringId;

        private String transitGatewayRouteTableArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayRouteTableAttachmentRequest model) {
            super(model);
            peeringId(model.peeringId);
            transitGatewayRouteTableArn(model.transitGatewayRouteTableArn);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getPeeringId() {
            return peeringId;
        }

        public final void setPeeringId(String peeringId) {
            this.peeringId = peeringId;
        }

        @Override
        public final Builder peeringId(String peeringId) {
            this.peeringId = peeringId;
            return this;
        }

        public final String getTransitGatewayRouteTableArn() {
            return transitGatewayRouteTableArn;
        }

        public final void setTransitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
        }

        @Override
        public final Builder transitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayRouteTableAttachmentRequest build() {
            return new CreateTransitGatewayRouteTableAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
