/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.AccessDeniedException;
import software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.ConflictException;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyException;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest;
import software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest;
import software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinksRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinksResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse;
import software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest;
import software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisResponse;
import software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.GetSitesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSitesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.InternalServerException;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusRequest;
import software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerException;
import software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionRequest;
import software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse;
import software.amazon.awssdk.services.networkmanager.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateRequest;
import software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse;
import software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest;
import software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse;
import software.amazon.awssdk.services.networkmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.ThrottlingException;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.ValidationException;
import software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable;
import software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable;

/**
 * Service client for accessing NetworkManager. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services enables you to centrally manage your Amazon Web Services Cloud WAN core network and your Transit
 * Gateway network across Amazon Web Services accounts, Regions, and on-premises locations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkManagerClient extends AwsClient {
    String SERVICE_NAME = "networkmanager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "networkmanager";

    /**
     * <p>
     * Accepts a core network attachment request.
     * </p>
     * <p>
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a
     * core network.
     * </p>
     *
     * @param acceptAttachmentRequest
     * @return Result of the AcceptAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AcceptAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AcceptAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAttachmentResponse acceptAttachment(AcceptAttachmentRequest acceptAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a core network attachment request.
     * </p>
     * <p>
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a
     * core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link AcceptAttachmentRequest.Builder} to create a request.
     * @return Result of the AcceptAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AcceptAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AcceptAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAttachmentResponse acceptAttachment(Consumer<AcceptAttachmentRequest.Builder> acceptAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return acceptAttachment(AcceptAttachmentRequest.builder().applyMutation(acceptAttachmentRequest).build());
    }

    /**
     * <p>
     * Associates a core network Connect peer with a device and optionally, with a link.
     * </p>
     * <p>
     * If you specify a link, it must be associated with the specified device. You can only associate core network
     * Connect peers that have been created on a core network Connect attachment on a core network.
     * </p>
     *
     * @param associateConnectPeerRequest
     * @return Result of the AssociateConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateConnectPeerResponse associateConnectPeer(AssociateConnectPeerRequest associateConnectPeerRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a core network Connect peer with a device and optionally, with a link.
     * </p>
     * <p>
     * If you specify a link, it must be associated with the specified device. You can only associate core network
     * Connect peers that have been created on a core network Connect attachment on a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateConnectPeerRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateConnectPeerRequest#builder()}
     * </p>
     *
     * @param associateConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateConnectPeerRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateConnectPeerResponse associateConnectPeer(
            Consumer<AssociateConnectPeerRequest.Builder> associateConnectPeerRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return associateConnectPeer(AssociateConnectPeerRequest.builder().applyMutation(associateConnectPeerRequest).build());
    }

    /**
     * <p>
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be
     * associated with the specified device.
     * </p>
     * <p>
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core
     * network registered in your global network. When you register a transit gateway or core network, customer gateways
     * that are connected to the transit gateway are automatically included in the global network. To list customer
     * gateways that are connected to a transit gateway, use the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html"
     * >DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.
     * </p>
     * <p>
     * You cannot associate a customer gateway with more than one device and link.
     * </p>
     *
     * @param associateCustomerGatewayRequest
     * @return Result of the AssociateCustomerGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCustomerGatewayResponse associateCustomerGateway(
            AssociateCustomerGatewayRequest associateCustomerGatewayRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be
     * associated with the specified device.
     * </p>
     * <p>
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core
     * network registered in your global network. When you register a transit gateway or core network, customer gateways
     * that are connected to the transit gateway are automatically included in the global network. To list customer
     * gateways that are connected to a transit gateway, use the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html"
     * >DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.
     * </p>
     * <p>
     * You cannot associate a customer gateway with more than one device and link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateCustomerGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param associateCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on {@link AssociateCustomerGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateCustomerGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCustomerGatewayResponse associateCustomerGateway(
            Consumer<AssociateCustomerGatewayRequest.Builder> associateCustomerGatewayRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return associateCustomerGateway(AssociateCustomerGatewayRequest.builder().applyMutation(associateCustomerGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to
     * multiple devices. The device and link must be in the same global network and the same site.
     * </p>
     *
     * @param associateLinkRequest
     * @return Result of the AssociateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateLink" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateLinkResponse associateLink(AssociateLinkRequest associateLinkRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to
     * multiple devices. The device and link must be in the same global network and the same site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateLinkRequest#builder()}
     * </p>
     *
     * @param associateLinkRequest
     *        A {@link Consumer} that will call methods on {@link AssociateLinkRequest.Builder} to create a request.
     * @return Result of the AssociateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateLink" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateLinkResponse associateLink(Consumer<AssociateLinkRequest.Builder> associateLinkRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        return associateLink(AssociateLinkRequest.builder().applyMutation(associateLinkRequest).build());
    }

    /**
     * <p>
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it
     * must be associated with the specified device.
     * </p>
     * <p>
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's
     * registered in your global network.
     * </p>
     * <p>
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     * </p>
     *
     * @param associateTransitGatewayConnectPeerRequest
     * @return Result of the AssociateTransitGatewayConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayConnectPeerResponse associateTransitGatewayConnectPeer(
            AssociateTransitGatewayConnectPeerRequest associateTransitGatewayConnectPeerRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it
     * must be associated with the specified device.
     * </p>
     * <p>
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's
     * registered in your global network.
     * </p>
     * <p>
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTransitGatewayConnectPeerRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTransitGatewayConnectPeerRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateTransitGatewayConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.AssociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayConnectPeerResponse associateTransitGatewayConnectPeer(
            Consumer<AssociateTransitGatewayConnectPeerRequest.Builder> associateTransitGatewayConnectPeerRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        return associateTransitGatewayConnectPeer(AssociateTransitGatewayConnectPeerRequest.builder()
                .applyMutation(associateTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Creates a core network Connect attachment from a specified core network attachment.
     * </p>
     * <p>
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection
     * between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the
     * underlying transport mechanism.
     * </p>
     *
     * @param createConnectAttachmentRequest
     * @return Result of the CreateConnectAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectAttachmentResponse createConnectAttachment(CreateConnectAttachmentRequest createConnectAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a core network Connect attachment from a specified core network attachment.
     * </p>
     * <p>
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection
     * between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the
     * underlying transport mechanism.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectAttachmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectAttachmentRequest#builder()}
     * </p>
     *
     * @param createConnectAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectAttachmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnectAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectAttachmentResponse createConnectAttachment(
            Consumer<CreateConnectAttachmentRequest.Builder> createConnectAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return createConnectAttachment(CreateConnectAttachmentRequest.builder().applyMutation(createConnectAttachmentRequest)
                .build());
    }

    /**
     * <p>
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an
     * appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     *
     * @param createConnectPeerRequest
     * @return Result of the CreateConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectPeerResponse createConnectPeer(CreateConnectPeerRequest createConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an
     * appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectPeerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectPeerRequest#builder()}
     * </p>
     *
     * @param createConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectPeerRequest.Builder} to create a request.
     * @return Result of the CreateConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectPeerResponse createConnectPeer(Consumer<CreateConnectPeerRequest.Builder> createConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createConnectPeer(CreateConnectPeerRequest.builder().applyMutation(createConnectPeerRequest).build());
    }

    /**
     * <p>
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a
     * third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an
     * on-premises network.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a
     * third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an
     * on-premises network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectionRequest.Builder} to create a request.
     * @return Result of the CreateConnection operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionResponse createConnection(Consumer<CreateConnectionRequest.Builder> createConnectionRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     * </p>
     *
     * @param createCoreNetworkRequest
     * @return Result of the CreateCoreNetwork operation returned by the service.
     * @throws CoreNetworkPolicyException
     *         Describes a core network policy exception.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCoreNetworkResponse createCoreNetwork(CreateCoreNetworkRequest createCoreNetworkRequest)
            throws CoreNetworkPolicyException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoreNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCoreNetworkRequest#builder()}
     * </p>
     *
     * @param createCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateCoreNetworkRequest.Builder} to create a request.
     * @return Result of the CreateCoreNetwork operation returned by the service.
     * @throws CoreNetworkPolicyException
     *         Describes a core network policy exception.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCoreNetworkResponse createCoreNetwork(Consumer<CreateCoreNetworkRequest.Builder> createCoreNetworkRequest)
            throws CoreNetworkPolicyException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        return createCoreNetwork(CreateCoreNetworkRequest.builder().applyMutation(createCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site
     * is used for visualization in the Network Manager console.
     * </p>
     *
     * @param createDeviceRequest
     * @return Result of the CreateDevice operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeviceResponse createDevice(CreateDeviceRequest createDeviceRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site
     * is used for visualization in the Network Manager console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDeviceRequest#builder()}
     * </p>
     *
     * @param createDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceRequest.Builder} to create a request.
     * @return Result of the CreateDevice operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeviceResponse createDevice(Consumer<CreateDeviceRequest.Builder> createDeviceRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        return createDevice(CreateDeviceRequest.builder().applyMutation(createDeviceRequest).build());
    }

    /**
     * <p>
     * Creates a new, empty global network.
     * </p>
     *
     * @param createGlobalNetworkRequest
     * @return Result of the CreateGlobalNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGlobalNetworkResponse createGlobalNetwork(CreateGlobalNetworkRequest createGlobalNetworkRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, empty global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalNetworkRequest#builder()}
     * </p>
     *
     * @param createGlobalNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateGlobalNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGlobalNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGlobalNetworkResponse createGlobalNetwork(
            Consumer<CreateGlobalNetworkRequest.Builder> createGlobalNetworkRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createGlobalNetwork(CreateGlobalNetworkRequest.builder().applyMutation(createGlobalNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a new link for a specified site.
     * </p>
     *
     * @param createLinkRequest
     * @return Result of the CreateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLinkResponse createLink(CreateLinkRequest createLinkRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new link for a specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLinkRequest#builder()}
     * </p>
     *
     * @param createLinkRequest
     *        A {@link Consumer} that will call methods on {@link CreateLinkRequest.Builder} to create a request.
     * @return Result of the CreateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLinkResponse createLink(Consumer<CreateLinkRequest.Builder> createLinkRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createLink(CreateLinkRequest.builder().applyMutation(createLinkRequest).build());
    }

    /**
     * <p>
     * Creates a new site in a global network.
     * </p>
     *
     * @param createSiteRequest
     * @return Result of the CreateSite operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSiteResponse createSite(CreateSiteRequest createSiteRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new site in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSiteRequest#builder()}
     * </p>
     *
     * @param createSiteRequest
     *        A {@link Consumer} that will call methods on {@link CreateSiteRequest.Builder} to create a request.
     * @return Result of the CreateSite operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSiteResponse createSite(Consumer<CreateSiteRequest.Builder> createSiteRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createSite(CreateSiteRequest.builder().applyMutation(createSiteRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     * </p>
     *
     * @param createSiteToSiteVpnAttachmentRequest
     * @return Result of the CreateSiteToSiteVpnAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSiteToSiteVpnAttachmentResponse createSiteToSiteVpnAttachment(
            CreateSiteToSiteVpnAttachmentRequest createSiteToSiteVpnAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteToSiteVpnAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSiteToSiteVpnAttachmentRequest#builder()}
     * </p>
     *
     * @param createSiteToSiteVpnAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateSiteToSiteVpnAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSiteToSiteVpnAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSiteToSiteVpnAttachmentResponse createSiteToSiteVpnAttachment(
            Consumer<CreateSiteToSiteVpnAttachmentRequest.Builder> createSiteToSiteVpnAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createSiteToSiteVpnAttachment(CreateSiteToSiteVpnAttachmentRequest.builder()
                .applyMutation(createSiteToSiteVpnAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway peering connection.
     * </p>
     *
     * @param createTransitGatewayPeeringRequest
     * @return Result of the CreateTransitGatewayPeering operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPeeringResponse createTransitGatewayPeering(
            CreateTransitGatewayPeeringRequest createTransitGatewayPeeringRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayPeeringRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayPeeringRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPeeringRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayPeeringRequest.Builder} to create
     *        a request.
     * @return Result of the CreateTransitGatewayPeering operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPeeringResponse createTransitGatewayPeering(
            Consumer<CreateTransitGatewayPeeringRequest.Builder> createTransitGatewayPeeringRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return createTransitGatewayPeering(CreateTransitGatewayPeeringRequest.builder()
                .applyMutation(createTransitGatewayPeeringRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway route table attachment.
     * </p>
     *
     * @param createTransitGatewayRouteTableAttachmentRequest
     * @return Result of the CreateTransitGatewayRouteTableAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayRouteTableAttachmentResponse createTransitGatewayRouteTableAttachment(
            CreateTransitGatewayRouteTableAttachmentRequest createTransitGatewayRouteTableAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway route table attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayRouteTableAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayRouteTableAttachmentRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteTableAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateTransitGatewayRouteTableAttachmentRequest.Builder} to create a request.
     * @return Result of the CreateTransitGatewayRouteTableAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayRouteTableAttachmentResponse createTransitGatewayRouteTableAttachment(
            Consumer<CreateTransitGatewayRouteTableAttachmentRequest.Builder> createTransitGatewayRouteTableAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return createTransitGatewayRouteTableAttachment(CreateTransitGatewayRouteTableAttachmentRequest.builder()
                .applyMutation(createTransitGatewayRouteTableAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates a VPC attachment on an edge location of a core network.
     * </p>
     *
     * @param createVpcAttachmentRequest
     * @return Result of the CreateVpcAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcAttachmentResponse createVpcAttachment(CreateVpcAttachmentRequest createVpcAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC attachment on an edge location of a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param createVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcAttachmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVpcAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.CreateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcAttachmentResponse createVpcAttachment(
            Consumer<CreateVpcAttachmentRequest.Builder> createVpcAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return createVpcAttachment(CreateVpcAttachmentRequest.builder().applyMutation(createVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes an attachment. Supports all attachment types.
     * </p>
     *
     * @param deleteAttachmentRequest
     * @return Result of the DeleteAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAttachmentResponse deleteAttachment(DeleteAttachmentRequest deleteAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attachment. Supports all attachment types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAttachmentRequest.Builder} to create a request.
     * @return Result of the DeleteAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAttachmentResponse deleteAttachment(Consumer<DeleteAttachmentRequest.Builder> deleteAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteAttachment(DeleteAttachmentRequest.builder().applyMutation(deleteAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes a Connect peer.
     * </p>
     *
     * @param deleteConnectPeerRequest
     * @return Result of the DeleteConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectPeerResponse deleteConnectPeer(DeleteConnectPeerRequest deleteConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Connect peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectPeerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectPeerRequest#builder()}
     * </p>
     *
     * @param deleteConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectPeerRequest.Builder} to create a request.
     * @return Result of the DeleteConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectPeerResponse deleteConnectPeer(Consumer<DeleteConnectPeerRequest.Builder> deleteConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteConnectPeer(DeleteConnectPeerRequest.builder().applyMutation(deleteConnectPeerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified connection in your global network.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connection in your global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectionRequest.Builder} to create a request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on
     * a core network.
     * </p>
     *
     * @param deleteCoreNetworkRequest
     * @return Result of the DeleteCoreNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCoreNetworkResponse deleteCoreNetwork(DeleteCoreNetworkRequest deleteCoreNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on
     * a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCoreNetworkRequest#builder()}
     * </p>
     *
     * @param deleteCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCoreNetworkRequest.Builder} to create a request.
     * @return Result of the DeleteCoreNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCoreNetworkResponse deleteCoreNetwork(Consumer<DeleteCoreNetworkRequest.Builder> deleteCoreNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteCoreNetwork(DeleteCoreNetworkRequest.builder().applyMutation(deleteCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     * </p>
     *
     * @param deleteCoreNetworkPolicyVersionRequest
     * @return Result of the DeleteCoreNetworkPolicyVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCoreNetworkPolicyVersionResponse deleteCoreNetworkPolicyVersion(
            DeleteCoreNetworkPolicyVersionRequest deleteCoreNetworkPolicyVersionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreNetworkPolicyVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCoreNetworkPolicyVersionRequest#builder()}
     * </p>
     *
     * @param deleteCoreNetworkPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCoreNetworkPolicyVersionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCoreNetworkPolicyVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCoreNetworkPolicyVersionResponse deleteCoreNetworkPolicyVersion(
            Consumer<DeleteCoreNetworkPolicyVersionRequest.Builder> deleteCoreNetworkPolicyVersionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteCoreNetworkPolicyVersion(DeleteCoreNetworkPolicyVersionRequest.builder()
                .applyMutation(deleteCoreNetworkPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeviceRequest#builder()}
     * </p>
     *
     * @param deleteDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceRequest.Builder} to create a request.
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeviceResponse deleteDevice(Consumer<DeleteDeviceRequest.Builder> deleteDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteDevice(DeleteDeviceRequest.builder().applyMutation(deleteDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites),
     * deregister all transit gateways, and delete any core networks.
     * </p>
     *
     * @param deleteGlobalNetworkRequest
     * @return Result of the DeleteGlobalNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGlobalNetworkResponse deleteGlobalNetwork(DeleteGlobalNetworkRequest deleteGlobalNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites),
     * deregister all transit gateways, and delete any core networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalNetworkRequest#builder()}
     * </p>
     *
     * @param deleteGlobalNetworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGlobalNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGlobalNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGlobalNetworkResponse deleteGlobalNetwork(
            Consumer<DeleteGlobalNetworkRequest.Builder> deleteGlobalNetworkRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteGlobalNetwork(DeleteGlobalNetworkRequest.builder().applyMutation(deleteGlobalNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     * </p>
     *
     * @param deleteLinkRequest
     * @return Result of the DeleteLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLinkResponse deleteLink(DeleteLinkRequest deleteLinkRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLinkRequest#builder()}
     * </p>
     *
     * @param deleteLinkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLinkRequest.Builder} to create a request.
     * @return Result of the DeleteLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLinkResponse deleteLink(Consumer<DeleteLinkRequest.Builder> deleteLinkRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteLink(DeleteLinkRequest.builder().applyMutation(deleteLinkRequest).build());
    }

    /**
     * <p>
     * Deletes an existing peering connection.
     * </p>
     *
     * @param deletePeeringRequest
     * @return Result of the DeletePeering operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeletePeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeletePeering" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePeeringResponse deletePeering(DeletePeeringRequest deletePeeringRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePeeringRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePeeringRequest#builder()}
     * </p>
     *
     * @param deletePeeringRequest
     *        A {@link Consumer} that will call methods on {@link DeletePeeringRequest.Builder} to create a request.
     * @return Result of the DeletePeering operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeletePeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeletePeering" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePeeringResponse deletePeering(Consumer<DeletePeeringRequest.Builder> deletePeeringRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return deletePeering(DeletePeeringRequest.builder().applyMutation(deletePeeringRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the
     * resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the
     * resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing site. The site cannot be associated with any device or link.
     * </p>
     *
     * @param deleteSiteRequest
     * @return Result of the DeleteSite operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSiteResponse deleteSite(DeleteSiteRequest deleteSiteRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing site. The site cannot be associated with any device or link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSiteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSiteRequest#builder()}
     * </p>
     *
     * @param deleteSiteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSiteRequest.Builder} to create a request.
     * @return Result of the DeleteSite operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSiteResponse deleteSite(Consumer<DeleteSiteRequest.Builder> deleteSiteRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return deleteSite(DeleteSiteRequest.builder().applyMutation(deleteSiteRequest).build());
    }

    /**
     * <p>
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or
     * modify any of its attachments. This action removes any customer gateway associations.
     * </p>
     *
     * @param deregisterTransitGatewayRequest
     * @return Result of the DeregisterTransitGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeregisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeregisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTransitGatewayResponse deregisterTransitGateway(
            DeregisterTransitGatewayRequest deregisterTransitGatewayRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or
     * modify any of its attachments. This action removes any customer gateway associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTransitGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterTransitGatewayRequest#builder()}
     * </p>
     *
     * @param deregisterTransitGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTransitGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterTransitGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DeregisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeregisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTransitGatewayResponse deregisterTransitGateway(
            Consumer<DeregisterTransitGatewayRequest.Builder> deregisterTransitGatewayRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return deregisterTransitGateway(DeregisterTransitGatewayRequest.builder().applyMutation(deregisterTransitGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     *
     * @param describeGlobalNetworksRequest
     * @return Result of the DescribeGlobalNetworks operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalNetworksResponse describeGlobalNetworks(DescribeGlobalNetworksRequest describeGlobalNetworksRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalNetworksRequest#builder()}
     * </p>
     *
     * @param describeGlobalNetworksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalNetworksRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeGlobalNetworks operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalNetworksResponse describeGlobalNetworks(
            Consumer<DescribeGlobalNetworksRequest.Builder> describeGlobalNetworksRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return describeGlobalNetworks(DescribeGlobalNetworksRequest.builder().applyMutation(describeGlobalNetworksRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable responses = client.describeGlobalNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable responses = client
     *             .describeGlobalNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable responses = client.describeGlobalNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalNetworksIterable describeGlobalNetworksPaginator(
            DescribeGlobalNetworksRequest describeGlobalNetworksRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable responses = client.describeGlobalNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable responses = client
     *             .describeGlobalNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable responses = client.describeGlobalNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalNetworksRequest#builder()}
     * </p>
     *
     * @param describeGlobalNetworksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalNetworksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalNetworksIterable describeGlobalNetworksPaginator(
            Consumer<DescribeGlobalNetworksRequest.Builder> describeGlobalNetworksRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return describeGlobalNetworksPaginator(DescribeGlobalNetworksRequest.builder()
                .applyMutation(describeGlobalNetworksRequest).build());
    }

    /**
     * <p>
     * Disassociates a core network Connect peer from a device and a link.
     * </p>
     *
     * @param disassociateConnectPeerRequest
     * @return Result of the DisassociateConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateConnectPeerResponse disassociateConnectPeer(DisassociateConnectPeerRequest disassociateConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a core network Connect peer from a device and a link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateConnectPeerRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateConnectPeerRequest#builder()}
     * </p>
     *
     * @param disassociateConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateConnectPeerRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateConnectPeerResponse disassociateConnectPeer(
            Consumer<DisassociateConnectPeerRequest.Builder> disassociateConnectPeerRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return disassociateConnectPeer(DisassociateConnectPeerRequest.builder().applyMutation(disassociateConnectPeerRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a customer gateway from a device and a link.
     * </p>
     *
     * @param disassociateCustomerGatewayRequest
     * @return Result of the DisassociateCustomerGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateCustomerGatewayResponse disassociateCustomerGateway(
            DisassociateCustomerGatewayRequest disassociateCustomerGatewayRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a customer gateway from a device and a link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateCustomerGatewayRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param disassociateCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateCustomerGatewayRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateCustomerGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateCustomerGatewayResponse disassociateCustomerGateway(
            Consumer<DisassociateCustomerGatewayRequest.Builder> disassociateCustomerGatewayRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return disassociateCustomerGateway(DisassociateCustomerGatewayRequest.builder()
                .applyMutation(disassociateCustomerGatewayRequest).build());
    }

    /**
     * <p>
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are
     * associated with the link.
     * </p>
     *
     * @param disassociateLinkRequest
     * @return Result of the DisassociateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLinkResponse disassociateLink(DisassociateLinkRequest disassociateLinkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are
     * associated with the link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLinkRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateLinkRequest#builder()}
     * </p>
     *
     * @param disassociateLinkRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateLinkRequest.Builder} to create a request.
     * @return Result of the DisassociateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLinkResponse disassociateLink(Consumer<DisassociateLinkRequest.Builder> disassociateLinkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return disassociateLink(DisassociateLinkRequest.builder().applyMutation(disassociateLinkRequest).build());
    }

    /**
     * <p>
     * Disassociates a transit gateway Connect peer from a device and link.
     * </p>
     *
     * @param disassociateTransitGatewayConnectPeerRequest
     * @return Result of the DisassociateTransitGatewayConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTransitGatewayConnectPeerResponse disassociateTransitGatewayConnectPeer(
            DisassociateTransitGatewayConnectPeerRequest disassociateTransitGatewayConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a transit gateway Connect peer from a device and link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateTransitGatewayConnectPeerRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param disassociateTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateTransitGatewayConnectPeerRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateTransitGatewayConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.DisassociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTransitGatewayConnectPeerResponse disassociateTransitGatewayConnectPeer(
            Consumer<DisassociateTransitGatewayConnectPeerRequest.Builder> disassociateTransitGatewayConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return disassociateTransitGatewayConnectPeer(DisassociateTransitGatewayConnectPeerRequest.builder()
                .applyMutation(disassociateTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     * </p>
     *
     * @param executeCoreNetworkChangeSetRequest
     * @return Result of the ExecuteCoreNetworkChangeSet operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ExecuteCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ExecuteCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteCoreNetworkChangeSetResponse executeCoreNetworkChangeSet(
            ExecuteCoreNetworkChangeSetRequest executeCoreNetworkChangeSetRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteCoreNetworkChangeSetRequest.Builder}
     * avoiding the need to create one manually via {@link ExecuteCoreNetworkChangeSetRequest#builder()}
     * </p>
     *
     * @param executeCoreNetworkChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteCoreNetworkChangeSetRequest.Builder} to create
     *        a request.
     * @return Result of the ExecuteCoreNetworkChangeSet operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ExecuteCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ExecuteCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteCoreNetworkChangeSetResponse executeCoreNetworkChangeSet(
            Consumer<ExecuteCoreNetworkChangeSetRequest.Builder> executeCoreNetworkChangeSetRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return executeCoreNetworkChangeSet(ExecuteCoreNetworkChangeSetRequest.builder()
                .applyMutation(executeCoreNetworkChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect attachment.
     * </p>
     *
     * @param getConnectAttachmentRequest
     * @return Result of the GetConnectAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectAttachmentResponse getConnectAttachment(GetConnectAttachmentRequest getConnectAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectAttachmentRequest#builder()}
     * </p>
     *
     * @param getConnectAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectAttachmentRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnectAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectAttachmentResponse getConnectAttachment(
            Consumer<GetConnectAttachmentRequest.Builder> getConnectAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getConnectAttachment(GetConnectAttachmentRequest.builder().applyMutation(getConnectAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect peer.
     * </p>
     *
     * @param getConnectPeerRequest
     * @return Result of the GetConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectPeerResponse getConnectPeer(GetConnectPeerRequest getConnectPeerRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectPeerRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectPeerRequest#builder()}
     * </p>
     *
     * @param getConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectPeerRequest.Builder} to create a request.
     * @return Result of the GetConnectPeer operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectPeerResponse getConnectPeer(Consumer<GetConnectPeerRequest.Builder> getConnectPeerRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getConnectPeer(GetConnectPeerRequest.builder().applyMutation(getConnectPeerRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     * @return Result of the GetConnectPeerAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectPeerAssociationsResponse getConnectPeerAssociations(
            GetConnectPeerAssociationsRequest getConnectPeerAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectPeerAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectPeerAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnectPeerAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectPeerAssociationsResponse getConnectPeerAssociations(
            Consumer<GetConnectPeerAssociationsRequest.Builder> getConnectPeerAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return getConnectPeerAssociations(GetConnectPeerAssociationsRequest.builder()
                .applyMutation(getConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable responses = client.getConnectPeerAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable responses = client
     *             .getConnectPeerAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable responses = client.getConnectPeerAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectPeerAssociationsIterable getConnectPeerAssociationsPaginator(
            GetConnectPeerAssociationsRequest getConnectPeerAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable responses = client.getConnectPeerAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable responses = client
     *             .getConnectPeerAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsIterable responses = client.getConnectPeerAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectPeerAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectPeerAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectPeerAssociationsIterable getConnectPeerAssociationsPaginator(
            Consumer<GetConnectPeerAssociationsRequest.Builder> getConnectPeerAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return getConnectPeerAssociationsPaginator(GetConnectPeerAssociationsRequest.builder()
                .applyMutation(getConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     *
     * @param getConnectionsRequest
     * @return Result of the GetConnections operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionsResponse getConnections(GetConnectionsRequest getConnectionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionsRequest.Builder} to create a request.
     * @return Result of the GetConnections operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionsResponse getConnections(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getConnections(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable responses = client
     *             .getConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionsIterable getConnectionsPaginator(GetConnectionsRequest getConnectionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable responses = client
     *             .getConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionsIterable getConnectionsPaginator(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getConnectionsPaginator(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the LIVE policy for a core network.
     * </p>
     *
     * @param getCoreNetworkRequest
     * @return Result of the GetCoreNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCoreNetworkResponse getCoreNetwork(GetCoreNetworkRequest getCoreNetworkRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the LIVE policy for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetCoreNetworkRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkRequest.Builder} to create a request.
     * @return Result of the GetCoreNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCoreNetworkResponse getCoreNetwork(Consumer<GetCoreNetworkRequest.Builder> getCoreNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getCoreNetwork(GetCoreNetworkRequest.builder().applyMutation(getCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     * @return Result of the GetCoreNetworkChangeEvents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeEventsResponse getCoreNetworkChangeEvents(
            GetCoreNetworkChangeEventsRequest getCoreNetworkChangeEventsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeEventsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeEventsRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeEventsRequest.Builder} to create a
     *        request.
     * @return Result of the GetCoreNetworkChangeEvents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeEventsResponse getCoreNetworkChangeEvents(
            Consumer<GetCoreNetworkChangeEventsRequest.Builder> getCoreNetworkChangeEventsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getCoreNetworkChangeEvents(GetCoreNetworkChangeEventsRequest.builder()
                .applyMutation(getCoreNetworkChangeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable responses = client.getCoreNetworkChangeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable responses = client
     *             .getCoreNetworkChangeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable responses = client.getCoreNetworkChangeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeEventsIterable getCoreNetworkChangeEventsPaginator(
            GetCoreNetworkChangeEventsRequest getCoreNetworkChangeEventsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable responses = client.getCoreNetworkChangeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable responses = client
     *             .getCoreNetworkChangeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsIterable responses = client.getCoreNetworkChangeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeEventsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeEventsRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeEventsIterable getCoreNetworkChangeEventsPaginator(
            Consumer<GetCoreNetworkChangeEventsRequest.Builder> getCoreNetworkChangeEventsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getCoreNetworkChangeEventsPaginator(GetCoreNetworkChangeEventsRequest.builder()
                .applyMutation(getCoreNetworkChangeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     * @return Result of the GetCoreNetworkChangeSet operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeSetResponse getCoreNetworkChangeSet(GetCoreNetworkChangeSetRequest getCoreNetworkChangeSetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeSetRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeSetRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeSetRequest.Builder} to create a
     *        request.
     * @return Result of the GetCoreNetworkChangeSet operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeSetResponse getCoreNetworkChangeSet(
            Consumer<GetCoreNetworkChangeSetRequest.Builder> getCoreNetworkChangeSetRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getCoreNetworkChangeSet(GetCoreNetworkChangeSetRequest.builder().applyMutation(getCoreNetworkChangeSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable responses = client.getCoreNetworkChangeSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable responses = client
     *             .getCoreNetworkChangeSetPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable responses = client.getCoreNetworkChangeSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeSetIterable getCoreNetworkChangeSetPaginator(
            GetCoreNetworkChangeSetRequest getCoreNetworkChangeSetRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable responses = client.getCoreNetworkChangeSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable responses = client
     *             .getCoreNetworkChangeSetPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetIterable responses = client.getCoreNetworkChangeSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeSetRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeSetRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeSetRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeSetIterable getCoreNetworkChangeSetPaginator(
            Consumer<GetCoreNetworkChangeSetRequest.Builder> getCoreNetworkChangeSetRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getCoreNetworkChangeSetPaginator(GetCoreNetworkChangeSetRequest.builder()
                .applyMutation(getCoreNetworkChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns details about a core network policy. You can get details about your current live policy or any previous
     * policy version.
     * </p>
     *
     * @param getCoreNetworkPolicyRequest
     * @return Result of the GetCoreNetworkPolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkPolicyResponse getCoreNetworkPolicy(GetCoreNetworkPolicyRequest getCoreNetworkPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a core network policy. You can get details about your current live policy or any previous
     * policy version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetCoreNetworkPolicyRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetCoreNetworkPolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkPolicyResponse getCoreNetworkPolicy(
            Consumer<GetCoreNetworkPolicyRequest.Builder> getCoreNetworkPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getCoreNetworkPolicy(GetCoreNetworkPolicyRequest.builder().applyMutation(getCoreNetworkPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     * @return Result of the GetCustomerGatewayAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomerGatewayAssociationsResponse getCustomerGatewayAssociations(
            GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomerGatewayAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomerGatewayAssociationsRequest#builder()}
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomerGatewayAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the GetCustomerGatewayAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomerGatewayAssociationsResponse getCustomerGatewayAssociations(
            Consumer<GetCustomerGatewayAssociationsRequest.Builder> getCustomerGatewayAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest.builder()
                .applyMutation(getCustomerGatewayAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable responses = client.getCustomerGatewayAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable responses = client
     *             .getCustomerGatewayAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable responses = client.getCustomerGatewayAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomerGatewayAssociationsIterable getCustomerGatewayAssociationsPaginator(
            GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable responses = client.getCustomerGatewayAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable responses = client
     *             .getCustomerGatewayAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable responses = client.getCustomerGatewayAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomerGatewayAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomerGatewayAssociationsRequest#builder()}
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomerGatewayAssociationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomerGatewayAssociationsIterable getCustomerGatewayAssociationsPaginator(
            Consumer<GetCustomerGatewayAssociationsRequest.Builder> getCustomerGatewayAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getCustomerGatewayAssociationsPaginator(GetCustomerGatewayAssociationsRequest.builder()
                .applyMutation(getCustomerGatewayAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     *
     * @param getDevicesRequest
     * @return Result of the GetDevices operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicesResponse getDevices(GetDevicesRequest getDevicesRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevicesRequest#builder()}
     * </p>
     *
     * @param getDevicesRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicesRequest.Builder} to create a request.
     * @return Result of the GetDevices operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicesResponse getDevices(Consumer<GetDevicesRequest.Builder> getDevicesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getDevices(GetDevicesRequest.builder().applyMutation(getDevicesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable responses = client.getDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable responses = client.getDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable responses = client.getDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)} operation.</b>
     * </p>
     *
     * @param getDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicesIterable getDevicesPaginator(GetDevicesRequest getDevicesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable responses = client.getDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable responses = client.getDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable responses = client.getDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevicesRequest#builder()}
     * </p>
     *
     * @param getDevicesRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicesIterable getDevicesPaginator(Consumer<GetDevicesRequest.Builder> getDevicesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getDevicesPaginator(GetDevicesRequest.builder().applyMutation(getDevicesRequest).build());
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     *
     * @param getLinkAssociationsRequest
     * @return Result of the GetLinkAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkAssociationsResponse getLinkAssociations(GetLinkAssociationsRequest getLinkAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetLinkAssociationsRequest#builder()}
     * </p>
     *
     * @param getLinkAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetLinkAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the GetLinkAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkAssociationsResponse getLinkAssociations(
            Consumer<GetLinkAssociationsRequest.Builder> getLinkAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getLinkAssociations(GetLinkAssociationsRequest.builder().applyMutation(getLinkAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable responses = client.getLinkAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable responses = client
     *             .getLinkAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable responses = client.getLinkAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getLinkAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkAssociationsIterable getLinkAssociationsPaginator(GetLinkAssociationsRequest getLinkAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable responses = client.getLinkAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable responses = client
     *             .getLinkAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable responses = client.getLinkAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetLinkAssociationsRequest#builder()}
     * </p>
     *
     * @param getLinkAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetLinkAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkAssociationsIterable getLinkAssociationsPaginator(
            Consumer<GetLinkAssociationsRequest.Builder> getLinkAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getLinkAssociationsPaginator(GetLinkAssociationsRequest.builder().applyMutation(getLinkAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     *
     * @param getLinksRequest
     * @return Result of the GetLinks operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinksResponse getLinks(GetLinksRequest getLinksRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetLinksRequest#builder()}
     * </p>
     *
     * @param getLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetLinksRequest.Builder} to create a request.
     * @return Result of the GetLinks operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinksResponse getLinks(Consumer<GetLinksRequest.Builder> getLinksRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getLinks(GetLinksRequest.builder().applyMutation(getLinksRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable responses = client.getLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable responses = client.getLinksPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable responses = client.getLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)} operation.</b>
     * </p>
     *
     * @param getLinksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinksIterable getLinksPaginator(GetLinksRequest getLinksRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable responses = client.getLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable responses = client.getLinksPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable responses = client.getLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetLinksRequest#builder()}
     * </p>
     *
     * @param getLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetLinksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinksIterable getLinksPaginator(Consumer<GetLinksRequest.Builder> getLinksRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getLinksPaginator(GetLinksRequest.builder().applyMutation(getLinksRequest).build());
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     * @return Result of the GetNetworkResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceCountsResponse getNetworkResourceCounts(
            GetNetworkResourceCountsRequest getNetworkResourceCountsRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceCountsRequest.Builder} avoiding
     * the need to create one manually via {@link GetNetworkResourceCountsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceCountsRequest.Builder} to create a
     *        request.
     * @return Result of the GetNetworkResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceCountsResponse getNetworkResourceCounts(
            Consumer<GetNetworkResourceCountsRequest.Builder> getNetworkResourceCountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        return getNetworkResourceCounts(GetNetworkResourceCountsRequest.builder().applyMutation(getNetworkResourceCountsRequest)
                .build());
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable responses = client.getNetworkResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable responses = client
     *             .getNetworkResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable responses = client.getNetworkResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceCountsIterable getNetworkResourceCountsPaginator(
            GetNetworkResourceCountsRequest getNetworkResourceCountsRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable responses = client.getNetworkResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable responses = client
     *             .getNetworkResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsIterable responses = client.getNetworkResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceCountsRequest.Builder} avoiding
     * the need to create one manually via {@link GetNetworkResourceCountsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceCountsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceCountsIterable getNetworkResourceCountsPaginator(
            Consumer<GetNetworkResourceCountsRequest.Builder> getNetworkResourceCountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        return getNetworkResourceCountsPaginator(GetNetworkResourceCountsRequest.builder()
                .applyMutation(getNetworkResourceCountsRequest).build());
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     * @return Result of the GetNetworkResourceRelationships operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceRelationshipsResponse getNetworkResourceRelationships(
            GetNetworkResourceRelationshipsRequest getNetworkResourceRelationshipsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceRelationshipsRequest.Builder}
     * avoiding the need to create one manually via {@link GetNetworkResourceRelationshipsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceRelationshipsRequest.Builder} to
     *        create a request.
     * @return Result of the GetNetworkResourceRelationships operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceRelationshipsResponse getNetworkResourceRelationships(
            Consumer<GetNetworkResourceRelationshipsRequest.Builder> getNetworkResourceRelationshipsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getNetworkResourceRelationships(GetNetworkResourceRelationshipsRequest.builder()
                .applyMutation(getNetworkResourceRelationshipsRequest).build());
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable responses = client.getNetworkResourceRelationshipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable responses = client
     *             .getNetworkResourceRelationshipsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable responses = client.getNetworkResourceRelationshipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceRelationshipsIterable getNetworkResourceRelationshipsPaginator(
            GetNetworkResourceRelationshipsRequest getNetworkResourceRelationshipsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable responses = client.getNetworkResourceRelationshipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable responses = client
     *             .getNetworkResourceRelationshipsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsIterable responses = client.getNetworkResourceRelationshipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceRelationshipsRequest.Builder}
     * avoiding the need to create one manually via {@link GetNetworkResourceRelationshipsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceRelationshipsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceRelationshipsIterable getNetworkResourceRelationshipsPaginator(
            Consumer<GetNetworkResourceRelationshipsRequest.Builder> getNetworkResourceRelationshipsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getNetworkResourceRelationshipsPaginator(GetNetworkResourceRelationshipsRequest.builder()
                .applyMutation(getNetworkResourceRelationshipsRequest).build());
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     *
     * @param getNetworkResourcesRequest
     * @return Result of the GetNetworkResources operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourcesResponse getNetworkResources(GetNetworkResourcesRequest getNetworkResourcesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param getNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the GetNetworkResources operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourcesResponse getNetworkResources(
            Consumer<GetNetworkResourcesRequest.Builder> getNetworkResourcesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getNetworkResources(GetNetworkResourcesRequest.builder().applyMutation(getNetworkResourcesRequest).build());
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable responses = client.getNetworkResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable responses = client
     *             .getNetworkResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable responses = client.getNetworkResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourcesIterable getNetworkResourcesPaginator(GetNetworkResourcesRequest getNetworkResourcesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable responses = client.getNetworkResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable responses = client
     *             .getNetworkResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesIterable responses = client.getNetworkResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param getNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourcesIterable getNetworkResourcesPaginator(
            Consumer<GetNetworkResourcesRequest.Builder> getNetworkResourcesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getNetworkResourcesPaginator(GetNetworkResourcesRequest.builder().applyMutation(getNetworkResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the network routes of the specified global network.
     * </p>
     *
     * @param getNetworkRoutesRequest
     * @return Result of the GetNetworkRoutes operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkRoutes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkRoutesResponse getNetworkRoutes(GetNetworkRoutesRequest getNetworkRoutesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network routes of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkRoutesRequest.Builder} avoiding the need
     * to create one manually via {@link GetNetworkRoutesRequest#builder()}
     * </p>
     *
     * @param getNetworkRoutesRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkRoutesRequest.Builder} to create a request.
     * @return Result of the GetNetworkRoutes operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkRoutes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkRoutesResponse getNetworkRoutes(Consumer<GetNetworkRoutesRequest.Builder> getNetworkRoutesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getNetworkRoutes(GetNetworkRoutesRequest.builder().applyMutation(getNetworkRoutesRequest).build());
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     *
     * @param getNetworkTelemetryRequest
     * @return Result of the GetNetworkTelemetry operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkTelemetryResponse getNetworkTelemetry(GetNetworkTelemetryRequest getNetworkTelemetryRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkTelemetryRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkTelemetryRequest#builder()}
     * </p>
     *
     * @param getNetworkTelemetryRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkTelemetryRequest.Builder} to create a
     *        request.
     * @return Result of the GetNetworkTelemetry operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkTelemetryResponse getNetworkTelemetry(
            Consumer<GetNetworkTelemetryRequest.Builder> getNetworkTelemetryRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getNetworkTelemetry(GetNetworkTelemetryRequest.builder().applyMutation(getNetworkTelemetryRequest).build());
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable responses = client.getNetworkTelemetryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable responses = client
     *             .getNetworkTelemetryPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable responses = client.getNetworkTelemetryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkTelemetryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkTelemetryIterable getNetworkTelemetryPaginator(GetNetworkTelemetryRequest getNetworkTelemetryRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable responses = client.getNetworkTelemetryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable responses = client
     *             .getNetworkTelemetryPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryIterable responses = client.getNetworkTelemetryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkTelemetryRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkTelemetryRequest#builder()}
     * </p>
     *
     * @param getNetworkTelemetryRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkTelemetryRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkTelemetryIterable getNetworkTelemetryPaginator(
            Consumer<GetNetworkTelemetryRequest.Builder> getNetworkTelemetryRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getNetworkTelemetryPaginator(GetNetworkTelemetryRequest.builder().applyMutation(getNetworkTelemetryRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyRequest.Builder} to create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified route analysis.
     * </p>
     *
     * @param getRouteAnalysisRequest
     * @return Result of the GetRouteAnalysis operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouteAnalysisResponse getRouteAnalysis(GetRouteAnalysisRequest getRouteAnalysisRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified route analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteAnalysisRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouteAnalysisRequest#builder()}
     * </p>
     *
     * @param getRouteAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link GetRouteAnalysisRequest.Builder} to create a request.
     * @return Result of the GetRouteAnalysis operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouteAnalysisResponse getRouteAnalysis(Consumer<GetRouteAnalysisRequest.Builder> getRouteAnalysisRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getRouteAnalysis(GetRouteAnalysisRequest.builder().applyMutation(getRouteAnalysisRequest).build());
    }

    /**
     * <p>
     * Returns information about a site-to-site VPN attachment.
     * </p>
     *
     * @param getSiteToSiteVpnAttachmentRequest
     * @return Result of the GetSiteToSiteVpnAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSiteToSiteVpnAttachmentResponse getSiteToSiteVpnAttachment(
            GetSiteToSiteVpnAttachmentRequest getSiteToSiteVpnAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a site-to-site VPN attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteToSiteVpnAttachmentRequest.Builder} avoiding
     * the need to create one manually via {@link GetSiteToSiteVpnAttachmentRequest#builder()}
     * </p>
     *
     * @param getSiteToSiteVpnAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetSiteToSiteVpnAttachmentRequest.Builder} to create a
     *        request.
     * @return Result of the GetSiteToSiteVpnAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSiteToSiteVpnAttachmentResponse getSiteToSiteVpnAttachment(
            Consumer<GetSiteToSiteVpnAttachmentRequest.Builder> getSiteToSiteVpnAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getSiteToSiteVpnAttachment(GetSiteToSiteVpnAttachmentRequest.builder()
                .applyMutation(getSiteToSiteVpnAttachmentRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     *
     * @param getSitesRequest
     * @return Result of the GetSites operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSitesResponse getSites(GetSitesRequest getSitesRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSitesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSitesRequest#builder()}
     * </p>
     *
     * @param getSitesRequest
     *        A {@link Consumer} that will call methods on {@link GetSitesRequest.Builder} to create a request.
     * @return Result of the GetSites operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSitesResponse getSites(Consumer<GetSitesRequest.Builder> getSitesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getSites(GetSitesRequest.builder().applyMutation(getSitesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable responses = client.getSitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable responses = client.getSitesPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetSitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable responses = client.getSitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)} operation.</b>
     * </p>
     *
     * @param getSitesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSitesIterable getSitesPaginator(GetSitesRequest getSitesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable responses = client.getSitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable responses = client.getSitesPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetSitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable responses = client.getSitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSitesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSitesRequest#builder()}
     * </p>
     *
     * @param getSitesRequest
     *        A {@link Consumer} that will call methods on {@link GetSitesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSitesIterable getSitesPaginator(Consumer<GetSitesRequest.Builder> getSitesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getSitesPaginator(GetSitesRequest.builder().applyMutation(getSitesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     * @return Result of the GetTransitGatewayConnectPeerAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayConnectPeerAssociationsResponse getTransitGatewayConnectPeerAssociations(
            GetTransitGatewayConnectPeerAssociationsRequest getTransitGatewayConnectPeerAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetTransitGatewayConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} to create a request.
     * @return Result of the GetTransitGatewayConnectPeerAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayConnectPeerAssociationsResponse getTransitGatewayConnectPeerAssociations(
            Consumer<GetTransitGatewayConnectPeerAssociationsRequest.Builder> getTransitGatewayConnectPeerAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getTransitGatewayConnectPeerAssociations(GetTransitGatewayConnectPeerAssociationsRequest.builder()
                .applyMutation(getTransitGatewayConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable responses = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable responses = client
     *             .getTransitGatewayConnectPeerAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable responses = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayConnectPeerAssociationsIterable getTransitGatewayConnectPeerAssociationsPaginator(
            GetTransitGatewayConnectPeerAssociationsRequest getTransitGatewayConnectPeerAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable responses = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable responses = client
     *             .getTransitGatewayConnectPeerAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsIterable responses = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetTransitGatewayConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayConnectPeerAssociationsIterable getTransitGatewayConnectPeerAssociationsPaginator(
            Consumer<GetTransitGatewayConnectPeerAssociationsRequest.Builder> getTransitGatewayConnectPeerAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getTransitGatewayConnectPeerAssociationsPaginator(GetTransitGatewayConnectPeerAssociationsRequest.builder()
                .applyMutation(getTransitGatewayConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns information about a transit gateway peer.
     * </p>
     *
     * @param getTransitGatewayPeeringRequest
     * @return Result of the GetTransitGatewayPeering operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayPeeringResponse getTransitGatewayPeering(
            GetTransitGatewayPeeringRequest getTransitGatewayPeeringRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transit gateway peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransitGatewayPeeringRequest.Builder} avoiding
     * the need to create one manually via {@link GetTransitGatewayPeeringRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayPeeringRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayPeeringRequest.Builder} to create a
     *        request.
     * @return Result of the GetTransitGatewayPeering operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayPeeringResponse getTransitGatewayPeering(
            Consumer<GetTransitGatewayPeeringRequest.Builder> getTransitGatewayPeeringRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return getTransitGatewayPeering(GetTransitGatewayPeeringRequest.builder().applyMutation(getTransitGatewayPeeringRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     * @return Result of the GetTransitGatewayRegistrations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRegistrationsResponse getTransitGatewayRegistrations(
            GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransitGatewayRegistrationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetTransitGatewayRegistrationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayRegistrationsRequest.Builder} to
     *        create a request.
     * @return Result of the GetTransitGatewayRegistrations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRegistrationsResponse getTransitGatewayRegistrations(
            Consumer<GetTransitGatewayRegistrationsRequest.Builder> getTransitGatewayRegistrationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest.builder()
                .applyMutation(getTransitGatewayRegistrationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable responses = client.getTransitGatewayRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable responses = client
     *             .getTransitGatewayRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable responses = client.getTransitGatewayRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRegistrationsIterable getTransitGatewayRegistrationsPaginator(
            GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable responses = client.getTransitGatewayRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable responses = client
     *             .getTransitGatewayRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable responses = client.getTransitGatewayRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransitGatewayRegistrationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetTransitGatewayRegistrationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayRegistrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRegistrationsIterable getTransitGatewayRegistrationsPaginator(
            Consumer<GetTransitGatewayRegistrationsRequest.Builder> getTransitGatewayRegistrationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getTransitGatewayRegistrationsPaginator(GetTransitGatewayRegistrationsRequest.builder()
                .applyMutation(getTransitGatewayRegistrationsRequest).build());
    }

    /**
     * <p>
     * Returns information about a transit gateway route table attachment.
     * </p>
     *
     * @param getTransitGatewayRouteTableAttachmentRequest
     * @return Result of the GetTransitGatewayRouteTableAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRouteTableAttachmentResponse getTransitGatewayRouteTableAttachment(
            GetTransitGatewayRouteTableAttachmentRequest getTransitGatewayRouteTableAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transit gateway route table attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTransitGatewayRouteTableAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link GetTransitGatewayRouteTableAttachmentRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayRouteTableAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayRouteTableAttachmentRequest.Builder}
     *        to create a request.
     * @return Result of the GetTransitGatewayRouteTableAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRouteTableAttachmentResponse getTransitGatewayRouteTableAttachment(
            Consumer<GetTransitGatewayRouteTableAttachmentRequest.Builder> getTransitGatewayRouteTableAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getTransitGatewayRouteTableAttachment(GetTransitGatewayRouteTableAttachmentRequest.builder()
                .applyMutation(getTransitGatewayRouteTableAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns information about a VPC attachment.
     * </p>
     *
     * @param getVpcAttachmentRequest
     * @return Result of the GetVpcAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVpcAttachmentResponse getVpcAttachment(GetVpcAttachmentRequest getVpcAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a VPC attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link GetVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param getVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcAttachmentRequest.Builder} to create a request.
     * @return Result of the GetVpcAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.GetVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVpcAttachmentResponse getVpcAttachment(Consumer<GetVpcAttachmentRequest.Builder> getVpcAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return getVpcAttachment(GetVpcAttachmentRequest.builder().applyMutation(getVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     *
     * @param listAttachmentsRequest
     * @return Result of the ListAttachments operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachmentsResponse listAttachments(ListAttachmentsRequest listAttachmentsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttachmentsRequest#builder()}
     * </p>
     *
     * @param listAttachmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachmentsRequest.Builder} to create a request.
     * @return Result of the ListAttachments operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachmentsResponse listAttachments(Consumer<ListAttachmentsRequest.Builder> listAttachmentsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listAttachments(ListAttachmentsRequest.builder().applyMutation(listAttachmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable responses = client.listAttachmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable responses = client
     *             .listAttachmentsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable responses = client.listAttachmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachmentsIterable listAttachmentsPaginator(ListAttachmentsRequest listAttachmentsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable responses = client.listAttachmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable responses = client
     *             .listAttachmentsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsIterable responses = client.listAttachmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttachmentsRequest#builder()}
     * </p>
     *
     * @param listAttachmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachmentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachmentsIterable listAttachmentsPaginator(Consumer<ListAttachmentsRequest.Builder> listAttachmentsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listAttachmentsPaginator(ListAttachmentsRequest.builder().applyMutation(listAttachmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     *
     * @param listConnectPeersRequest
     * @return Result of the ListConnectPeers operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectPeersResponse listConnectPeers(ListConnectPeersRequest listConnectPeersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectPeersRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectPeersRequest#builder()}
     * </p>
     *
     * @param listConnectPeersRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectPeersRequest.Builder} to create a request.
     * @return Result of the ListConnectPeers operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectPeersResponse listConnectPeers(Consumer<ListConnectPeersRequest.Builder> listConnectPeersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listConnectPeers(ListConnectPeersRequest.builder().applyMutation(listConnectPeersRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable responses = client.listConnectPeersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable responses = client
     *             .listConnectPeersPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable responses = client.listConnectPeersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectPeersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectPeersIterable listConnectPeersPaginator(ListConnectPeersRequest listConnectPeersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable responses = client.listConnectPeersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable responses = client
     *             .listConnectPeersPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersIterable responses = client.listConnectPeersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectPeersRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectPeersRequest#builder()}
     * </p>
     *
     * @param listConnectPeersRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectPeersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectPeersIterable listConnectPeersPaginator(Consumer<ListConnectPeersRequest.Builder> listConnectPeersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listConnectPeersPaginator(ListConnectPeersRequest.builder().applyMutation(listConnectPeersRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     * @return Result of the ListCoreNetworkPolicyVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworkPolicyVersionsResponse listCoreNetworkPolicyVersions(
            ListCoreNetworkPolicyVersionsRequest listCoreNetworkPolicyVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworkPolicyVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCoreNetworkPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworkPolicyVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCoreNetworkPolicyVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworkPolicyVersionsResponse listCoreNetworkPolicyVersions(
            Consumer<ListCoreNetworkPolicyVersionsRequest.Builder> listCoreNetworkPolicyVersionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return listCoreNetworkPolicyVersions(ListCoreNetworkPolicyVersionsRequest.builder()
                .applyMutation(listCoreNetworkPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable responses = client.listCoreNetworkPolicyVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable responses = client
     *             .listCoreNetworkPolicyVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable responses = client.listCoreNetworkPolicyVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworkPolicyVersionsIterable listCoreNetworkPolicyVersionsPaginator(
            ListCoreNetworkPolicyVersionsRequest listCoreNetworkPolicyVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable responses = client.listCoreNetworkPolicyVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable responses = client
     *             .listCoreNetworkPolicyVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsIterable responses = client.listCoreNetworkPolicyVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworkPolicyVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCoreNetworkPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworkPolicyVersionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworkPolicyVersionsIterable listCoreNetworkPolicyVersionsPaginator(
            Consumer<ListCoreNetworkPolicyVersionsRequest.Builder> listCoreNetworkPolicyVersionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return listCoreNetworkPolicyVersionsPaginator(ListCoreNetworkPolicyVersionsRequest.builder()
                .applyMutation(listCoreNetworkPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     *
     * @param listCoreNetworksRequest
     * @return Result of the ListCoreNetworks operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworksResponse listCoreNetworks(ListCoreNetworksRequest listCoreNetworksRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListCoreNetworksRequest#builder()}
     * </p>
     *
     * @param listCoreNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworksRequest.Builder} to create a request.
     * @return Result of the ListCoreNetworks operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworksResponse listCoreNetworks(Consumer<ListCoreNetworksRequest.Builder> listCoreNetworksRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listCoreNetworks(ListCoreNetworksRequest.builder().applyMutation(listCoreNetworksRequest).build());
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable responses = client.listCoreNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable responses = client
     *             .listCoreNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable responses = client.listCoreNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoreNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworksIterable listCoreNetworksPaginator(ListCoreNetworksRequest listCoreNetworksRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable responses = client.listCoreNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable responses = client
     *             .listCoreNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksIterable responses = client.listCoreNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListCoreNetworksRequest#builder()}
     * </p>
     *
     * @param listCoreNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworksIterable listCoreNetworksPaginator(Consumer<ListCoreNetworksRequest.Builder> listCoreNetworksRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listCoreNetworksPaginator(ListCoreNetworksRequest.builder().applyMutation(listCoreNetworksRequest).build());
    }

    /**
     * <p>
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services
     * Organization.
     * </p>
     *
     * @param listOrganizationServiceAccessStatusRequest
     * @return Result of the ListOrganizationServiceAccessStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListOrganizationServiceAccessStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListOrganizationServiceAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationServiceAccessStatusResponse listOrganizationServiceAccessStatus(
            ListOrganizationServiceAccessStatusRequest listOrganizationServiceAccessStatusRequest) throws AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services
     * Organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationServiceAccessStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationServiceAccessStatusRequest#builder()}
     * </p>
     *
     * @param listOrganizationServiceAccessStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationServiceAccessStatusRequest.Builder} to
     *        create a request.
     * @return Result of the ListOrganizationServiceAccessStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListOrganizationServiceAccessStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListOrganizationServiceAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationServiceAccessStatusResponse listOrganizationServiceAccessStatus(
            Consumer<ListOrganizationServiceAccessStatusRequest.Builder> listOrganizationServiceAccessStatusRequest)
            throws AwsServiceException, SdkClientException, NetworkManagerException {
        return listOrganizationServiceAccessStatus(ListOrganizationServiceAccessStatusRequest.builder()
                .applyMutation(listOrganizationServiceAccessStatusRequest).build());
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     *
     * @param listPeeringsRequest
     * @return Result of the ListPeerings operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPeeringsResponse listPeerings(ListPeeringsRequest listPeeringsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPeeringsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPeeringsRequest#builder()}
     * </p>
     *
     * @param listPeeringsRequest
     *        A {@link Consumer} that will call methods on {@link ListPeeringsRequest.Builder} to create a request.
     * @return Result of the ListPeerings operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPeeringsResponse listPeerings(Consumer<ListPeeringsRequest.Builder> listPeeringsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listPeerings(ListPeeringsRequest.builder().applyMutation(listPeeringsRequest).build());
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable responses = client.listPeeringsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable responses = client
     *             .listPeeringsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable responses = client.listPeeringsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation.</b>
     * </p>
     *
     * @param listPeeringsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPeeringsIterable listPeeringsPaginator(ListPeeringsRequest listPeeringsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable responses = client.listPeeringsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable responses = client
     *             .listPeeringsPaginator(request);
     *     for (software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsIterable responses = client.listPeeringsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPeeringsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPeeringsRequest#builder()}
     * </p>
     *
     * @param listPeeringsRequest
     *        A {@link Consumer} that will call methods on {@link ListPeeringsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPeeringsIterable listPeeringsPaginator(Consumer<ListPeeringsRequest.Builder> listPeeringsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listPeeringsPaginator(ListPeeringsRequest.builder().applyMutation(listPeeringsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the
     * differences between the LIVE policy and the submitted policy.
     * </p>
     *
     * @param putCoreNetworkPolicyRequest
     * @return Result of the PutCoreNetworkPolicy operation returned by the service.
     * @throws CoreNetworkPolicyException
     *         Describes a core network policy exception.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.PutCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutCoreNetworkPolicyResponse putCoreNetworkPolicy(PutCoreNetworkPolicyRequest putCoreNetworkPolicyRequest)
            throws CoreNetworkPolicyException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the
     * differences between the LIVE policy and the submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCoreNetworkPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutCoreNetworkPolicyRequest#builder()}
     * </p>
     *
     * @param putCoreNetworkPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutCoreNetworkPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutCoreNetworkPolicy operation returned by the service.
     * @throws CoreNetworkPolicyException
     *         Describes a core network policy exception.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.PutCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutCoreNetworkPolicyResponse putCoreNetworkPolicy(
            Consumer<PutCoreNetworkPolicyRequest.Builder> putCoreNetworkPolicyRequest) throws CoreNetworkPolicyException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, NetworkManagerException {
        return putCoreNetworkPolicy(PutCoreNetworkPolicyRequest.builder().applyMutation(putCoreNetworkPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource policy.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Registers a transit gateway in your global network. Not all Regions support transit gateways for global networks.
     * For a list of the supported Regions, see <a href=
     * "https://docs.aws.amazon.com/network-manager/latest/tgwnm/what-are-global-networks.html#nm-available-regions"
     * >Region Availability</a> in the <i>Amazon Web Services Transit Gateways for Global Networks User Guide</i>. The
     * transit gateway can be in any of the supported Amazon Web Services Regions, but it must be owned by the same
     * Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one
     * global network.
     * </p>
     *
     * @param registerTransitGatewayRequest
     * @return Result of the RegisterTransitGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.RegisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RegisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterTransitGatewayResponse registerTransitGateway(RegisterTransitGatewayRequest registerTransitGatewayRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a transit gateway in your global network. Not all Regions support transit gateways for global networks.
     * For a list of the supported Regions, see <a href=
     * "https://docs.aws.amazon.com/network-manager/latest/tgwnm/what-are-global-networks.html#nm-available-regions"
     * >Region Availability</a> in the <i>Amazon Web Services Transit Gateways for Global Networks User Guide</i>. The
     * transit gateway can be in any of the supported Amazon Web Services Regions, but it must be owned by the same
     * Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one
     * global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTransitGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterTransitGatewayRequest#builder()}
     * </p>
     *
     * @param registerTransitGatewayRequest
     *        A {@link Consumer} that will call methods on {@link RegisterTransitGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterTransitGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.RegisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RegisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterTransitGatewayResponse registerTransitGateway(
            Consumer<RegisterTransitGatewayRequest.Builder> registerTransitGatewayRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return registerTransitGateway(RegisterTransitGatewayRequest.builder().applyMutation(registerTransitGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Rejects a core network attachment request.
     * </p>
     *
     * @param rejectAttachmentRequest
     * @return Result of the RejectAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.RejectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RejectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectAttachmentResponse rejectAttachment(RejectAttachmentRequest rejectAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a core network attachment request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link RejectAttachmentRequest#builder()}
     * </p>
     *
     * @param rejectAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link RejectAttachmentRequest.Builder} to create a request.
     * @return Result of the RejectAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.RejectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RejectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectAttachmentResponse rejectAttachment(Consumer<RejectAttachmentRequest.Builder> rejectAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return rejectAttachment(RejectAttachmentRequest.builder().applyMutation(rejectAttachmentRequest).build());
    }

    /**
     * <p>
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set
     * is created showing the differences between the LIVE policy and restored policy.
     * </p>
     *
     * @param restoreCoreNetworkPolicyVersionRequest
     * @return Result of the RestoreCoreNetworkPolicyVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.RestoreCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RestoreCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreCoreNetworkPolicyVersionResponse restoreCoreNetworkPolicyVersion(
            RestoreCoreNetworkPolicyVersionRequest restoreCoreNetworkPolicyVersionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set
     * is created showing the differences between the LIVE policy and restored policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreCoreNetworkPolicyVersionRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreCoreNetworkPolicyVersionRequest#builder()}
     * </p>
     *
     * @param restoreCoreNetworkPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link RestoreCoreNetworkPolicyVersionRequest.Builder} to
     *        create a request.
     * @return Result of the RestoreCoreNetworkPolicyVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.RestoreCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RestoreCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreCoreNetworkPolicyVersionResponse restoreCoreNetworkPolicyVersion(
            Consumer<RestoreCoreNetworkPolicyVersionRequest.Builder> restoreCoreNetworkPolicyVersionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkManagerException {
        return restoreCoreNetworkPolicyVersion(RestoreCoreNetworkPolicyVersionRequest.builder()
                .applyMutation(restoreCoreNetworkPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Enables the Network Manager service for an Amazon Web Services Organization. This can only be called by a
     * management account within the organization.
     * </p>
     *
     * @param startOrganizationServiceAccessUpdateRequest
     * @return Result of the StartOrganizationServiceAccessUpdate operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.StartOrganizationServiceAccessUpdate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartOrganizationServiceAccessUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default StartOrganizationServiceAccessUpdateResponse startOrganizationServiceAccessUpdate(
            StartOrganizationServiceAccessUpdateRequest startOrganizationServiceAccessUpdateRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Network Manager service for an Amazon Web Services Organization. This can only be called by a
     * management account within the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartOrganizationServiceAccessUpdateRequest.Builder} avoiding the need to create one manually via
     * {@link StartOrganizationServiceAccessUpdateRequest#builder()}
     * </p>
     *
     * @param startOrganizationServiceAccessUpdateRequest
     *        A {@link Consumer} that will call methods on {@link StartOrganizationServiceAccessUpdateRequest.Builder}
     *        to create a request.
     * @return Result of the StartOrganizationServiceAccessUpdate operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.StartOrganizationServiceAccessUpdate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartOrganizationServiceAccessUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default StartOrganizationServiceAccessUpdateResponse startOrganizationServiceAccessUpdate(
            Consumer<StartOrganizationServiceAccessUpdateRequest.Builder> startOrganizationServiceAccessUpdateRequest)
            throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return startOrganizationServiceAccessUpdate(StartOrganizationServiceAccessUpdateRequest.builder()
                .applyMutation(startOrganizationServiceAccessUpdateRequest).build());
    }

    /**
     * <p>
     * Starts analyzing the routing path between the specified source and destination. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.
     * </p>
     *
     * @param startRouteAnalysisRequest
     * @return Result of the StartRouteAnalysis operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.StartRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRouteAnalysisResponse startRouteAnalysis(StartRouteAnalysisRequest startRouteAnalysisRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts analyzing the routing path between the specified source and destination. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRouteAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link StartRouteAnalysisRequest#builder()}
     * </p>
     *
     * @param startRouteAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link StartRouteAnalysisRequest.Builder} to create a
     *        request.
     * @return Result of the StartRouteAnalysis operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.StartRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRouteAnalysisResponse startRouteAnalysis(Consumer<StartRouteAnalysisRequest.Builder> startRouteAnalysisRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return startRouteAnalysis(StartRouteAnalysisRequest.builder().applyMutation(startRouteAnalysisRequest).build());
    }

    /**
     * <p>
     * Tags a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an
     * empty string.
     * </p>
     *
     * @param updateConnectionRequest
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an
     * empty string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectionRequest#builder()}
     * </p>
     *
     * @param updateConnectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectionRequest.Builder} to create a request.
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionResponse updateConnection(Consumer<UpdateConnectionRequest.Builder> updateConnectionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return updateConnection(UpdateConnectionRequest.builder().applyMutation(updateConnectionRequest).build());
    }

    /**
     * <p>
     * Updates the description of a core network.
     * </p>
     *
     * @param updateCoreNetworkRequest
     * @return Result of the UpdateCoreNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCoreNetworkResponse updateCoreNetwork(UpdateCoreNetworkRequest updateCoreNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCoreNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCoreNetworkRequest#builder()}
     * </p>
     *
     * @param updateCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCoreNetworkRequest.Builder} to create a request.
     * @return Result of the UpdateCoreNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCoreNetworkResponse updateCoreNetwork(Consumer<UpdateCoreNetworkRequest.Builder> updateCoreNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return updateCoreNetwork(UpdateCoreNetworkRequest.builder().applyMutation(updateCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     *
     * @param updateDeviceRequest
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDeviceRequest#builder()}
     * </p>
     *
     * @param updateDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceRequest.Builder} to create a request.
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceResponse updateDevice(Consumer<UpdateDeviceRequest.Builder> updateDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return updateDevice(UpdateDeviceRequest.builder().applyMutation(updateDeviceRequest).build());
    }

    /**
     * <p>
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     * </p>
     *
     * @param updateGlobalNetworkRequest
     * @return Result of the UpdateGlobalNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGlobalNetworkResponse updateGlobalNetwork(UpdateGlobalNetworkRequest updateGlobalNetworkRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalNetworkRequest#builder()}
     * </p>
     *
     * @param updateGlobalNetworkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGlobalNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateGlobalNetwork operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGlobalNetworkResponse updateGlobalNetwork(
            Consumer<UpdateGlobalNetworkRequest.Builder> updateGlobalNetworkRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return updateGlobalNetwork(UpdateGlobalNetworkRequest.builder().applyMutation(updateGlobalNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     *
     * @param updateLinkRequest
     * @return Result of the UpdateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLinkResponse updateLink(UpdateLinkRequest updateLinkRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLinkRequest#builder()}
     * </p>
     *
     * @param updateLinkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLinkRequest.Builder} to create a request.
     * @return Result of the UpdateLink operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws ServiceQuotaExceededException
     *         A service limit was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLinkResponse updateLink(Consumer<UpdateLinkRequest.Builder> updateLinkRequest) throws ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return updateLink(UpdateLinkRequest.builder().applyMutation(updateLinkRequest).build());
    }

    /**
     * <p>
     * Updates the resource metadata for the specified global network.
     * </p>
     *
     * @param updateNetworkResourceMetadataRequest
     * @return Result of the UpdateNetworkResourceMetadata operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateNetworkResourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateNetworkResourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkResourceMetadataResponse updateNetworkResourceMetadata(
            UpdateNetworkResourceMetadataRequest updateNetworkResourceMetadataRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resource metadata for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkResourceMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNetworkResourceMetadataRequest#builder()}
     * </p>
     *
     * @param updateNetworkResourceMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkResourceMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateNetworkResourceMetadata operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateNetworkResourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateNetworkResourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkResourceMetadataResponse updateNetworkResourceMetadata(
            Consumer<UpdateNetworkResourceMetadataRequest.Builder> updateNetworkResourceMetadataRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return updateNetworkResourceMetadata(UpdateNetworkResourceMetadataRequest.builder()
                .applyMutation(updateNetworkResourceMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     *
     * @param updateSiteRequest
     * @return Result of the UpdateSite operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSiteResponse updateSite(UpdateSiteRequest updateSiteRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSiteRequest#builder()}
     * </p>
     *
     * @param updateSiteRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSiteRequest.Builder} to create a request.
     * @return Result of the UpdateSite operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSiteResponse updateSite(Consumer<UpdateSiteRequest.Builder> updateSiteRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return updateSite(UpdateSiteRequest.builder().applyMutation(updateSiteRequest).build());
    }

    /**
     * <p>
     * Updates a VPC attachment.
     * </p>
     *
     * @param updateVpcAttachmentRequest
     * @return Result of the UpdateVpcAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVpcAttachmentResponse updateVpcAttachment(UpdateVpcAttachmentRequest updateVpcAttachmentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a VPC attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param updateVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVpcAttachmentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateVpcAttachment operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent
     *         state.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request has failed due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkManagerClient.UpdateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVpcAttachmentResponse updateVpcAttachment(
            Consumer<UpdateVpcAttachmentRequest.Builder> updateVpcAttachmentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, NetworkManagerException {
        return updateVpcAttachment(UpdateVpcAttachmentRequest.builder().applyMutation(updateVpcAttachmentRequest).build());
    }

    /**
     * Create a {@link NetworkManagerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkManagerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkManagerClient}.
     */
    static NetworkManagerClientBuilder builder() {
        return new DefaultNetworkManagerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    NetworkManagerServiceClientConfiguration serviceClientConfiguration();
}
