/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest;
import software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest;
import software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinksRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinksResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse;
import software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest;
import software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisResponse;
import software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.GetSitesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSitesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusRequest;
import software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionRequest;
import software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse;
import software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateRequest;
import software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse;
import software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest;
import software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse;
import software.amazon.awssdk.services.networkmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse;
import software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetDevicesPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinksPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetSitesPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksPublisher;
import software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsPublisher;

/**
 * Service client for accessing NetworkManager asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Web Services enables you to centrally manage your Amazon Web Services Cloud WAN core network and your Transit
 * Gateway network across Amazon Web Services accounts, Regions, and on-premises locations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkManagerAsyncClient extends SdkClient {
    String SERVICE_NAME = "networkmanager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "networkmanager";

    /**
     * <p>
     * Accepts a core network attachment request.
     * </p>
     * <p>
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a
     * core network.
     * </p>
     *
     * @param acceptAttachmentRequest
     * @return A Java Future containing the result of the AcceptAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AcceptAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AcceptAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptAttachmentResponse> acceptAttachment(AcceptAttachmentRequest acceptAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a core network attachment request.
     * </p>
     * <p>
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a
     * core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link AcceptAttachmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AcceptAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AcceptAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptAttachmentResponse> acceptAttachment(
            Consumer<AcceptAttachmentRequest.Builder> acceptAttachmentRequest) {
        return acceptAttachment(AcceptAttachmentRequest.builder().applyMutation(acceptAttachmentRequest).build());
    }

    /**
     * <p>
     * Associates a core network Connect peer with a device and optionally, with a link.
     * </p>
     * <p>
     * If you specify a link, it must be associated with the specified device. You can only associate core network
     * Connect peers that have been created on a core network Connect attachment on a core network.
     * </p>
     *
     * @param associateConnectPeerRequest
     * @return A Java Future containing the result of the AssociateConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateConnectPeerResponse> associateConnectPeer(
            AssociateConnectPeerRequest associateConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a core network Connect peer with a device and optionally, with a link.
     * </p>
     * <p>
     * If you specify a link, it must be associated with the specified device. You can only associate core network
     * Connect peers that have been created on a core network Connect attachment on a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateConnectPeerRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateConnectPeerRequest#builder()}
     * </p>
     *
     * @param associateConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateConnectPeerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateConnectPeerResponse> associateConnectPeer(
            Consumer<AssociateConnectPeerRequest.Builder> associateConnectPeerRequest) {
        return associateConnectPeer(AssociateConnectPeerRequest.builder().applyMutation(associateConnectPeerRequest).build());
    }

    /**
     * <p>
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be
     * associated with the specified device.
     * </p>
     * <p>
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core
     * network registered in your global network. When you register a transit gateway or core network, customer gateways
     * that are connected to the transit gateway are automatically included in the global network. To list customer
     * gateways that are connected to a transit gateway, use the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html"
     * >DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.
     * </p>
     * <p>
     * You cannot associate a customer gateway with more than one device and link.
     * </p>
     *
     * @param associateCustomerGatewayRequest
     * @return A Java Future containing the result of the AssociateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateCustomerGatewayResponse> associateCustomerGateway(
            AssociateCustomerGatewayRequest associateCustomerGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be
     * associated with the specified device.
     * </p>
     * <p>
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core
     * network registered in your global network. When you register a transit gateway or core network, customer gateways
     * that are connected to the transit gateway are automatically included in the global network. To list customer
     * gateways that are connected to a transit gateway, use the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html"
     * >DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.
     * </p>
     * <p>
     * You cannot associate a customer gateway with more than one device and link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateCustomerGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param associateCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on {@link AssociateCustomerGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateCustomerGatewayResponse> associateCustomerGateway(
            Consumer<AssociateCustomerGatewayRequest.Builder> associateCustomerGatewayRequest) {
        return associateCustomerGateway(AssociateCustomerGatewayRequest.builder().applyMutation(associateCustomerGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to
     * multiple devices. The device and link must be in the same global network and the same site.
     * </p>
     *
     * @param associateLinkRequest
     * @return A Java Future containing the result of the AssociateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateLink" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateLinkResponse> associateLink(AssociateLinkRequest associateLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to
     * multiple devices. The device and link must be in the same global network and the same site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateLinkRequest#builder()}
     * </p>
     *
     * @param associateLinkRequest
     *        A {@link Consumer} that will call methods on {@link AssociateLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateLink" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateLinkResponse> associateLink(Consumer<AssociateLinkRequest.Builder> associateLinkRequest) {
        return associateLink(AssociateLinkRequest.builder().applyMutation(associateLinkRequest).build());
    }

    /**
     * <p>
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it
     * must be associated with the specified device.
     * </p>
     * <p>
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's
     * registered in your global network.
     * </p>
     * <p>
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     * </p>
     *
     * @param associateTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTransitGatewayConnectPeerResponse> associateTransitGatewayConnectPeer(
            AssociateTransitGatewayConnectPeerRequest associateTransitGatewayConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it
     * must be associated with the specified device.
     * </p>
     * <p>
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's
     * registered in your global network.
     * </p>
     * <p>
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTransitGatewayConnectPeerRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTransitGatewayConnectPeerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.AssociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTransitGatewayConnectPeerResponse> associateTransitGatewayConnectPeer(
            Consumer<AssociateTransitGatewayConnectPeerRequest.Builder> associateTransitGatewayConnectPeerRequest) {
        return associateTransitGatewayConnectPeer(AssociateTransitGatewayConnectPeerRequest.builder()
                .applyMutation(associateTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Creates a core network Connect attachment from a specified core network attachment.
     * </p>
     * <p>
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection
     * between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the
     * underlying transport mechanism.
     * </p>
     *
     * @param createConnectAttachmentRequest
     * @return A Java Future containing the result of the CreateConnectAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectAttachmentResponse> createConnectAttachment(
            CreateConnectAttachmentRequest createConnectAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a core network Connect attachment from a specified core network attachment.
     * </p>
     * <p>
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection
     * between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the
     * underlying transport mechanism.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectAttachmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectAttachmentRequest#builder()}
     * </p>
     *
     * @param createConnectAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnectAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectAttachmentResponse> createConnectAttachment(
            Consumer<CreateConnectAttachmentRequest.Builder> createConnectAttachmentRequest) {
        return createConnectAttachment(CreateConnectAttachmentRequest.builder().applyMutation(createConnectAttachmentRequest)
                .build());
    }

    /**
     * <p>
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an
     * appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     *
     * @param createConnectPeerRequest
     * @return A Java Future containing the result of the CreateConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectPeerResponse> createConnectPeer(CreateConnectPeerRequest createConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an
     * appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectPeerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectPeerRequest#builder()}
     * </p>
     *
     * @param createConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectPeerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectPeerResponse> createConnectPeer(
            Consumer<CreateConnectPeerRequest.Builder> createConnectPeerRequest) {
        return createConnectPeer(CreateConnectPeerRequest.builder().applyMutation(createConnectPeerRequest).build());
    }

    /**
     * <p>
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a
     * third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an
     * on-premises network.
     * </p>
     *
     * @param createConnectionRequest
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a
     * third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an
     * on-premises network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(
            Consumer<CreateConnectionRequest.Builder> createConnectionRequest) {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     * </p>
     *
     * @param createCoreNetworkRequest
     * @return A Java Future containing the result of the CreateCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CoreNetworkPolicyException Describes a core network policy exception.</li>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCoreNetworkResponse> createCoreNetwork(CreateCoreNetworkRequest createCoreNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoreNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCoreNetworkRequest#builder()}
     * </p>
     *
     * @param createCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateCoreNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CoreNetworkPolicyException Describes a core network policy exception.</li>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCoreNetworkResponse> createCoreNetwork(
            Consumer<CreateCoreNetworkRequest.Builder> createCoreNetworkRequest) {
        return createCoreNetwork(CreateCoreNetworkRequest.builder().applyMutation(createCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site
     * is used for visualization in the Network Manager console.
     * </p>
     *
     * @param createDeviceRequest
     * @return A Java Future containing the result of the CreateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeviceResponse> createDevice(CreateDeviceRequest createDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site
     * is used for visualization in the Network Manager console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDeviceRequest#builder()}
     * </p>
     *
     * @param createDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeviceResponse> createDevice(Consumer<CreateDeviceRequest.Builder> createDeviceRequest) {
        return createDevice(CreateDeviceRequest.builder().applyMutation(createDeviceRequest).build());
    }

    /**
     * <p>
     * Creates a new, empty global network.
     * </p>
     *
     * @param createGlobalNetworkRequest
     * @return A Java Future containing the result of the CreateGlobalNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGlobalNetworkResponse> createGlobalNetwork(
            CreateGlobalNetworkRequest createGlobalNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, empty global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalNetworkRequest#builder()}
     * </p>
     *
     * @param createGlobalNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateGlobalNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGlobalNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGlobalNetworkResponse> createGlobalNetwork(
            Consumer<CreateGlobalNetworkRequest.Builder> createGlobalNetworkRequest) {
        return createGlobalNetwork(CreateGlobalNetworkRequest.builder().applyMutation(createGlobalNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a new link for a specified site.
     * </p>
     *
     * @param createLinkRequest
     * @return A Java Future containing the result of the CreateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLinkResponse> createLink(CreateLinkRequest createLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new link for a specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLinkRequest#builder()}
     * </p>
     *
     * @param createLinkRequest
     *        A {@link Consumer} that will call methods on {@link CreateLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLinkResponse> createLink(Consumer<CreateLinkRequest.Builder> createLinkRequest) {
        return createLink(CreateLinkRequest.builder().applyMutation(createLinkRequest).build());
    }

    /**
     * <p>
     * Creates a new site in a global network.
     * </p>
     *
     * @param createSiteRequest
     * @return A Java Future containing the result of the CreateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSiteResponse> createSite(CreateSiteRequest createSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new site in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSiteRequest#builder()}
     * </p>
     *
     * @param createSiteRequest
     *        A {@link Consumer} that will call methods on {@link CreateSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSiteResponse> createSite(Consumer<CreateSiteRequest.Builder> createSiteRequest) {
        return createSite(CreateSiteRequest.builder().applyMutation(createSiteRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     * </p>
     *
     * @param createSiteToSiteVpnAttachmentRequest
     * @return A Java Future containing the result of the CreateSiteToSiteVpnAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSiteToSiteVpnAttachmentResponse> createSiteToSiteVpnAttachment(
            CreateSiteToSiteVpnAttachmentRequest createSiteToSiteVpnAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteToSiteVpnAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSiteToSiteVpnAttachmentRequest#builder()}
     * </p>
     *
     * @param createSiteToSiteVpnAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateSiteToSiteVpnAttachmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSiteToSiteVpnAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSiteToSiteVpnAttachmentResponse> createSiteToSiteVpnAttachment(
            Consumer<CreateSiteToSiteVpnAttachmentRequest.Builder> createSiteToSiteVpnAttachmentRequest) {
        return createSiteToSiteVpnAttachment(CreateSiteToSiteVpnAttachmentRequest.builder()
                .applyMutation(createSiteToSiteVpnAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway peering connection.
     * </p>
     *
     * @param createTransitGatewayPeeringRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPeering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayPeeringResponse> createTransitGatewayPeering(
            CreateTransitGatewayPeeringRequest createTransitGatewayPeeringRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayPeeringRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayPeeringRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPeeringRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayPeeringRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateTransitGatewayPeering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayPeeringResponse> createTransitGatewayPeering(
            Consumer<CreateTransitGatewayPeeringRequest.Builder> createTransitGatewayPeeringRequest) {
        return createTransitGatewayPeering(CreateTransitGatewayPeeringRequest.builder()
                .applyMutation(createTransitGatewayPeeringRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway route table attachment.
     * </p>
     *
     * @param createTransitGatewayRouteTableAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTableAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayRouteTableAttachmentResponse> createTransitGatewayRouteTableAttachment(
            CreateTransitGatewayRouteTableAttachmentRequest createTransitGatewayRouteTableAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway route table attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayRouteTableAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayRouteTableAttachmentRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteTableAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateTransitGatewayRouteTableAttachmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTableAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayRouteTableAttachmentResponse> createTransitGatewayRouteTableAttachment(
            Consumer<CreateTransitGatewayRouteTableAttachmentRequest.Builder> createTransitGatewayRouteTableAttachmentRequest) {
        return createTransitGatewayRouteTableAttachment(CreateTransitGatewayRouteTableAttachmentRequest.builder()
                .applyMutation(createTransitGatewayRouteTableAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates a VPC attachment on an edge location of a core network.
     * </p>
     *
     * @param createVpcAttachmentRequest
     * @return A Java Future containing the result of the CreateVpcAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcAttachmentResponse> createVpcAttachment(
            CreateVpcAttachmentRequest createVpcAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC attachment on an edge location of a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param createVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVpcAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.CreateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcAttachmentResponse> createVpcAttachment(
            Consumer<CreateVpcAttachmentRequest.Builder> createVpcAttachmentRequest) {
        return createVpcAttachment(CreateVpcAttachmentRequest.builder().applyMutation(createVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes an attachment. Supports all attachment types.
     * </p>
     *
     * @param deleteAttachmentRequest
     * @return A Java Future containing the result of the DeleteAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAttachmentResponse> deleteAttachment(DeleteAttachmentRequest deleteAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attachment. Supports all attachment types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAttachmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAttachmentResponse> deleteAttachment(
            Consumer<DeleteAttachmentRequest.Builder> deleteAttachmentRequest) {
        return deleteAttachment(DeleteAttachmentRequest.builder().applyMutation(deleteAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes a Connect peer.
     * </p>
     *
     * @param deleteConnectPeerRequest
     * @return A Java Future containing the result of the DeleteConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectPeerResponse> deleteConnectPeer(DeleteConnectPeerRequest deleteConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Connect peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectPeerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectPeerRequest#builder()}
     * </p>
     *
     * @param deleteConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectPeerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectPeerResponse> deleteConnectPeer(
            Consumer<DeleteConnectPeerRequest.Builder> deleteConnectPeerRequest) {
        return deleteConnectPeer(DeleteConnectPeerRequest.builder().applyMutation(deleteConnectPeerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified connection in your global network.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connection in your global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on
     * a core network.
     * </p>
     *
     * @param deleteCoreNetworkRequest
     * @return A Java Future containing the result of the DeleteCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCoreNetworkResponse> deleteCoreNetwork(DeleteCoreNetworkRequest deleteCoreNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on
     * a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCoreNetworkRequest#builder()}
     * </p>
     *
     * @param deleteCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCoreNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCoreNetworkResponse> deleteCoreNetwork(
            Consumer<DeleteCoreNetworkRequest.Builder> deleteCoreNetworkRequest) {
        return deleteCoreNetwork(DeleteCoreNetworkRequest.builder().applyMutation(deleteCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     * </p>
     *
     * @param deleteCoreNetworkPolicyVersionRequest
     * @return A Java Future containing the result of the DeleteCoreNetworkPolicyVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCoreNetworkPolicyVersionResponse> deleteCoreNetworkPolicyVersion(
            DeleteCoreNetworkPolicyVersionRequest deleteCoreNetworkPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreNetworkPolicyVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCoreNetworkPolicyVersionRequest#builder()}
     * </p>
     *
     * @param deleteCoreNetworkPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCoreNetworkPolicyVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCoreNetworkPolicyVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCoreNetworkPolicyVersionResponse> deleteCoreNetworkPolicyVersion(
            Consumer<DeleteCoreNetworkPolicyVersionRequest.Builder> deleteCoreNetworkPolicyVersionRequest) {
        return deleteCoreNetworkPolicyVersion(DeleteCoreNetworkPolicyVersionRequest.builder()
                .applyMutation(deleteCoreNetworkPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceResponse> deleteDevice(DeleteDeviceRequest deleteDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeviceRequest#builder()}
     * </p>
     *
     * @param deleteDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceResponse> deleteDevice(Consumer<DeleteDeviceRequest.Builder> deleteDeviceRequest) {
        return deleteDevice(DeleteDeviceRequest.builder().applyMutation(deleteDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites),
     * deregister all transit gateways, and delete any core networks.
     * </p>
     *
     * @param deleteGlobalNetworkRequest
     * @return A Java Future containing the result of the DeleteGlobalNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalNetworkResponse> deleteGlobalNetwork(
            DeleteGlobalNetworkRequest deleteGlobalNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites),
     * deregister all transit gateways, and delete any core networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalNetworkRequest#builder()}
     * </p>
     *
     * @param deleteGlobalNetworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGlobalNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGlobalNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalNetworkResponse> deleteGlobalNetwork(
            Consumer<DeleteGlobalNetworkRequest.Builder> deleteGlobalNetworkRequest) {
        return deleteGlobalNetwork(DeleteGlobalNetworkRequest.builder().applyMutation(deleteGlobalNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     * </p>
     *
     * @param deleteLinkRequest
     * @return A Java Future containing the result of the DeleteLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLinkResponse> deleteLink(DeleteLinkRequest deleteLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLinkRequest#builder()}
     * </p>
     *
     * @param deleteLinkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLinkResponse> deleteLink(Consumer<DeleteLinkRequest.Builder> deleteLinkRequest) {
        return deleteLink(DeleteLinkRequest.builder().applyMutation(deleteLinkRequest).build());
    }

    /**
     * <p>
     * Deletes an existing peering connection.
     * </p>
     *
     * @param deletePeeringRequest
     * @return A Java Future containing the result of the DeletePeering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeletePeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeletePeering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePeeringResponse> deletePeering(DeletePeeringRequest deletePeeringRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePeeringRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePeeringRequest#builder()}
     * </p>
     *
     * @param deletePeeringRequest
     *        A {@link Consumer} that will call methods on {@link DeletePeeringRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePeering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeletePeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeletePeering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePeeringResponse> deletePeering(Consumer<DeletePeeringRequest.Builder> deletePeeringRequest) {
        return deletePeering(DeletePeeringRequest.builder().applyMutation(deletePeeringRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the
     * resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the
     * resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing site. The site cannot be associated with any device or link.
     * </p>
     *
     * @param deleteSiteRequest
     * @return A Java Future containing the result of the DeleteSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSiteResponse> deleteSite(DeleteSiteRequest deleteSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing site. The site cannot be associated with any device or link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSiteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSiteRequest#builder()}
     * </p>
     *
     * @param deleteSiteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSiteResponse> deleteSite(Consumer<DeleteSiteRequest.Builder> deleteSiteRequest) {
        return deleteSite(DeleteSiteRequest.builder().applyMutation(deleteSiteRequest).build());
    }

    /**
     * <p>
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or
     * modify any of its attachments. This action removes any customer gateway associations.
     * </p>
     *
     * @param deregisterTransitGatewayRequest
     * @return A Java Future containing the result of the DeregisterTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeregisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeregisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTransitGatewayResponse> deregisterTransitGateway(
            DeregisterTransitGatewayRequest deregisterTransitGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or
     * modify any of its attachments. This action removes any customer gateway associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTransitGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterTransitGatewayRequest#builder()}
     * </p>
     *
     * @param deregisterTransitGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTransitGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DeregisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeregisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTransitGatewayResponse> deregisterTransitGateway(
            Consumer<DeregisterTransitGatewayRequest.Builder> deregisterTransitGatewayRequest) {
        return deregisterTransitGateway(DeregisterTransitGatewayRequest.builder().applyMutation(deregisterTransitGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     *
     * @param describeGlobalNetworksRequest
     * @return A Java Future containing the result of the DescribeGlobalNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalNetworksResponse> describeGlobalNetworks(
            DescribeGlobalNetworksRequest describeGlobalNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalNetworksRequest#builder()}
     * </p>
     *
     * @param describeGlobalNetworksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalNetworksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGlobalNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalNetworksResponse> describeGlobalNetworks(
            Consumer<DescribeGlobalNetworksRequest.Builder> describeGlobalNetworksRequest) {
        return describeGlobalNetworks(DescribeGlobalNetworksRequest.builder().applyMutation(describeGlobalNetworksRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksPublisher publisher = client.describeGlobalNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksPublisher publisher = client.describeGlobalNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalNetworksPublisher describeGlobalNetworksPaginator(
            DescribeGlobalNetworksRequest describeGlobalNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in
     * your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit
     * gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksPublisher publisher = client.describeGlobalNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksPublisher publisher = client.describeGlobalNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalNetworks(software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalNetworksRequest#builder()}
     * </p>
     *
     * @param describeGlobalNetworksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalNetworksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DescribeGlobalNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DescribeGlobalNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalNetworksPublisher describeGlobalNetworksPaginator(
            Consumer<DescribeGlobalNetworksRequest.Builder> describeGlobalNetworksRequest) {
        return describeGlobalNetworksPaginator(DescribeGlobalNetworksRequest.builder()
                .applyMutation(describeGlobalNetworksRequest).build());
    }

    /**
     * <p>
     * Disassociates a core network Connect peer from a device and a link.
     * </p>
     *
     * @param disassociateConnectPeerRequest
     * @return A Java Future containing the result of the DisassociateConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateConnectPeerResponse> disassociateConnectPeer(
            DisassociateConnectPeerRequest disassociateConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a core network Connect peer from a device and a link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateConnectPeerRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateConnectPeerRequest#builder()}
     * </p>
     *
     * @param disassociateConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateConnectPeerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateConnectPeerResponse> disassociateConnectPeer(
            Consumer<DisassociateConnectPeerRequest.Builder> disassociateConnectPeerRequest) {
        return disassociateConnectPeer(DisassociateConnectPeerRequest.builder().applyMutation(disassociateConnectPeerRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a customer gateway from a device and a link.
     * </p>
     *
     * @param disassociateCustomerGatewayRequest
     * @return A Java Future containing the result of the DisassociateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateCustomerGatewayResponse> disassociateCustomerGateway(
            DisassociateCustomerGatewayRequest disassociateCustomerGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a customer gateway from a device and a link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateCustomerGatewayRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param disassociateCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateCustomerGatewayRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateCustomerGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateCustomerGatewayResponse> disassociateCustomerGateway(
            Consumer<DisassociateCustomerGatewayRequest.Builder> disassociateCustomerGatewayRequest) {
        return disassociateCustomerGateway(DisassociateCustomerGatewayRequest.builder()
                .applyMutation(disassociateCustomerGatewayRequest).build());
    }

    /**
     * <p>
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are
     * associated with the link.
     * </p>
     *
     * @param disassociateLinkRequest
     * @return A Java Future containing the result of the DisassociateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLinkResponse> disassociateLink(DisassociateLinkRequest disassociateLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are
     * associated with the link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLinkRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateLinkRequest#builder()}
     * </p>
     *
     * @param disassociateLinkRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLinkResponse> disassociateLink(
            Consumer<DisassociateLinkRequest.Builder> disassociateLinkRequest) {
        return disassociateLink(DisassociateLinkRequest.builder().applyMutation(disassociateLinkRequest).build());
    }

    /**
     * <p>
     * Disassociates a transit gateway Connect peer from a device and link.
     * </p>
     *
     * @param disassociateTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the DisassociateTransitGatewayConnectPeer operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTransitGatewayConnectPeerResponse> disassociateTransitGatewayConnectPeer(
            DisassociateTransitGatewayConnectPeerRequest disassociateTransitGatewayConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a transit gateway Connect peer from a device and link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateTransitGatewayConnectPeerRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param disassociateTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateTransitGatewayConnectPeerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateTransitGatewayConnectPeer operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.DisassociateTransitGatewayConnectPeer
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTransitGatewayConnectPeerResponse> disassociateTransitGatewayConnectPeer(
            Consumer<DisassociateTransitGatewayConnectPeerRequest.Builder> disassociateTransitGatewayConnectPeerRequest) {
        return disassociateTransitGatewayConnectPeer(DisassociateTransitGatewayConnectPeerRequest.builder()
                .applyMutation(disassociateTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     * </p>
     *
     * @param executeCoreNetworkChangeSetRequest
     * @return A Java Future containing the result of the ExecuteCoreNetworkChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ExecuteCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ExecuteCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteCoreNetworkChangeSetResponse> executeCoreNetworkChangeSet(
            ExecuteCoreNetworkChangeSetRequest executeCoreNetworkChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteCoreNetworkChangeSetRequest.Builder}
     * avoiding the need to create one manually via {@link ExecuteCoreNetworkChangeSetRequest#builder()}
     * </p>
     *
     * @param executeCoreNetworkChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteCoreNetworkChangeSetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ExecuteCoreNetworkChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ExecuteCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ExecuteCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteCoreNetworkChangeSetResponse> executeCoreNetworkChangeSet(
            Consumer<ExecuteCoreNetworkChangeSetRequest.Builder> executeCoreNetworkChangeSetRequest) {
        return executeCoreNetworkChangeSet(ExecuteCoreNetworkChangeSetRequest.builder()
                .applyMutation(executeCoreNetworkChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect attachment.
     * </p>
     *
     * @param getConnectAttachmentRequest
     * @return A Java Future containing the result of the GetConnectAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectAttachmentResponse> getConnectAttachment(
            GetConnectAttachmentRequest getConnectAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectAttachmentRequest#builder()}
     * </p>
     *
     * @param getConnectAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnectAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectAttachmentResponse> getConnectAttachment(
            Consumer<GetConnectAttachmentRequest.Builder> getConnectAttachmentRequest) {
        return getConnectAttachment(GetConnectAttachmentRequest.builder().applyMutation(getConnectAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect peer.
     * </p>
     *
     * @param getConnectPeerRequest
     * @return A Java Future containing the result of the GetConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConnectPeerResponse> getConnectPeer(GetConnectPeerRequest getConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectPeerRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectPeerRequest#builder()}
     * </p>
     *
     * @param getConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectPeerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnectPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConnectPeerResponse> getConnectPeer(Consumer<GetConnectPeerRequest.Builder> getConnectPeerRequest) {
        return getConnectPeer(GetConnectPeerRequest.builder().applyMutation(getConnectPeerRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     * @return A Java Future containing the result of the GetConnectPeerAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectPeerAssociationsResponse> getConnectPeerAssociations(
            GetConnectPeerAssociationsRequest getConnectPeerAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectPeerAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectPeerAssociationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnectPeerAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectPeerAssociationsResponse> getConnectPeerAssociations(
            Consumer<GetConnectPeerAssociationsRequest.Builder> getConnectPeerAssociationsRequest) {
        return getConnectPeerAssociations(GetConnectPeerAssociationsRequest.builder()
                .applyMutation(getConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsPublisher publisher = client.getConnectPeerAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsPublisher publisher = client.getConnectPeerAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectPeerAssociationsPublisher getConnectPeerAssociationsPaginator(
            GetConnectPeerAssociationsRequest getConnectPeerAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network Connect peer associations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsPublisher publisher = client.getConnectPeerAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectPeerAssociationsPublisher publisher = client.getConnectPeerAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectPeerAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectPeerAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnectPeerAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectPeerAssociationsPublisher getConnectPeerAssociationsPaginator(
            Consumer<GetConnectPeerAssociationsRequest.Builder> getConnectPeerAssociationsRequest) {
        return getConnectPeerAssociationsPaginator(GetConnectPeerAssociationsRequest.builder()
                .applyMutation(getConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     *
     * @param getConnectionsRequest
     * @return A Java Future containing the result of the GetConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConnectionsResponse> getConnections(GetConnectionsRequest getConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConnectionsResponse> getConnections(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest) {
        return getConnections(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionsPublisher getConnectionsPaginator(GetConnectionsRequest getConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your connections in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionsPublisher getConnectionsPaginator(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest) {
        return getConnectionsPaginator(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the LIVE policy for a core network.
     * </p>
     *
     * @param getCoreNetworkRequest
     * @return A Java Future containing the result of the GetCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkResponse> getCoreNetwork(GetCoreNetworkRequest getCoreNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the LIVE policy for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetCoreNetworkRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkResponse> getCoreNetwork(Consumer<GetCoreNetworkRequest.Builder> getCoreNetworkRequest) {
        return getCoreNetwork(GetCoreNetworkRequest.builder().applyMutation(getCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     * @return A Java Future containing the result of the GetCoreNetworkChangeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkChangeEventsResponse> getCoreNetworkChangeEvents(
            GetCoreNetworkChangeEventsRequest getCoreNetworkChangeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeEventsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeEventsRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCoreNetworkChangeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkChangeEventsResponse> getCoreNetworkChangeEvents(
            Consumer<GetCoreNetworkChangeEventsRequest.Builder> getCoreNetworkChangeEventsRequest) {
        return getCoreNetworkChangeEvents(GetCoreNetworkChangeEventsRequest.builder()
                .applyMutation(getCoreNetworkChangeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsPublisher publisher = client.getCoreNetworkChangeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsPublisher publisher = client.getCoreNetworkChangeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeEventsPublisher getCoreNetworkChangeEventsPaginator(
            GetCoreNetworkChangeEventsRequest getCoreNetworkChangeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a core network change event.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsPublisher publisher = client.getCoreNetworkChangeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeEventsPublisher publisher = client.getCoreNetworkChangeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeEvents(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeEventsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeEventsRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeEventsRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeEventsPublisher getCoreNetworkChangeEventsPaginator(
            Consumer<GetCoreNetworkChangeEventsRequest.Builder> getCoreNetworkChangeEventsRequest) {
        return getCoreNetworkChangeEventsPaginator(GetCoreNetworkChangeEventsRequest.builder()
                .applyMutation(getCoreNetworkChangeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     * @return A Java Future containing the result of the GetCoreNetworkChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkChangeSetResponse> getCoreNetworkChangeSet(
            GetCoreNetworkChangeSetRequest getCoreNetworkChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeSetRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeSetRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCoreNetworkChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkChangeSetResponse> getCoreNetworkChangeSet(
            Consumer<GetCoreNetworkChangeSetRequest.Builder> getCoreNetworkChangeSetRequest) {
        return getCoreNetworkChangeSet(GetCoreNetworkChangeSetRequest.builder().applyMutation(getCoreNetworkChangeSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetPublisher publisher = client.getCoreNetworkChangeSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetPublisher publisher = client.getCoreNetworkChangeSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeSetPublisher getCoreNetworkChangeSetPaginator(
            GetCoreNetworkChangeSetRequest getCoreNetworkChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a change set between the LIVE core network policy and a submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetPublisher publisher = client.getCoreNetworkChangeSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCoreNetworkChangeSetPublisher publisher = client.getCoreNetworkChangeSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCoreNetworkChangeSet(software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkChangeSetRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreNetworkChangeSetRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkChangeSetRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreNetworkChangeSetPublisher getCoreNetworkChangeSetPaginator(
            Consumer<GetCoreNetworkChangeSetRequest.Builder> getCoreNetworkChangeSetRequest) {
        return getCoreNetworkChangeSetPaginator(GetCoreNetworkChangeSetRequest.builder()
                .applyMutation(getCoreNetworkChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns details about a core network policy. You can get details about your current live policy or any previous
     * policy version.
     * </p>
     *
     * @param getCoreNetworkPolicyRequest
     * @return A Java Future containing the result of the GetCoreNetworkPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkPolicyResponse> getCoreNetworkPolicy(
            GetCoreNetworkPolicyRequest getCoreNetworkPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a core network policy. You can get details about your current live policy or any previous
     * policy version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreNetworkPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetCoreNetworkPolicyRequest#builder()}
     * </p>
     *
     * @param getCoreNetworkPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreNetworkPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCoreNetworkPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreNetworkPolicyResponse> getCoreNetworkPolicy(
            Consumer<GetCoreNetworkPolicyRequest.Builder> getCoreNetworkPolicyRequest) {
        return getCoreNetworkPolicy(GetCoreNetworkPolicyRequest.builder().applyMutation(getCoreNetworkPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     * @return A Java Future containing the result of the GetCustomerGatewayAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomerGatewayAssociationsResponse> getCustomerGatewayAssociations(
            GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomerGatewayAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomerGatewayAssociationsRequest#builder()}
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomerGatewayAssociationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCustomerGatewayAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomerGatewayAssociationsResponse> getCustomerGatewayAssociations(
            Consumer<GetCustomerGatewayAssociationsRequest.Builder> getCustomerGatewayAssociationsRequest) {
        return getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest.builder()
                .applyMutation(getCustomerGatewayAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsPublisher publisher = client.getCustomerGatewayAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsPublisher publisher = client.getCustomerGatewayAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomerGatewayAssociationsPublisher getCustomerGatewayAssociationsPaginator(
            GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the association information for customer gateways that are associated with devices and links in your global
     * network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsPublisher publisher = client.getCustomerGatewayAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsPublisher publisher = client.getCustomerGatewayAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCustomerGatewayAssociations(software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomerGatewayAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomerGatewayAssociationsRequest#builder()}
     * </p>
     *
     * @param getCustomerGatewayAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomerGatewayAssociationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetCustomerGatewayAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetCustomerGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomerGatewayAssociationsPublisher getCustomerGatewayAssociationsPaginator(
            Consumer<GetCustomerGatewayAssociationsRequest.Builder> getCustomerGatewayAssociationsRequest) {
        return getCustomerGatewayAssociationsPaginator(GetCustomerGatewayAssociationsRequest.builder()
                .applyMutation(getCustomerGatewayAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     *
     * @param getDevicesRequest
     * @return A Java Future containing the result of the GetDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevicesResponse> getDevices(GetDevicesRequest getDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevicesRequest#builder()}
     * </p>
     *
     * @param getDevicesRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevicesResponse> getDevices(Consumer<GetDevicesRequest.Builder> getDevicesRequest) {
        return getDevices(GetDevicesRequest.builder().applyMutation(getDevicesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesPublisher publisher = client.getDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesPublisher publisher = client.getDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)} operation.</b>
     * </p>
     *
     * @param getDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicesPublisher getDevicesPaginator(GetDevicesRequest getDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your devices in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesPublisher publisher = client.getDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetDevicesPublisher publisher = client.getDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevices(software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevicesRequest#builder()}
     * </p>
     *
     * @param getDevicesRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicesPublisher getDevicesPaginator(Consumer<GetDevicesRequest.Builder> getDevicesRequest) {
        return getDevicesPaginator(GetDevicesRequest.builder().applyMutation(getDevicesRequest).build());
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     *
     * @param getLinkAssociationsRequest
     * @return A Java Future containing the result of the GetLinkAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkAssociationsResponse> getLinkAssociations(
            GetLinkAssociationsRequest getLinkAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetLinkAssociationsRequest#builder()}
     * </p>
     *
     * @param getLinkAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetLinkAssociationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLinkAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkAssociationsResponse> getLinkAssociations(
            Consumer<GetLinkAssociationsRequest.Builder> getLinkAssociationsRequest) {
        return getLinkAssociations(GetLinkAssociationsRequest.builder().applyMutation(getLinkAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsPublisher publisher = client.getLinkAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsPublisher publisher = client.getLinkAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getLinkAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkAssociationsPublisher getLinkAssociationsPaginator(GetLinkAssociationsRequest getLinkAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsPublisher publisher = client.getLinkAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsPublisher publisher = client.getLinkAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinkAssociations(software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetLinkAssociationsRequest#builder()}
     * </p>
     *
     * @param getLinkAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetLinkAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinkAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkAssociationsPublisher getLinkAssociationsPaginator(
            Consumer<GetLinkAssociationsRequest.Builder> getLinkAssociationsRequest) {
        return getLinkAssociationsPaginator(GetLinkAssociationsRequest.builder().applyMutation(getLinkAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     *
     * @param getLinksRequest
     * @return A Java Future containing the result of the GetLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLinksResponse> getLinks(GetLinksRequest getLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetLinksRequest#builder()}
     * </p>
     *
     * @param getLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetLinksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLinksResponse> getLinks(Consumer<GetLinksRequest.Builder> getLinksRequest) {
        return getLinks(GetLinksRequest.builder().applyMutation(getLinksRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksPublisher publisher = client.getLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksPublisher publisher = client.getLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)} operation.</b>
     * </p>
     *
     * @param getLinksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinksPublisher getLinksPaginator(GetLinksRequest getLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more links in a specified global network.
     * </p>
     * <p>
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type
     * and provider in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksPublisher publisher = client.getLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetLinksPublisher publisher = client.getLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLinks(software.amazon.awssdk.services.networkmanager.model.GetLinksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetLinksRequest#builder()}
     * </p>
     *
     * @param getLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetLinksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinksPublisher getLinksPaginator(Consumer<GetLinksRequest.Builder> getLinksRequest) {
        return getLinksPaginator(GetLinksRequest.builder().applyMutation(getLinksRequest).build());
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     * @return A Java Future containing the result of the GetNetworkResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourceCountsResponse> getNetworkResourceCounts(
            GetNetworkResourceCountsRequest getNetworkResourceCountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceCountsRequest.Builder} avoiding
     * the need to create one manually via {@link GetNetworkResourceCountsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceCountsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNetworkResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourceCountsResponse> getNetworkResourceCounts(
            Consumer<GetNetworkResourceCountsRequest.Builder> getNetworkResourceCountsRequest) {
        return getNetworkResourceCounts(GetNetworkResourceCountsRequest.builder().applyMutation(getNetworkResourceCountsRequest)
                .build());
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsPublisher publisher = client.getNetworkResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsPublisher publisher = client.getNetworkResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceCountsPublisher getNetworkResourceCountsPaginator(
            GetNetworkResourceCountsRequest getNetworkResourceCountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the count of network resources, by resource type, for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsPublisher publisher = client.getNetworkResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceCountsPublisher publisher = client.getNetworkResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceCounts(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceCountsRequest.Builder} avoiding
     * the need to create one manually via {@link GetNetworkResourceCountsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceCountsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceCountsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceCountsPublisher getNetworkResourceCountsPaginator(
            Consumer<GetNetworkResourceCountsRequest.Builder> getNetworkResourceCountsRequest) {
        return getNetworkResourceCountsPaginator(GetNetworkResourceCountsRequest.builder()
                .applyMutation(getNetworkResourceCountsRequest).build());
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     * @return A Java Future containing the result of the GetNetworkResourceRelationships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourceRelationshipsResponse> getNetworkResourceRelationships(
            GetNetworkResourceRelationshipsRequest getNetworkResourceRelationshipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceRelationshipsRequest.Builder}
     * avoiding the need to create one manually via {@link GetNetworkResourceRelationshipsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceRelationshipsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetNetworkResourceRelationships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourceRelationshipsResponse> getNetworkResourceRelationships(
            Consumer<GetNetworkResourceRelationshipsRequest.Builder> getNetworkResourceRelationshipsRequest) {
        return getNetworkResourceRelationships(GetNetworkResourceRelationshipsRequest.builder()
                .applyMutation(getNetworkResourceRelationshipsRequest).build());
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsPublisher publisher = client.getNetworkResourceRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsPublisher publisher = client.getNetworkResourceRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceRelationshipsPublisher getNetworkResourceRelationshipsPaginator(
            GetNetworkResourceRelationshipsRequest getNetworkResourceRelationshipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network resource relationships for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsPublisher publisher = client.getNetworkResourceRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourceRelationshipsPublisher publisher = client.getNetworkResourceRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResourceRelationships(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceRelationshipsRequest.Builder}
     * avoiding the need to create one manually via {@link GetNetworkResourceRelationshipsRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceRelationshipsRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceRelationshipsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResourceRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResourceRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceRelationshipsPublisher getNetworkResourceRelationshipsPaginator(
            Consumer<GetNetworkResourceRelationshipsRequest.Builder> getNetworkResourceRelationshipsRequest) {
        return getNetworkResourceRelationshipsPaginator(GetNetworkResourceRelationshipsRequest.builder()
                .applyMutation(getNetworkResourceRelationshipsRequest).build());
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     *
     * @param getNetworkResourcesRequest
     * @return A Java Future containing the result of the GetNetworkResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourcesResponse> getNetworkResources(
            GetNetworkResourcesRequest getNetworkResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param getNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNetworkResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourcesResponse> getNetworkResources(
            Consumer<GetNetworkResourcesRequest.Builder> getNetworkResourcesRequest) {
        return getNetworkResources(GetNetworkResourcesRequest.builder().applyMutation(getNetworkResourcesRequest).build());
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesPublisher publisher = client.getNetworkResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesPublisher publisher = client.getNetworkResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourcesPublisher getNetworkResourcesPaginator(GetNetworkResourcesRequest getNetworkResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the network resources for the specified global network.
     * </p>
     * <p>
     * The results include information from the corresponding Describe call for the resource, minus any sensitive
     * information such as pre-shared keys.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesPublisher publisher = client.getNetworkResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkResourcesPublisher publisher = client.getNetworkResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkResources(software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param getNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourcesPublisher getNetworkResourcesPaginator(
            Consumer<GetNetworkResourcesRequest.Builder> getNetworkResourcesRequest) {
        return getNetworkResourcesPaginator(GetNetworkResourcesRequest.builder().applyMutation(getNetworkResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the network routes of the specified global network.
     * </p>
     *
     * @param getNetworkRoutesRequest
     * @return A Java Future containing the result of the GetNetworkRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkRoutes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkRoutesResponse> getNetworkRoutes(GetNetworkRoutesRequest getNetworkRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network routes of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkRoutesRequest.Builder} avoiding the need
     * to create one manually via {@link GetNetworkRoutesRequest#builder()}
     * </p>
     *
     * @param getNetworkRoutesRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkRoutesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNetworkRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkRoutes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkRoutesResponse> getNetworkRoutes(
            Consumer<GetNetworkRoutesRequest.Builder> getNetworkRoutesRequest) {
        return getNetworkRoutes(GetNetworkRoutesRequest.builder().applyMutation(getNetworkRoutesRequest).build());
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     *
     * @param getNetworkTelemetryRequest
     * @return A Java Future containing the result of the GetNetworkTelemetry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkTelemetryResponse> getNetworkTelemetry(
            GetNetworkTelemetryRequest getNetworkTelemetryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkTelemetryRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkTelemetryRequest#builder()}
     * </p>
     *
     * @param getNetworkTelemetryRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkTelemetryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNetworkTelemetry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkTelemetryResponse> getNetworkTelemetry(
            Consumer<GetNetworkTelemetryRequest.Builder> getNetworkTelemetryRequest) {
        return getNetworkTelemetry(GetNetworkTelemetryRequest.builder().applyMutation(getNetworkTelemetryRequest).build());
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryPublisher publisher = client.getNetworkTelemetryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryPublisher publisher = client.getNetworkTelemetryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getNetworkTelemetryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkTelemetryPublisher getNetworkTelemetryPaginator(GetNetworkTelemetryRequest getNetworkTelemetryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network telemetry of the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryPublisher publisher = client.getNetworkTelemetryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetNetworkTelemetryPublisher publisher = client.getNetworkTelemetryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getNetworkTelemetry(software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkTelemetryRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkTelemetryRequest#builder()}
     * </p>
     *
     * @param getNetworkTelemetryRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkTelemetryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetNetworkTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetNetworkTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkTelemetryPublisher getNetworkTelemetryPaginator(
            Consumer<GetNetworkTelemetryRequest.Builder> getNetworkTelemetryRequest) {
        return getNetworkTelemetryPaginator(GetNetworkTelemetryRequest.builder().applyMutation(getNetworkTelemetryRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified route analysis.
     * </p>
     *
     * @param getRouteAnalysisRequest
     * @return A Java Future containing the result of the GetRouteAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouteAnalysisResponse> getRouteAnalysis(GetRouteAnalysisRequest getRouteAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified route analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteAnalysisRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouteAnalysisRequest#builder()}
     * </p>
     *
     * @param getRouteAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link GetRouteAnalysisRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRouteAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouteAnalysisResponse> getRouteAnalysis(
            Consumer<GetRouteAnalysisRequest.Builder> getRouteAnalysisRequest) {
        return getRouteAnalysis(GetRouteAnalysisRequest.builder().applyMutation(getRouteAnalysisRequest).build());
    }

    /**
     * <p>
     * Returns information about a site-to-site VPN attachment.
     * </p>
     *
     * @param getSiteToSiteVpnAttachmentRequest
     * @return A Java Future containing the result of the GetSiteToSiteVpnAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSiteToSiteVpnAttachmentResponse> getSiteToSiteVpnAttachment(
            GetSiteToSiteVpnAttachmentRequest getSiteToSiteVpnAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a site-to-site VPN attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteToSiteVpnAttachmentRequest.Builder} avoiding
     * the need to create one manually via {@link GetSiteToSiteVpnAttachmentRequest#builder()}
     * </p>
     *
     * @param getSiteToSiteVpnAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetSiteToSiteVpnAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSiteToSiteVpnAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetSiteToSiteVpnAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSiteToSiteVpnAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSiteToSiteVpnAttachmentResponse> getSiteToSiteVpnAttachment(
            Consumer<GetSiteToSiteVpnAttachmentRequest.Builder> getSiteToSiteVpnAttachmentRequest) {
        return getSiteToSiteVpnAttachment(GetSiteToSiteVpnAttachmentRequest.builder()
                .applyMutation(getSiteToSiteVpnAttachmentRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     *
     * @param getSitesRequest
     * @return A Java Future containing the result of the GetSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSitesResponse> getSites(GetSitesRequest getSitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSitesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSitesRequest#builder()}
     * </p>
     *
     * @param getSitesRequest
     *        A {@link Consumer} that will call methods on {@link GetSitesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSitesResponse> getSites(Consumer<GetSitesRequest.Builder> getSitesRequest) {
        return getSites(GetSitesRequest.builder().applyMutation(getSitesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesPublisher publisher = client.getSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesPublisher publisher = client.getSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)} operation.</b>
     * </p>
     *
     * @param getSitesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSitesPublisher getSitesPaginator(GetSitesRequest getSitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your sites in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesPublisher publisher = client.getSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetSitesPublisher publisher = client.getSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSites(software.amazon.awssdk.services.networkmanager.model.GetSitesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSitesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSitesRequest#builder()}
     * </p>
     *
     * @param getSitesRequest
     *        A {@link Consumer} that will call methods on {@link GetSitesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetSites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSitesPublisher getSitesPaginator(Consumer<GetSitesRequest.Builder> getSitesRequest) {
        return getSitesPaginator(GetSitesRequest.builder().applyMutation(getSitesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     * @return A Java Future containing the result of the GetTransitGatewayConnectPeerAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayConnectPeerAssociationsResponse> getTransitGatewayConnectPeerAssociations(
            GetTransitGatewayConnectPeerAssociationsRequest getTransitGatewayConnectPeerAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetTransitGatewayConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTransitGatewayConnectPeerAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayConnectPeerAssociationsResponse> getTransitGatewayConnectPeerAssociations(
            Consumer<GetTransitGatewayConnectPeerAssociationsRequest.Builder> getTransitGatewayConnectPeerAssociationsRequest) {
        return getTransitGatewayConnectPeerAssociations(GetTransitGatewayConnectPeerAssociationsRequest.builder()
                .applyMutation(getTransitGatewayConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsPublisher publisher = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsPublisher publisher = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayConnectPeerAssociationsPublisher getTransitGatewayConnectPeerAssociationsPaginator(
            GetTransitGatewayConnectPeerAssociationsRequest getTransitGatewayConnectPeerAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsPublisher publisher = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayConnectPeerAssociationsPublisher publisher = client.getTransitGatewayConnectPeerAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayConnectPeerAssociations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetTransitGatewayConnectPeerAssociationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayConnectPeerAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetTransitGatewayConnectPeerAssociationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayConnectPeerAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayConnectPeerAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayConnectPeerAssociationsPublisher getTransitGatewayConnectPeerAssociationsPaginator(
            Consumer<GetTransitGatewayConnectPeerAssociationsRequest.Builder> getTransitGatewayConnectPeerAssociationsRequest) {
        return getTransitGatewayConnectPeerAssociationsPaginator(GetTransitGatewayConnectPeerAssociationsRequest.builder()
                .applyMutation(getTransitGatewayConnectPeerAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns information about a transit gateway peer.
     * </p>
     *
     * @param getTransitGatewayPeeringRequest
     * @return A Java Future containing the result of the GetTransitGatewayPeering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayPeeringResponse> getTransitGatewayPeering(
            GetTransitGatewayPeeringRequest getTransitGatewayPeeringRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transit gateway peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransitGatewayPeeringRequest.Builder} avoiding
     * the need to create one manually via {@link GetTransitGatewayPeeringRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayPeeringRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayPeeringRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTransitGatewayPeering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayPeering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayPeering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayPeeringResponse> getTransitGatewayPeering(
            Consumer<GetTransitGatewayPeeringRequest.Builder> getTransitGatewayPeeringRequest) {
        return getTransitGatewayPeering(GetTransitGatewayPeeringRequest.builder().applyMutation(getTransitGatewayPeeringRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     * @return A Java Future containing the result of the GetTransitGatewayRegistrations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayRegistrationsResponse> getTransitGatewayRegistrations(
            GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransitGatewayRegistrationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetTransitGatewayRegistrationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayRegistrationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTransitGatewayRegistrations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayRegistrationsResponse> getTransitGatewayRegistrations(
            Consumer<GetTransitGatewayRegistrationsRequest.Builder> getTransitGatewayRegistrationsRequest) {
        return getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest.builder()
                .applyMutation(getTransitGatewayRegistrationsRequest).build());
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsPublisher publisher = client.getTransitGatewayRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsPublisher publisher = client.getTransitGatewayRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRegistrationsPublisher getTransitGatewayRegistrationsPaginator(
            GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the transit gateway registrations in a specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsPublisher publisher = client.getTransitGatewayRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsPublisher publisher = client.getTransitGatewayRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTransitGatewayRegistrations(software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransitGatewayRegistrationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetTransitGatewayRegistrationsRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayRegistrationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTransitGatewayRegistrationsPublisher getTransitGatewayRegistrationsPaginator(
            Consumer<GetTransitGatewayRegistrationsRequest.Builder> getTransitGatewayRegistrationsRequest) {
        return getTransitGatewayRegistrationsPaginator(GetTransitGatewayRegistrationsRequest.builder()
                .applyMutation(getTransitGatewayRegistrationsRequest).build());
    }

    /**
     * <p>
     * Returns information about a transit gateway route table attachment.
     * </p>
     *
     * @param getTransitGatewayRouteTableAttachmentRequest
     * @return A Java Future containing the result of the GetTransitGatewayRouteTableAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayRouteTableAttachmentResponse> getTransitGatewayRouteTableAttachment(
            GetTransitGatewayRouteTableAttachmentRequest getTransitGatewayRouteTableAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transit gateway route table attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTransitGatewayRouteTableAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link GetTransitGatewayRouteTableAttachmentRequest#builder()}
     * </p>
     *
     * @param getTransitGatewayRouteTableAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetTransitGatewayRouteTableAttachmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetTransitGatewayRouteTableAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetTransitGatewayRouteTableAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayRouteTableAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransitGatewayRouteTableAttachmentResponse> getTransitGatewayRouteTableAttachment(
            Consumer<GetTransitGatewayRouteTableAttachmentRequest.Builder> getTransitGatewayRouteTableAttachmentRequest) {
        return getTransitGatewayRouteTableAttachment(GetTransitGatewayRouteTableAttachmentRequest.builder()
                .applyMutation(getTransitGatewayRouteTableAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns information about a VPC attachment.
     * </p>
     *
     * @param getVpcAttachmentRequest
     * @return A Java Future containing the result of the GetVpcAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVpcAttachmentResponse> getVpcAttachment(GetVpcAttachmentRequest getVpcAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a VPC attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link GetVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param getVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcAttachmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVpcAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.GetVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVpcAttachmentResponse> getVpcAttachment(
            Consumer<GetVpcAttachmentRequest.Builder> getVpcAttachmentRequest) {
        return getVpcAttachment(GetVpcAttachmentRequest.builder().applyMutation(getVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     *
     * @param listAttachmentsRequest
     * @return A Java Future containing the result of the ListAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttachmentsResponse> listAttachments(ListAttachmentsRequest listAttachmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttachmentsRequest#builder()}
     * </p>
     *
     * @param listAttachmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachmentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttachmentsResponse> listAttachments(
            Consumer<ListAttachmentsRequest.Builder> listAttachmentsRequest) {
        return listAttachments(ListAttachmentsRequest.builder().applyMutation(listAttachmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachmentsPublisher listAttachmentsPaginator(ListAttachmentsRequest listAttachmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network attachments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachments(software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttachmentsRequest#builder()}
     * </p>
     *
     * @param listAttachmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachmentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachmentsPublisher listAttachmentsPaginator(Consumer<ListAttachmentsRequest.Builder> listAttachmentsRequest) {
        return listAttachmentsPaginator(ListAttachmentsRequest.builder().applyMutation(listAttachmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     *
     * @param listConnectPeersRequest
     * @return A Java Future containing the result of the ListConnectPeers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectPeersResponse> listConnectPeers(ListConnectPeersRequest listConnectPeersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectPeersRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectPeersRequest#builder()}
     * </p>
     *
     * @param listConnectPeersRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectPeersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListConnectPeers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectPeersResponse> listConnectPeers(
            Consumer<ListConnectPeersRequest.Builder> listConnectPeersRequest) {
        return listConnectPeers(ListConnectPeersRequest.builder().applyMutation(listConnectPeersRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersPublisher publisher = client.listConnectPeersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersPublisher publisher = client.listConnectPeersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectPeersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectPeersPublisher listConnectPeersPaginator(ListConnectPeersRequest listConnectPeersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network Connect peers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersPublisher publisher = client.listConnectPeersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListConnectPeersPublisher publisher = client.listConnectPeersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectPeers(software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectPeersRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectPeersRequest#builder()}
     * </p>
     *
     * @param listConnectPeersRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectPeersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListConnectPeers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectPeersPublisher listConnectPeersPaginator(Consumer<ListConnectPeersRequest.Builder> listConnectPeersRequest) {
        return listConnectPeersPaginator(ListConnectPeersRequest.builder().applyMutation(listConnectPeersRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     * @return A Java Future containing the result of the ListCoreNetworkPolicyVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoreNetworkPolicyVersionsResponse> listCoreNetworkPolicyVersions(
            ListCoreNetworkPolicyVersionsRequest listCoreNetworkPolicyVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworkPolicyVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCoreNetworkPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworkPolicyVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCoreNetworkPolicyVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoreNetworkPolicyVersionsResponse> listCoreNetworkPolicyVersions(
            Consumer<ListCoreNetworkPolicyVersionsRequest.Builder> listCoreNetworkPolicyVersionsRequest) {
        return listCoreNetworkPolicyVersions(ListCoreNetworkPolicyVersionsRequest.builder()
                .applyMutation(listCoreNetworkPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsPublisher publisher = client.listCoreNetworkPolicyVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsPublisher publisher = client.listCoreNetworkPolicyVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworkPolicyVersionsPublisher listCoreNetworkPolicyVersionsPaginator(
            ListCoreNetworkPolicyVersionsRequest listCoreNetworkPolicyVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of core network policy versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsPublisher publisher = client.listCoreNetworkPolicyVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworkPolicyVersionsPublisher publisher = client.listCoreNetworkPolicyVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworkPolicyVersions(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworkPolicyVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCoreNetworkPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listCoreNetworkPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworkPolicyVersionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworkPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworkPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworkPolicyVersionsPublisher listCoreNetworkPolicyVersionsPaginator(
            Consumer<ListCoreNetworkPolicyVersionsRequest.Builder> listCoreNetworkPolicyVersionsRequest) {
        return listCoreNetworkPolicyVersionsPaginator(ListCoreNetworkPolicyVersionsRequest.builder()
                .applyMutation(listCoreNetworkPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     *
     * @param listCoreNetworksRequest
     * @return A Java Future containing the result of the ListCoreNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoreNetworksResponse> listCoreNetworks(ListCoreNetworksRequest listCoreNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListCoreNetworksRequest#builder()}
     * </p>
     *
     * @param listCoreNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCoreNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoreNetworksResponse> listCoreNetworks(
            Consumer<ListCoreNetworksRequest.Builder> listCoreNetworksRequest) {
        return listCoreNetworks(ListCoreNetworksRequest.builder().applyMutation(listCoreNetworksRequest).build());
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksPublisher publisher = client.listCoreNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksPublisher publisher = client.listCoreNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoreNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworksPublisher listCoreNetworksPaginator(ListCoreNetworksRequest listCoreNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of owned and shared core networks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksPublisher publisher = client.listCoreNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListCoreNetworksPublisher publisher = client.listCoreNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreNetworks(software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListCoreNetworksRequest#builder()}
     * </p>
     *
     * @param listCoreNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreNetworksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListCoreNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListCoreNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreNetworksPublisher listCoreNetworksPaginator(Consumer<ListCoreNetworksRequest.Builder> listCoreNetworksRequest) {
        return listCoreNetworksPaginator(ListCoreNetworksRequest.builder().applyMutation(listCoreNetworksRequest).build());
    }

    /**
     * <p>
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services
     * Organization.
     * </p>
     *
     * @param listOrganizationServiceAccessStatusRequest
     * @return A Java Future containing the result of the ListOrganizationServiceAccessStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListOrganizationServiceAccessStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListOrganizationServiceAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationServiceAccessStatusResponse> listOrganizationServiceAccessStatus(
            ListOrganizationServiceAccessStatusRequest listOrganizationServiceAccessStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services
     * Organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationServiceAccessStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationServiceAccessStatusRequest#builder()}
     * </p>
     *
     * @param listOrganizationServiceAccessStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationServiceAccessStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListOrganizationServiceAccessStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListOrganizationServiceAccessStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListOrganizationServiceAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationServiceAccessStatusResponse> listOrganizationServiceAccessStatus(
            Consumer<ListOrganizationServiceAccessStatusRequest.Builder> listOrganizationServiceAccessStatusRequest) {
        return listOrganizationServiceAccessStatus(ListOrganizationServiceAccessStatusRequest.builder()
                .applyMutation(listOrganizationServiceAccessStatusRequest).build());
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     *
     * @param listPeeringsRequest
     * @return A Java Future containing the result of the ListPeerings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPeeringsResponse> listPeerings(ListPeeringsRequest listPeeringsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPeeringsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPeeringsRequest#builder()}
     * </p>
     *
     * @param listPeeringsRequest
     *        A {@link Consumer} that will call methods on {@link ListPeeringsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPeerings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPeeringsResponse> listPeerings(Consumer<ListPeeringsRequest.Builder> listPeeringsRequest) {
        return listPeerings(ListPeeringsRequest.builder().applyMutation(listPeeringsRequest).build());
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsPublisher publisher = client.listPeeringsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsPublisher publisher = client.listPeeringsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation.</b>
     * </p>
     *
     * @param listPeeringsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPeeringsPublisher listPeeringsPaginator(ListPeeringsRequest listPeeringsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the peerings for a core network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsPublisher publisher = client.listPeeringsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkmanager.paginators.ListPeeringsPublisher publisher = client.listPeeringsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPeerings(software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPeeringsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPeeringsRequest#builder()}
     * </p>
     *
     * @param listPeeringsRequest
     *        A {@link Consumer} that will call methods on {@link ListPeeringsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListPeerings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListPeerings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPeeringsPublisher listPeeringsPaginator(Consumer<ListPeeringsRequest.Builder> listPeeringsRequest) {
        return listPeeringsPaginator(ListPeeringsRequest.builder().applyMutation(listPeeringsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the
     * differences between the LIVE policy and the submitted policy.
     * </p>
     *
     * @param putCoreNetworkPolicyRequest
     * @return A Java Future containing the result of the PutCoreNetworkPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CoreNetworkPolicyException Describes a core network policy exception.</li>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.PutCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutCoreNetworkPolicyResponse> putCoreNetworkPolicy(
            PutCoreNetworkPolicyRequest putCoreNetworkPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the
     * differences between the LIVE policy and the submitted policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCoreNetworkPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutCoreNetworkPolicyRequest#builder()}
     * </p>
     *
     * @param putCoreNetworkPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutCoreNetworkPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutCoreNetworkPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CoreNetworkPolicyException Describes a core network policy exception.</li>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.PutCoreNetworkPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutCoreNetworkPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutCoreNetworkPolicyResponse> putCoreNetworkPolicy(
            Consumer<PutCoreNetworkPolicyRequest.Builder> putCoreNetworkPolicyRequest) {
        return putCoreNetworkPolicy(PutCoreNetworkPolicyRequest.builder().applyMutation(putCoreNetworkPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource policy.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region,
     * but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a
     * transit gateway in more than one global network.
     * </p>
     *
     * @param registerTransitGatewayRequest
     * @return A Java Future containing the result of the RegisterTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.RegisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RegisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTransitGatewayResponse> registerTransitGateway(
            RegisterTransitGatewayRequest registerTransitGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region,
     * but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a
     * transit gateway in more than one global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTransitGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterTransitGatewayRequest#builder()}
     * </p>
     *
     * @param registerTransitGatewayRequest
     *        A {@link Consumer} that will call methods on {@link RegisterTransitGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.RegisterTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RegisterTransitGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTransitGatewayResponse> registerTransitGateway(
            Consumer<RegisterTransitGatewayRequest.Builder> registerTransitGatewayRequest) {
        return registerTransitGateway(RegisterTransitGatewayRequest.builder().applyMutation(registerTransitGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Rejects a core network attachment request.
     * </p>
     *
     * @param rejectAttachmentRequest
     * @return A Java Future containing the result of the RejectAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.RejectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RejectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectAttachmentResponse> rejectAttachment(RejectAttachmentRequest rejectAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a core network attachment request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link RejectAttachmentRequest#builder()}
     * </p>
     *
     * @param rejectAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link RejectAttachmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RejectAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.RejectAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RejectAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectAttachmentResponse> rejectAttachment(
            Consumer<RejectAttachmentRequest.Builder> rejectAttachmentRequest) {
        return rejectAttachment(RejectAttachmentRequest.builder().applyMutation(rejectAttachmentRequest).build());
    }

    /**
     * <p>
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set
     * is created showing the differences between the LIVE policy and restored policy.
     * </p>
     *
     * @param restoreCoreNetworkPolicyVersionRequest
     * @return A Java Future containing the result of the RestoreCoreNetworkPolicyVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.RestoreCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RestoreCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreCoreNetworkPolicyVersionResponse> restoreCoreNetworkPolicyVersion(
            RestoreCoreNetworkPolicyVersionRequest restoreCoreNetworkPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set
     * is created showing the differences between the LIVE policy and restored policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreCoreNetworkPolicyVersionRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreCoreNetworkPolicyVersionRequest#builder()}
     * </p>
     *
     * @param restoreCoreNetworkPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link RestoreCoreNetworkPolicyVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreCoreNetworkPolicyVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.RestoreCoreNetworkPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RestoreCoreNetworkPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreCoreNetworkPolicyVersionResponse> restoreCoreNetworkPolicyVersion(
            Consumer<RestoreCoreNetworkPolicyVersionRequest.Builder> restoreCoreNetworkPolicyVersionRequest) {
        return restoreCoreNetworkPolicyVersion(RestoreCoreNetworkPolicyVersionRequest.builder()
                .applyMutation(restoreCoreNetworkPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Enables the Network Manager service for an Amazon Web Services Organization. This can only be called by a
     * management account within the organization.
     * </p>
     *
     * @param startOrganizationServiceAccessUpdateRequest
     * @return A Java Future containing the result of the StartOrganizationServiceAccessUpdate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.StartOrganizationServiceAccessUpdate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartOrganizationServiceAccessUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartOrganizationServiceAccessUpdateResponse> startOrganizationServiceAccessUpdate(
            StartOrganizationServiceAccessUpdateRequest startOrganizationServiceAccessUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Network Manager service for an Amazon Web Services Organization. This can only be called by a
     * management account within the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartOrganizationServiceAccessUpdateRequest.Builder} avoiding the need to create one manually via
     * {@link StartOrganizationServiceAccessUpdateRequest#builder()}
     * </p>
     *
     * @param startOrganizationServiceAccessUpdateRequest
     *        A {@link Consumer} that will call methods on {@link StartOrganizationServiceAccessUpdateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartOrganizationServiceAccessUpdate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.StartOrganizationServiceAccessUpdate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartOrganizationServiceAccessUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartOrganizationServiceAccessUpdateResponse> startOrganizationServiceAccessUpdate(
            Consumer<StartOrganizationServiceAccessUpdateRequest.Builder> startOrganizationServiceAccessUpdateRequest) {
        return startOrganizationServiceAccessUpdate(StartOrganizationServiceAccessUpdateRequest.builder()
                .applyMutation(startOrganizationServiceAccessUpdateRequest).build());
    }

    /**
     * <p>
     * Starts analyzing the routing path between the specified source and destination. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.
     * </p>
     *
     * @param startRouteAnalysisRequest
     * @return A Java Future containing the result of the StartRouteAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.StartRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRouteAnalysisResponse> startRouteAnalysis(StartRouteAnalysisRequest startRouteAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts analyzing the routing path between the specified source and destination. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRouteAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link StartRouteAnalysisRequest#builder()}
     * </p>
     *
     * @param startRouteAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link StartRouteAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartRouteAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.StartRouteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/StartRouteAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRouteAnalysisResponse> startRouteAnalysis(
            Consumer<StartRouteAnalysisRequest.Builder> startRouteAnalysisRequest) {
        return startRouteAnalysis(StartRouteAnalysisRequest.builder().applyMutation(startRouteAnalysisRequest).build());
    }

    /**
     * <p>
     * Tags a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an
     * empty string.
     * </p>
     *
     * @param updateConnectionRequest
     * @return A Java Future containing the result of the UpdateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest updateConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an
     * empty string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectionRequest#builder()}
     * </p>
     *
     * @param updateConnectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionResponse> updateConnection(
            Consumer<UpdateConnectionRequest.Builder> updateConnectionRequest) {
        return updateConnection(UpdateConnectionRequest.builder().applyMutation(updateConnectionRequest).build());
    }

    /**
     * <p>
     * Updates the description of a core network.
     * </p>
     *
     * @param updateCoreNetworkRequest
     * @return A Java Future containing the result of the UpdateCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCoreNetworkResponse> updateCoreNetwork(UpdateCoreNetworkRequest updateCoreNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of a core network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCoreNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCoreNetworkRequest#builder()}
     * </p>
     *
     * @param updateCoreNetworkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCoreNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCoreNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateCoreNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateCoreNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCoreNetworkResponse> updateCoreNetwork(
            Consumer<UpdateCoreNetworkRequest.Builder> updateCoreNetworkRequest) {
        return updateCoreNetwork(UpdateCoreNetworkRequest.builder().applyMutation(updateCoreNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     *
     * @param updateDeviceRequest
     * @return A Java Future containing the result of the UpdateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceResponse> updateDevice(UpdateDeviceRequest updateDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDeviceRequest#builder()}
     * </p>
     *
     * @param updateDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceResponse> updateDevice(Consumer<UpdateDeviceRequest.Builder> updateDeviceRequest) {
        return updateDevice(UpdateDeviceRequest.builder().applyMutation(updateDeviceRequest).build());
    }

    /**
     * <p>
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     * </p>
     *
     * @param updateGlobalNetworkRequest
     * @return A Java Future containing the result of the UpdateGlobalNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalNetworkResponse> updateGlobalNetwork(
            UpdateGlobalNetworkRequest updateGlobalNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalNetworkRequest#builder()}
     * </p>
     *
     * @param updateGlobalNetworkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGlobalNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGlobalNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateGlobalNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateGlobalNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalNetworkResponse> updateGlobalNetwork(
            Consumer<UpdateGlobalNetworkRequest.Builder> updateGlobalNetworkRequest) {
        return updateGlobalNetwork(UpdateGlobalNetworkRequest.builder().applyMutation(updateGlobalNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     *
     * @param updateLinkRequest
     * @return A Java Future containing the result of the UpdateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLinkResponse> updateLink(UpdateLinkRequest updateLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLinkRequest#builder()}
     * </p>
     *
     * @param updateLinkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>ServiceQuotaExceededException A service limit was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLinkResponse> updateLink(Consumer<UpdateLinkRequest.Builder> updateLinkRequest) {
        return updateLink(UpdateLinkRequest.builder().applyMutation(updateLinkRequest).build());
    }

    /**
     * <p>
     * Updates the resource metadata for the specified global network.
     * </p>
     *
     * @param updateNetworkResourceMetadataRequest
     * @return A Java Future containing the result of the UpdateNetworkResourceMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateNetworkResourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateNetworkResourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkResourceMetadataResponse> updateNetworkResourceMetadata(
            UpdateNetworkResourceMetadataRequest updateNetworkResourceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resource metadata for the specified global network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkResourceMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNetworkResourceMetadataRequest#builder()}
     * </p>
     *
     * @param updateNetworkResourceMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkResourceMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateNetworkResourceMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateNetworkResourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateNetworkResourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkResourceMetadataResponse> updateNetworkResourceMetadata(
            Consumer<UpdateNetworkResourceMetadataRequest.Builder> updateNetworkResourceMetadataRequest) {
        return updateNetworkResourceMetadata(UpdateNetworkResourceMetadataRequest.builder()
                .applyMutation(updateNetworkResourceMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     *
     * @param updateSiteRequest
     * @return A Java Future containing the result of the UpdateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSiteResponse> updateSite(UpdateSiteRequest updateSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty
     * string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSiteRequest#builder()}
     * </p>
     *
     * @param updateSiteRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSiteResponse> updateSite(Consumer<UpdateSiteRequest.Builder> updateSiteRequest) {
        return updateSite(UpdateSiteRequest.builder().applyMutation(updateSiteRequest).build());
    }

    /**
     * <p>
     * Updates a VPC attachment.
     * </p>
     *
     * @param updateVpcAttachmentRequest
     * @return A Java Future containing the result of the UpdateVpcAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVpcAttachmentResponse> updateVpcAttachment(
            UpdateVpcAttachmentRequest updateVpcAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a VPC attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param updateVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVpcAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVpcAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Updating or deleting the resource can
     *         cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request has failed due to an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkManagerAsyncClient.UpdateVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVpcAttachmentResponse> updateVpcAttachment(
            Consumer<UpdateVpcAttachmentRequest.Builder> updateVpcAttachmentRequest) {
        return updateVpcAttachment(UpdateVpcAttachmentRequest.builder().applyMutation(updateVpcAttachmentRequest).build());
    }

    /**
     * Create a {@link NetworkManagerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkManagerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkManagerAsyncClient}.
     */
    static NetworkManagerAsyncClientBuilder builder() {
        return new DefaultNetworkManagerAsyncClientBuilder();
    }
}
