/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.FilterMapCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.RouteState;
import software.amazon.awssdk.services.networkmanager.model.RouteStateListCopier;
import software.amazon.awssdk.services.networkmanager.model.RouteTableIdentifier;
import software.amazon.awssdk.services.networkmanager.model.RouteType;
import software.amazon.awssdk.services.networkmanager.model.RouteTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkRoutesRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, GetNetworkRoutesRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::globalNetworkId)).setter(GetNetworkRoutesRequest.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()}).build();
    private static final SdkField<RouteTableIdentifier> ROUTE_TABLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableIdentifier").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::routeTableIdentifier)).setter(GetNetworkRoutesRequest.setter(Builder::routeTableIdentifier)).constructor(RouteTableIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableIdentifier").build()}).build();
    private static final SdkField<List<String>> EXACT_CIDR_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExactCidrMatches").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::exactCidrMatches)).setter(GetNetworkRoutesRequest.setter(Builder::exactCidrMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExactCidrMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LONGEST_PREFIX_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LongestPrefixMatches").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::longestPrefixMatches)).setter(GetNetworkRoutesRequest.setter(Builder::longestPrefixMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongestPrefixMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_OF_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetOfMatches").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::subnetOfMatches)).setter(GetNetworkRoutesRequest.setter(Builder::subnetOfMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetOfMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPERNET_OF_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupernetOfMatches").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::supernetOfMatches)).setter(GetNetworkRoutesRequest.setter(Builder::supernetOfMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupernetOfMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PREFIX_LIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrefixListIds").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::prefixListIds)).setter(GetNetworkRoutesRequest.setter(Builder::prefixListIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("States").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::statesAsStrings)).setter(GetNetworkRoutesRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("States").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::typesAsStrings)).setter(GetNetworkRoutesRequest.setter(Builder::typesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> DESTINATION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DestinationFilters").getter(GetNetworkRoutesRequest.getter(GetNetworkRoutesRequest::destinationFilters)).setter(GetNetworkRoutesRequest.setter(Builder::destinationFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationFilters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, ROUTE_TABLE_IDENTIFIER_FIELD, EXACT_CIDR_MATCHES_FIELD, LONGEST_PREFIX_MATCHES_FIELD, SUBNET_OF_MATCHES_FIELD, SUPERNET_OF_MATCHES_FIELD, PREFIX_LIST_IDS_FIELD, STATES_FIELD, TYPES_FIELD, DESTINATION_FILTERS_FIELD));
    private final String globalNetworkId;
    private final RouteTableIdentifier routeTableIdentifier;
    private final List<String> exactCidrMatches;
    private final List<String> longestPrefixMatches;
    private final List<String> subnetOfMatches;
    private final List<String> supernetOfMatches;
    private final List<String> prefixListIds;
    private final List<String> states;
    private final List<String> types;
    private final Map<String, List<String>> destinationFilters;

    private GetNetworkRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.routeTableIdentifier = builder.routeTableIdentifier;
        this.exactCidrMatches = builder.exactCidrMatches;
        this.longestPrefixMatches = builder.longestPrefixMatches;
        this.subnetOfMatches = builder.subnetOfMatches;
        this.supernetOfMatches = builder.supernetOfMatches;
        this.prefixListIds = builder.prefixListIds;
        this.states = builder.states;
        this.types = builder.types;
        this.destinationFilters = builder.destinationFilters;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final RouteTableIdentifier routeTableIdentifier() {
        return this.routeTableIdentifier;
    }

    public final boolean hasExactCidrMatches() {
        return this.exactCidrMatches != null && !(this.exactCidrMatches instanceof SdkAutoConstructList);
    }

    public final List<String> exactCidrMatches() {
        return this.exactCidrMatches;
    }

    public final boolean hasLongestPrefixMatches() {
        return this.longestPrefixMatches != null && !(this.longestPrefixMatches instanceof SdkAutoConstructList);
    }

    public final List<String> longestPrefixMatches() {
        return this.longestPrefixMatches;
    }

    public final boolean hasSubnetOfMatches() {
        return this.subnetOfMatches != null && !(this.subnetOfMatches instanceof SdkAutoConstructList);
    }

    public final List<String> subnetOfMatches() {
        return this.subnetOfMatches;
    }

    public final boolean hasSupernetOfMatches() {
        return this.supernetOfMatches != null && !(this.supernetOfMatches instanceof SdkAutoConstructList);
    }

    public final List<String> supernetOfMatches() {
        return this.supernetOfMatches;
    }

    public final boolean hasPrefixListIds() {
        return this.prefixListIds != null && !(this.prefixListIds instanceof SdkAutoConstructList);
    }

    public final List<String> prefixListIds() {
        return this.prefixListIds;
    }

    public final List<RouteState> states() {
        return RouteStateListCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final List<RouteType> types() {
        return RouteTypeListCopier.copyStringToEnum(this.types);
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> typesAsStrings() {
        return this.types;
    }

    public final boolean hasDestinationFilters() {
        return this.destinationFilters != null && !(this.destinationFilters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> destinationFilters() {
        return this.destinationFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExactCidrMatches() ? this.exactCidrMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLongestPrefixMatches() ? this.longestPrefixMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetOfMatches() ? this.subnetOfMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupernetOfMatches() ? this.supernetOfMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixListIds() ? this.prefixListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.typesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationFilters() ? this.destinationFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkRoutesRequest)) {
            return false;
        }
        GetNetworkRoutesRequest other = (GetNetworkRoutesRequest)((Object)obj);
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.routeTableIdentifier(), other.routeTableIdentifier()) && this.hasExactCidrMatches() == other.hasExactCidrMatches() && Objects.equals(this.exactCidrMatches(), other.exactCidrMatches()) && this.hasLongestPrefixMatches() == other.hasLongestPrefixMatches() && Objects.equals(this.longestPrefixMatches(), other.longestPrefixMatches()) && this.hasSubnetOfMatches() == other.hasSubnetOfMatches() && Objects.equals(this.subnetOfMatches(), other.subnetOfMatches()) && this.hasSupernetOfMatches() == other.hasSupernetOfMatches() && Objects.equals(this.supernetOfMatches(), other.supernetOfMatches()) && this.hasPrefixListIds() == other.hasPrefixListIds() && Objects.equals(this.prefixListIds(), other.prefixListIds()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.typesAsStrings(), other.typesAsStrings()) && this.hasDestinationFilters() == other.hasDestinationFilters() && Objects.equals(this.destinationFilters(), other.destinationFilters());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkRoutesRequest").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("RouteTableIdentifier", (Object)this.routeTableIdentifier()).add("ExactCidrMatches", this.hasExactCidrMatches() ? this.exactCidrMatches() : null).add("LongestPrefixMatches", this.hasLongestPrefixMatches() ? this.longestPrefixMatches() : null).add("SubnetOfMatches", this.hasSubnetOfMatches() ? this.subnetOfMatches() : null).add("SupernetOfMatches", this.hasSupernetOfMatches() ? this.supernetOfMatches() : null).add("PrefixListIds", this.hasPrefixListIds() ? this.prefixListIds() : null).add("States", this.hasStates() ? this.statesAsStrings() : null).add("Types", this.hasTypes() ? this.typesAsStrings() : null).add("DestinationFilters", this.hasDestinationFilters() ? this.destinationFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "RouteTableIdentifier": {
                return Optional.ofNullable(clazz.cast(this.routeTableIdentifier()));
            }
            case "ExactCidrMatches": {
                return Optional.ofNullable(clazz.cast(this.exactCidrMatches()));
            }
            case "LongestPrefixMatches": {
                return Optional.ofNullable(clazz.cast(this.longestPrefixMatches()));
            }
            case "SubnetOfMatches": {
                return Optional.ofNullable(clazz.cast(this.subnetOfMatches()));
            }
            case "SupernetOfMatches": {
                return Optional.ofNullable(clazz.cast(this.supernetOfMatches()));
            }
            case "PrefixListIds": {
                return Optional.ofNullable(clazz.cast(this.prefixListIds()));
            }
            case "States": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
            case "DestinationFilters": {
                return Optional.ofNullable(clazz.cast(this.destinationFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkRoutesRequest, T> g) {
        return obj -> g.apply((GetNetworkRoutesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private RouteTableIdentifier routeTableIdentifier;
        private List<String> exactCidrMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> longestPrefixMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetOfMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> supernetOfMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> prefixListIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> destinationFilters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkRoutesRequest model) {
            super(model);
            this.globalNetworkId(model.globalNetworkId);
            this.routeTableIdentifier(model.routeTableIdentifier);
            this.exactCidrMatches(model.exactCidrMatches);
            this.longestPrefixMatches(model.longestPrefixMatches);
            this.subnetOfMatches(model.subnetOfMatches);
            this.supernetOfMatches(model.supernetOfMatches);
            this.prefixListIds(model.prefixListIds);
            this.statesWithStrings(model.states);
            this.typesWithStrings(model.types);
            this.destinationFilters(model.destinationFilters);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final RouteTableIdentifier.Builder getRouteTableIdentifier() {
            return this.routeTableIdentifier != null ? this.routeTableIdentifier.toBuilder() : null;
        }

        public final void setRouteTableIdentifier(RouteTableIdentifier.BuilderImpl routeTableIdentifier) {
            this.routeTableIdentifier = routeTableIdentifier != null ? routeTableIdentifier.build() : null;
        }

        @Override
        public final Builder routeTableIdentifier(RouteTableIdentifier routeTableIdentifier) {
            this.routeTableIdentifier = routeTableIdentifier;
            return this;
        }

        public final Collection<String> getExactCidrMatches() {
            if (this.exactCidrMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exactCidrMatches;
        }

        public final void setExactCidrMatches(Collection<String> exactCidrMatches) {
            this.exactCidrMatches = ConstrainedStringListCopier.copy(exactCidrMatches);
        }

        @Override
        public final Builder exactCidrMatches(Collection<String> exactCidrMatches) {
            this.exactCidrMatches = ConstrainedStringListCopier.copy(exactCidrMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exactCidrMatches(String ... exactCidrMatches) {
            this.exactCidrMatches(Arrays.asList(exactCidrMatches));
            return this;
        }

        public final Collection<String> getLongestPrefixMatches() {
            if (this.longestPrefixMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.longestPrefixMatches;
        }

        public final void setLongestPrefixMatches(Collection<String> longestPrefixMatches) {
            this.longestPrefixMatches = ConstrainedStringListCopier.copy(longestPrefixMatches);
        }

        @Override
        public final Builder longestPrefixMatches(Collection<String> longestPrefixMatches) {
            this.longestPrefixMatches = ConstrainedStringListCopier.copy(longestPrefixMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longestPrefixMatches(String ... longestPrefixMatches) {
            this.longestPrefixMatches(Arrays.asList(longestPrefixMatches));
            return this;
        }

        public final Collection<String> getSubnetOfMatches() {
            if (this.subnetOfMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetOfMatches;
        }

        public final void setSubnetOfMatches(Collection<String> subnetOfMatches) {
            this.subnetOfMatches = ConstrainedStringListCopier.copy(subnetOfMatches);
        }

        @Override
        public final Builder subnetOfMatches(Collection<String> subnetOfMatches) {
            this.subnetOfMatches = ConstrainedStringListCopier.copy(subnetOfMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetOfMatches(String ... subnetOfMatches) {
            this.subnetOfMatches(Arrays.asList(subnetOfMatches));
            return this;
        }

        public final Collection<String> getSupernetOfMatches() {
            if (this.supernetOfMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supernetOfMatches;
        }

        public final void setSupernetOfMatches(Collection<String> supernetOfMatches) {
            this.supernetOfMatches = ConstrainedStringListCopier.copy(supernetOfMatches);
        }

        @Override
        public final Builder supernetOfMatches(Collection<String> supernetOfMatches) {
            this.supernetOfMatches = ConstrainedStringListCopier.copy(supernetOfMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supernetOfMatches(String ... supernetOfMatches) {
            this.supernetOfMatches(Arrays.asList(supernetOfMatches));
            return this;
        }

        public final Collection<String> getPrefixListIds() {
            if (this.prefixListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.prefixListIds;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = ConstrainedStringListCopier.copy(prefixListIds);
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = ConstrainedStringListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        public final void setStates(Collection<String> states) {
            this.states = RouteStateListCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = RouteStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<RouteState> states) {
            this.states = RouteStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(RouteState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = RouteTypeListCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = RouteTypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<RouteType> types) {
            this.types = RouteTypeListCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(RouteType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getDestinationFilters() {
            if (this.destinationFilters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.destinationFilters;
        }

        public final void setDestinationFilters(Map<String, ? extends Collection<String>> destinationFilters) {
            this.destinationFilters = FilterMapCopier.copy(destinationFilters);
        }

        @Override
        public final Builder destinationFilters(Map<String, ? extends Collection<String>> destinationFilters) {
            this.destinationFilters = FilterMapCopier.copy(destinationFilters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNetworkRoutesRequest build() {
            return new GetNetworkRoutesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkRoutesRequest> {
        public Builder globalNetworkId(String var1);

        public Builder routeTableIdentifier(RouteTableIdentifier var1);

        default public Builder routeTableIdentifier(Consumer<RouteTableIdentifier.Builder> routeTableIdentifier) {
            return this.routeTableIdentifier((RouteTableIdentifier)((RouteTableIdentifier.Builder)RouteTableIdentifier.builder().applyMutation(routeTableIdentifier)).build());
        }

        public Builder exactCidrMatches(Collection<String> var1);

        public Builder exactCidrMatches(String ... var1);

        public Builder longestPrefixMatches(Collection<String> var1);

        public Builder longestPrefixMatches(String ... var1);

        public Builder subnetOfMatches(Collection<String> var1);

        public Builder subnetOfMatches(String ... var1);

        public Builder supernetOfMatches(Collection<String> var1);

        public Builder supernetOfMatches(String ... var1);

        public Builder prefixListIds(Collection<String> var1);

        public Builder prefixListIds(String ... var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<RouteState> var1);

        public Builder states(RouteState ... var1);

        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<RouteType> var1);

        public Builder types(RouteType ... var1);

        public Builder destinationFilters(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

