/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCoreNetworkResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<CreateCoreNetworkResponse.Builder, CreateCoreNetworkResponse> {
    private static final SdkField<CoreNetwork> CORE_NETWORK_FIELD = SdkField.<CoreNetwork> builder(MarshallingType.SDK_POJO)
            .memberName("CoreNetwork").getter(getter(CreateCoreNetworkResponse::coreNetwork))
            .setter(setter(Builder::coreNetwork)).constructor(CoreNetwork::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetwork").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_FIELD));

    private final CoreNetwork coreNetwork;

    private CreateCoreNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetwork = builder.coreNetwork;
    }

    /**
     * <p>
     * Returns details about a core network.
     * </p>
     * 
     * @return Returns details about a core network.
     */
    public final CoreNetwork coreNetwork() {
        return coreNetwork;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetwork());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoreNetworkResponse)) {
            return false;
        }
        CreateCoreNetworkResponse other = (CreateCoreNetworkResponse) obj;
        return Objects.equals(coreNetwork(), other.coreNetwork());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCoreNetworkResponse").add("CoreNetwork", coreNetwork()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetwork":
            return Optional.ofNullable(clazz.cast(coreNetwork()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCoreNetworkResponse, T> g) {
        return obj -> g.apply((CreateCoreNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCoreNetworkResponse> {
        /**
         * <p>
         * Returns details about a core network.
         * </p>
         * 
         * @param coreNetwork
         *        Returns details about a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetwork(CoreNetwork coreNetwork);

        /**
         * <p>
         * Returns details about a core network.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoreNetwork.Builder} avoiding the need to
         * create one manually via {@link CoreNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoreNetwork.Builder#build()} is called immediately and its result
         * is passed to {@link #coreNetwork(CoreNetwork)}.
         * 
         * @param coreNetwork
         *        a consumer that will call methods on {@link CoreNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetwork(CoreNetwork)
         */
        default Builder coreNetwork(Consumer<CoreNetwork.Builder> coreNetwork) {
            return coreNetwork(CoreNetwork.builder().applyMutation(coreNetwork).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private CoreNetwork coreNetwork;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCoreNetworkResponse model) {
            super(model);
            coreNetwork(model.coreNetwork);
        }

        public final CoreNetwork.Builder getCoreNetwork() {
            return coreNetwork != null ? coreNetwork.toBuilder() : null;
        }

        public final void setCoreNetwork(CoreNetwork.BuilderImpl coreNetwork) {
            this.coreNetwork = coreNetwork != null ? coreNetwork.build() : null;
        }

        @Override
        public final Builder coreNetwork(CoreNetwork coreNetwork) {
            this.coreNetwork = coreNetwork;
            return this;
        }

        @Override
        public CreateCoreNetworkResponse build() {
            return new CreateCoreNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
