/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationServiceAccessStatusResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<ListOrganizationServiceAccessStatusResponse.Builder, ListOrganizationServiceAccessStatusResponse> {
    private static final SdkField<OrganizationStatus> ORGANIZATION_STATUS_FIELD = SdkField
            .<OrganizationStatus> builder(MarshallingType.SDK_POJO).memberName("OrganizationStatus")
            .getter(getter(ListOrganizationServiceAccessStatusResponse::organizationStatus))
            .setter(setter(Builder::organizationStatus)).constructor(OrganizationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationStatus").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOrganizationServiceAccessStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_STATUS_FIELD,
            NEXT_TOKEN_FIELD));

    private final OrganizationStatus organizationStatus;

    private final String nextToken;

    private ListOrganizationServiceAccessStatusResponse(BuilderImpl builder) {
        super(builder);
        this.organizationStatus = builder.organizationStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Displays the status of an Amazon Web Services Organization.
     * </p>
     * 
     * @return Displays the status of an Amazon Web Services Organization.
     */
    public final OrganizationStatus organizationStatus() {
        return organizationStatus;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationServiceAccessStatusResponse)) {
            return false;
        }
        ListOrganizationServiceAccessStatusResponse other = (ListOrganizationServiceAccessStatusResponse) obj;
        return Objects.equals(organizationStatus(), other.organizationStatus()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOrganizationServiceAccessStatusResponse").add("OrganizationStatus", organizationStatus())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationStatus":
            return Optional.ofNullable(clazz.cast(organizationStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationServiceAccessStatusResponse, T> g) {
        return obj -> g.apply((ListOrganizationServiceAccessStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationServiceAccessStatusResponse> {
        /**
         * <p>
         * Displays the status of an Amazon Web Services Organization.
         * </p>
         * 
         * @param organizationStatus
         *        Displays the status of an Amazon Web Services Organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationStatus(OrganizationStatus organizationStatus);

        /**
         * <p>
         * Displays the status of an Amazon Web Services Organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationStatus.Builder} avoiding the
         * need to create one manually via {@link OrganizationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #organizationStatus(OrganizationStatus)}.
         * 
         * @param organizationStatus
         *        a consumer that will call methods on {@link OrganizationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationStatus(OrganizationStatus)
         */
        default Builder organizationStatus(Consumer<OrganizationStatus.Builder> organizationStatus) {
            return organizationStatus(OrganizationStatus.builder().applyMutation(organizationStatus).build());
        }

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private OrganizationStatus organizationStatus;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationServiceAccessStatusResponse model) {
            super(model);
            organizationStatus(model.organizationStatus);
            nextToken(model.nextToken);
        }

        public final OrganizationStatus.Builder getOrganizationStatus() {
            return organizationStatus != null ? organizationStatus.toBuilder() : null;
        }

        public final void setOrganizationStatus(OrganizationStatus.BuilderImpl organizationStatus) {
            this.organizationStatus = organizationStatus != null ? organizationStatus.build() : null;
        }

        @Override
        public final Builder organizationStatus(OrganizationStatus organizationStatus) {
            this.organizationStatus = organizationStatus;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationServiceAccessStatusResponse build() {
            return new ListOrganizationServiceAccessStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
