/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network BGP configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectPeerBgpConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectPeerBgpConfiguration.Builder, ConnectPeerBgpConfiguration> {
    private static final SdkField<Long> CORE_NETWORK_ASN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CoreNetworkAsn").getter(getter(ConnectPeerBgpConfiguration::coreNetworkAsn))
            .setter(setter(Builder::coreNetworkAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAsn").build()).build();

    private static final SdkField<Long> PEER_ASN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("PeerAsn")
            .getter(getter(ConnectPeerBgpConfiguration::peerAsn)).setter(setter(Builder::peerAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAsn").build()).build();

    private static final SdkField<String> CORE_NETWORK_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkAddress").getter(getter(ConnectPeerBgpConfiguration::coreNetworkAddress))
            .setter(setter(Builder::coreNetworkAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAddress").build())
            .build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress").getter(getter(ConnectPeerBgpConfiguration::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ASN_FIELD,
            PEER_ASN_FIELD, CORE_NETWORK_ADDRESS_FIELD, PEER_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long coreNetworkAsn;

    private final Long peerAsn;

    private final String coreNetworkAddress;

    private final String peerAddress;

    private ConnectPeerBgpConfiguration(BuilderImpl builder) {
        this.coreNetworkAsn = builder.coreNetworkAsn;
        this.peerAsn = builder.peerAsn;
        this.coreNetworkAddress = builder.coreNetworkAddress;
        this.peerAddress = builder.peerAddress;
    }

    /**
     * <p>
     * The ASN of the Coret Network.
     * </p>
     * 
     * @return The ASN of the Coret Network.
     */
    public final Long coreNetworkAsn() {
        return coreNetworkAsn;
    }

    /**
     * <p>
     * The ASN of the Connect peer.
     * </p>
     * 
     * @return The ASN of the Connect peer.
     */
    public final Long peerAsn() {
        return peerAsn;
    }

    /**
     * <p>
     * The address of a core network.
     * </p>
     * 
     * @return The address of a core network.
     */
    public final String coreNetworkAddress() {
        return coreNetworkAddress;
    }

    /**
     * <p>
     * The address of a core network Connect peer.
     * </p>
     * 
     * @return The address of a core network Connect peer.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerAsn());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerBgpConfiguration)) {
            return false;
        }
        ConnectPeerBgpConfiguration other = (ConnectPeerBgpConfiguration) obj;
        return Objects.equals(coreNetworkAsn(), other.coreNetworkAsn()) && Objects.equals(peerAsn(), other.peerAsn())
                && Objects.equals(coreNetworkAddress(), other.coreNetworkAddress())
                && Objects.equals(peerAddress(), other.peerAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectPeerBgpConfiguration").add("CoreNetworkAsn", coreNetworkAsn()).add("PeerAsn", peerAsn())
                .add("CoreNetworkAddress", coreNetworkAddress()).add("PeerAddress", peerAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkAsn":
            return Optional.ofNullable(clazz.cast(coreNetworkAsn()));
        case "PeerAsn":
            return Optional.ofNullable(clazz.cast(peerAsn()));
        case "CoreNetworkAddress":
            return Optional.ofNullable(clazz.cast(coreNetworkAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeerBgpConfiguration, T> g) {
        return obj -> g.apply((ConnectPeerBgpConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectPeerBgpConfiguration> {
        /**
         * <p>
         * The ASN of the Coret Network.
         * </p>
         * 
         * @param coreNetworkAsn
         *        The ASN of the Coret Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkAsn(Long coreNetworkAsn);

        /**
         * <p>
         * The ASN of the Connect peer.
         * </p>
         * 
         * @param peerAsn
         *        The ASN of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAsn(Long peerAsn);

        /**
         * <p>
         * The address of a core network.
         * </p>
         * 
         * @param coreNetworkAddress
         *        The address of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkAddress(String coreNetworkAddress);

        /**
         * <p>
         * The address of a core network Connect peer.
         * </p>
         * 
         * @param peerAddress
         *        The address of a core network Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);
    }

    static final class BuilderImpl implements Builder {
        private Long coreNetworkAsn;

        private Long peerAsn;

        private String coreNetworkAddress;

        private String peerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeerBgpConfiguration model) {
            coreNetworkAsn(model.coreNetworkAsn);
            peerAsn(model.peerAsn);
            coreNetworkAddress(model.coreNetworkAddress);
            peerAddress(model.peerAddress);
        }

        public final Long getCoreNetworkAsn() {
            return coreNetworkAsn;
        }

        public final void setCoreNetworkAsn(Long coreNetworkAsn) {
            this.coreNetworkAsn = coreNetworkAsn;
        }

        @Override
        public final Builder coreNetworkAsn(Long coreNetworkAsn) {
            this.coreNetworkAsn = coreNetworkAsn;
            return this;
        }

        public final Long getPeerAsn() {
            return peerAsn;
        }

        public final void setPeerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
        }

        @Override
        public final Builder peerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        public final String getCoreNetworkAddress() {
            return coreNetworkAddress;
        }

        public final void setCoreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
        }

        @Override
        public final Builder coreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        @Override
        public ConnectPeerBgpConfiguration build() {
            return new ConnectPeerBgpConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
