/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network Connect peer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectPeer implements SdkPojo, Serializable, ToCopyableBuilder<ConnectPeer.Builder, ConnectPeer> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(ConnectPeer::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> CONNECT_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectAttachmentId").getter(getter(ConnectPeer::connectAttachmentId))
            .setter(setter(Builder::connectAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectAttachmentId").build())
            .build();

    private static final SdkField<String> CONNECT_PEER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectPeerId").getter(getter(ConnectPeer::connectPeerId)).setter(setter(Builder::connectPeerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerId").build()).build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(ConnectPeer::edgeLocation)).setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ConnectPeer::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ConnectPeer::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<ConnectPeerConfiguration> CONFIGURATION_FIELD = SdkField
            .<ConnectPeerConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(ConnectPeer::configuration)).setter(setter(Builder::configuration))
            .constructor(ConnectPeerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ConnectPeer::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetArn").getter(getter(ConnectPeer::subnetArn)).setter(setter(Builder::subnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            CONNECT_ATTACHMENT_ID_FIELD, CONNECT_PEER_ID_FIELD, EDGE_LOCATION_FIELD, STATE_FIELD, CREATED_AT_FIELD,
            CONFIGURATION_FIELD, TAGS_FIELD, SUBNET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String coreNetworkId;

    private final String connectAttachmentId;

    private final String connectPeerId;

    private final String edgeLocation;

    private final String state;

    private final Instant createdAt;

    private final ConnectPeerConfiguration configuration;

    private final List<Tag> tags;

    private final String subnetArn;

    private ConnectPeer(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.connectAttachmentId = builder.connectAttachmentId;
        this.connectPeerId = builder.connectPeerId;
        this.edgeLocation = builder.edgeLocation;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.configuration = builder.configuration;
        this.tags = builder.tags;
        this.subnetArn = builder.subnetArn;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ID of the attachment to connect.
     * </p>
     * 
     * @return The ID of the attachment to connect.
     */
    public final String connectAttachmentId() {
        return connectAttachmentId;
    }

    /**
     * <p>
     * The ID of the Connect peer.
     * </p>
     * 
     * @return The ID of the Connect peer.
     */
    public final String connectPeerId() {
        return connectPeerId;
    }

    /**
     * <p>
     * The Connect peer Regions where edges are located.
     * </p>
     * 
     * @return The Connect peer Regions where edges are located.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The state of the Connect peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConnectPeerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Connect peer.
     * @see ConnectPeerState
     */
    public final ConnectPeerState state() {
        return ConnectPeerState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Connect peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConnectPeerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Connect peer.
     * @see ConnectPeerState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp when the Connect peer was created.
     * </p>
     * 
     * @return The timestamp when the Connect peer was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The configuration of the Connect peer.
     * </p>
     * 
     * @return The configuration of the Connect peer.
     */
    public final ConnectPeerConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key-value tags associated with the Connect peer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value tags associated with the Connect peer.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The subnet ARN for the Connect peer. This only applies only when the protocol is NO_ENCAP.
     * </p>
     * 
     * @return The subnet ARN for the Connect peer. This only applies only when the protocol is NO_ENCAP.
     */
    public final String subnetArn() {
        return subnetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(connectAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(connectPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeer)) {
            return false;
        }
        ConnectPeer other = (ConnectPeer) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(connectAttachmentId(), other.connectAttachmentId())
                && Objects.equals(connectPeerId(), other.connectPeerId()) && Objects.equals(edgeLocation(), other.edgeLocation())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(configuration(), other.configuration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(subnetArn(), other.subnetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectPeer").add("CoreNetworkId", coreNetworkId())
                .add("ConnectAttachmentId", connectAttachmentId()).add("ConnectPeerId", connectPeerId())
                .add("EdgeLocation", edgeLocation()).add("State", stateAsString()).add("CreatedAt", createdAt())
                .add("Configuration", configuration()).add("Tags", hasTags() ? tags() : null).add("SubnetArn", subnetArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "ConnectAttachmentId":
            return Optional.ofNullable(clazz.cast(connectAttachmentId()));
        case "ConnectPeerId":
            return Optional.ofNullable(clazz.cast(connectPeerId()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SubnetArn":
            return Optional.ofNullable(clazz.cast(subnetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeer, T> g) {
        return obj -> g.apply((ConnectPeer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectPeer> {
        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ID of the attachment to connect.
         * </p>
         * 
         * @param connectAttachmentId
         *        The ID of the attachment to connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectAttachmentId(String connectAttachmentId);

        /**
         * <p>
         * The ID of the Connect peer.
         * </p>
         * 
         * @param connectPeerId
         *        The ID of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectPeerId(String connectPeerId);

        /**
         * <p>
         * The Connect peer Regions where edges are located.
         * </p>
         * 
         * @param edgeLocation
         *        The Connect peer Regions where edges are located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The state of the Connect peer.
         * </p>
         * 
         * @param state
         *        The state of the Connect peer.
         * @see ConnectPeerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectPeerState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Connect peer.
         * </p>
         * 
         * @param state
         *        The state of the Connect peer.
         * @see ConnectPeerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectPeerState
         */
        Builder state(ConnectPeerState state);

        /**
         * <p>
         * The timestamp when the Connect peer was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the Connect peer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The configuration of the Connect peer.
         * </p>
         * 
         * @param configuration
         *        The configuration of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ConnectPeerConfiguration configuration);

        /**
         * <p>
         * The configuration of the Connect peer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectPeerConfiguration.Builder}
         * avoiding the need to create one manually via {@link ConnectPeerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectPeerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ConnectPeerConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ConnectPeerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ConnectPeerConfiguration)
         */
        default Builder configuration(Consumer<ConnectPeerConfiguration.Builder> configuration) {
            return configuration(ConnectPeerConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The list of key-value tags associated with the Connect peer.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of key-value tags associated with the Connect peer.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of key-value tags associated with the Connect peer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The subnet ARN for the Connect peer. This only applies only when the protocol is NO_ENCAP.
         * </p>
         * 
         * @param subnetArn
         *        The subnet ARN for the Connect peer. This only applies only when the protocol is NO_ENCAP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArn(String subnetArn);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkId;

        private String connectAttachmentId;

        private String connectPeerId;

        private String edgeLocation;

        private String state;

        private Instant createdAt;

        private ConnectPeerConfiguration configuration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String subnetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeer model) {
            coreNetworkId(model.coreNetworkId);
            connectAttachmentId(model.connectAttachmentId);
            connectPeerId(model.connectPeerId);
            edgeLocation(model.edgeLocation);
            state(model.state);
            createdAt(model.createdAt);
            configuration(model.configuration);
            tags(model.tags);
            subnetArn(model.subnetArn);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getConnectAttachmentId() {
            return connectAttachmentId;
        }

        public final void setConnectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
        }

        @Override
        public final Builder connectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        public final String getConnectPeerId() {
            return connectPeerId;
        }

        public final void setConnectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
        }

        @Override
        public final Builder connectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConnectPeerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ConnectPeerConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConnectPeerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConnectPeerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetArn() {
            return subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        @Override
        public ConnectPeer build() {
            return new ConnectPeer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
