/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkResourceRelationshipsRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<GetNetworkResourceRelationshipsRequest.Builder, GetNetworkResourceRelationshipsRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(GetNetworkResourceRelationshipsRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(GetNetworkResourceRelationshipsRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("coreNetworkId").build()).build();

    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredGatewayArn").getter(getter(GetNetworkResourceRelationshipsRequest::registeredGatewayArn))
            .setter(setter(Builder::registeredGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("registeredGatewayArn").build())
            .build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(GetNetworkResourceRelationshipsRequest::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsRegion").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(GetNetworkResourceRelationshipsRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accountId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GetNetworkResourceRelationshipsRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(GetNetworkResourceRelationshipsRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetNetworkResourceRelationshipsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetNetworkResourceRelationshipsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            CORE_NETWORK_ID_FIELD, REGISTERED_GATEWAY_ARN_FIELD, AWS_REGION_FIELD, ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD,
            RESOURCE_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String globalNetworkId;

    private final String coreNetworkId;

    private final String registeredGatewayArn;

    private final String awsRegion;

    private final String accountId;

    private final String resourceType;

    private final String resourceArn;

    private final Integer maxResults;

    private final String nextToken;

    private GetNetworkResourceRelationshipsRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.coreNetworkId = builder.coreNetworkId;
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.awsRegion = builder.awsRegion;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.resourceArn = builder.resourceArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ARN of the registered gateway.
     * </p>
     * 
     * @return The ARN of the registered gateway.
     */
    public final String registeredGatewayArn() {
        return registeredGatewayArn;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * The following are the supported resource types for Direct Connect:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>dxcon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dx-gateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dx-vif</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the supported resource types for Network Manager:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>attachment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connect-peer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>core-network</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>device</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>link</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>peering</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>site</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the supported resource types for Amazon VPC:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>customer-gateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-attachment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-connect-peer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-connection</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The resource type.</p>
     *         <p>
     *         The following are the supported resource types for Direct Connect:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>dxcon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dx-gateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dx-vif</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the supported resource types for Network Manager:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>attachment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connect-peer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>core-network</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>device</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>link</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>peering</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>site</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the supported resource types for Amazon VPC:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>customer-gateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-attachment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-connect-peer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-connection</code>
     *         </p>
     *         </li>
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ARN of the gateway.
     * </p>
     * 
     * @return The ARN of the gateway.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkResourceRelationshipsRequest)) {
            return false;
        }
        GetNetworkResourceRelationshipsRequest other = (GetNetworkResourceRelationshipsRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(registeredGatewayArn(), other.registeredGatewayArn())
                && Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkResourceRelationshipsRequest").add("GlobalNetworkId", globalNetworkId())
                .add("CoreNetworkId", coreNetworkId()).add("RegisteredGatewayArn", registeredGatewayArn())
                .add("AwsRegion", awsRegion()).add("AccountId", accountId()).add("ResourceType", resourceType())
                .add("ResourceArn", resourceArn()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "RegisteredGatewayArn":
            return Optional.ofNullable(clazz.cast(registeredGatewayArn()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkResourceRelationshipsRequest, T> g) {
        return obj -> g.apply((GetNetworkResourceRelationshipsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNetworkResourceRelationshipsRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ARN of the registered gateway.
         * </p>
         * 
         * @param registeredGatewayArn
         *        The ARN of the registered gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredGatewayArn(String registeredGatewayArn);

        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The resource type.
         * </p>
         * <p>
         * The following are the supported resource types for Direct Connect:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dxcon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dx-gateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dx-vif</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the supported resource types for Network Manager:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connect-peer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>core-network</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>device</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>link</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>peering</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>site</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the supported resource types for Amazon VPC:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-attachment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-connect-peer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type.</p>
         *        <p>
         *        The following are the supported resource types for Direct Connect:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dxcon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dx-gateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dx-vif</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the supported resource types for Network Manager:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connect-peer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>core-network</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>device</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>link</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>peering</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>site</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the supported resource types for Amazon VPC:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-attachment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-connect-peer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ARN of the gateway.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private String coreNetworkId;

        private String registeredGatewayArn;

        private String awsRegion;

        private String accountId;

        private String resourceType;

        private String resourceArn;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkResourceRelationshipsRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            coreNetworkId(model.coreNetworkId);
            registeredGatewayArn(model.registeredGatewayArn);
            awsRegion(model.awsRegion);
            accountId(model.accountId);
            resourceType(model.resourceType);
            resourceArn(model.resourceArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getRegisteredGatewayArn() {
            return registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNetworkResourceRelationshipsRequest build() {
            return new GetNetworkResourceRelationshipsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
