/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.ExternalRegionCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkSegment> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CoreNetworkSegment.getter(CoreNetworkSegment::name)).setter(CoreNetworkSegment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeLocations").getter(CoreNetworkSegment.getter(CoreNetworkSegment::edgeLocations)).setter(CoreNetworkSegment.setter(Builder::edgeLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SHARED_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SharedSegments").getter(CoreNetworkSegment.getter(CoreNetworkSegment::sharedSegments)).setter(CoreNetworkSegment.setter(Builder::sharedSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EDGE_LOCATIONS_FIELD, SHARED_SEGMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
            this.put("SharedSegments", SHARED_SEGMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> edgeLocations;
    private final List<String> sharedSegments;

    private CoreNetworkSegment(BuilderImpl builder) {
        this.name = builder.name;
        this.edgeLocations = builder.edgeLocations;
        this.sharedSegments = builder.sharedSegments;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasEdgeLocations() {
        return this.edgeLocations != null && !(this.edgeLocations instanceof SdkAutoConstructList);
    }

    public final List<String> edgeLocations() {
        return this.edgeLocations;
    }

    public final boolean hasSharedSegments() {
        return this.sharedSegments != null && !(this.sharedSegments instanceof SdkAutoConstructList);
    }

    public final List<String> sharedSegments() {
        return this.sharedSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeLocations() ? this.edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedSegments() ? this.sharedSegments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkSegment)) {
            return false;
        }
        CoreNetworkSegment other = (CoreNetworkSegment)obj;
        return Objects.equals(this.name(), other.name()) && this.hasEdgeLocations() == other.hasEdgeLocations() && Objects.equals(this.edgeLocations(), other.edgeLocations()) && this.hasSharedSegments() == other.hasSharedSegments() && Objects.equals(this.sharedSegments(), other.sharedSegments());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkSegment").add("Name", (Object)this.name()).add("EdgeLocations", this.hasEdgeLocations() ? this.edgeLocations() : null).add("SharedSegments", this.hasSharedSegments() ? this.sharedSegments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EdgeLocations": {
                return Optional.ofNullable(clazz.cast(this.edgeLocations()));
            }
            case "SharedSegments": {
                return Optional.ofNullable(clazz.cast(this.sharedSegments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkSegment, T> g) {
        return obj -> g.apply((CoreNetworkSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();
        private List<String> sharedSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkSegment model) {
            this.name(model.name);
            this.edgeLocations(model.edgeLocations);
            this.sharedSegments(model.sharedSegments);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (this.edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String ... edgeLocations) {
            this.edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final Collection<String> getSharedSegments() {
            if (this.sharedSegments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedSegments;
        }

        public final void setSharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
        }

        @Override
        public final Builder sharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedSegments(String ... sharedSegments) {
            this.sharedSegments(Arrays.asList(sharedSegments));
            return this;
        }

        public CoreNetworkSegment build() {
            return new CoreNetworkSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkSegment> {
        public Builder name(String var1);

        public Builder edgeLocations(Collection<String> var1);

        public Builder edgeLocations(String ... var1);

        public Builder sharedSegments(Collection<String> var1);

        public Builder sharedSegments(String ... var1);
    }
}

