/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectAttachmentRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<CreateConnectAttachmentRequest.Builder, CreateConnectAttachmentRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CreateConnectAttachmentRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(CreateConnectAttachmentRequest::edgeLocation))
            .setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<String> TRANSPORT_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransportAttachmentId").getter(getter(CreateConnectAttachmentRequest::transportAttachmentId))
            .setter(setter(Builder::transportAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportAttachmentId").build())
            .build();

    private static final SdkField<ConnectAttachmentOptions> OPTIONS_FIELD = SdkField
            .<ConnectAttachmentOptions> builder(MarshallingType.SDK_POJO).memberName("Options")
            .getter(getter(CreateConnectAttachmentRequest::options)).setter(setter(Builder::options))
            .constructor(ConnectAttachmentOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateConnectAttachmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateConnectAttachmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            EDGE_LOCATION_FIELD, TRANSPORT_ATTACHMENT_ID_FIELD, OPTIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String coreNetworkId;

    private final String edgeLocation;

    private final String transportAttachmentId;

    private final ConnectAttachmentOptions options;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateConnectAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.edgeLocation = builder.edgeLocation;
        this.transportAttachmentId = builder.transportAttachmentId;
        this.options = builder.options;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of a core network where you want to create the attachment.
     * </p>
     * 
     * @return The ID of a core network where you want to create the attachment.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The Region where the edge is located.
     * </p>
     * 
     * @return The Region where the edge is located.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The ID of the attachment between the two connections.
     * </p>
     * 
     * @return The ID of the attachment between the two connections.
     */
    public final String transportAttachmentId() {
        return transportAttachmentId;
    }

    /**
     * <p>
     * Options for creating an attachment.
     * </p>
     * 
     * @return Options for creating an attachment.
     */
    public final ConnectAttachmentOptions options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key-value tags associated with the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value tags associated with the request.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(transportAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectAttachmentRequest)) {
            return false;
        }
        CreateConnectAttachmentRequest other = (CreateConnectAttachmentRequest) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(edgeLocation(), other.edgeLocation())
                && Objects.equals(transportAttachmentId(), other.transportAttachmentId())
                && Objects.equals(options(), other.options()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectAttachmentRequest").add("CoreNetworkId", coreNetworkId())
                .add("EdgeLocation", edgeLocation()).add("TransportAttachmentId", transportAttachmentId())
                .add("Options", options()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "TransportAttachmentId":
            return Optional.ofNullable(clazz.cast(transportAttachmentId()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("EdgeLocation", EDGE_LOCATION_FIELD);
        map.put("TransportAttachmentId", TRANSPORT_ATTACHMENT_ID_FIELD);
        map.put("Options", OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectAttachmentRequest, T> g) {
        return obj -> g.apply((CreateConnectAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConnectAttachmentRequest> {
        /**
         * <p>
         * The ID of a core network where you want to create the attachment.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network where you want to create the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The Region where the edge is located.
         * </p>
         * 
         * @param edgeLocation
         *        The Region where the edge is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The ID of the attachment between the two connections.
         * </p>
         * 
         * @param transportAttachmentId
         *        The ID of the attachment between the two connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportAttachmentId(String transportAttachmentId);

        /**
         * <p>
         * Options for creating an attachment.
         * </p>
         * 
         * @param options
         *        Options for creating an attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(ConnectAttachmentOptions options);

        /**
         * <p>
         * Options for creating an attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectAttachmentOptions.Builder}
         * avoiding the need to create one manually via {@link ConnectAttachmentOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectAttachmentOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #options(ConnectAttachmentOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link ConnectAttachmentOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(ConnectAttachmentOptions)
         */
        default Builder options(Consumer<ConnectAttachmentOptions.Builder> options) {
            return options(ConnectAttachmentOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The list of key-value tags associated with the request.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of key-value tags associated with the request.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of key-value tags associated with the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String coreNetworkId;

        private String edgeLocation;

        private String transportAttachmentId;

        private ConnectAttachmentOptions options;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectAttachmentRequest model) {
            super(model);
            coreNetworkId(model.coreNetworkId);
            edgeLocation(model.edgeLocation);
            transportAttachmentId(model.transportAttachmentId);
            options(model.options);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getTransportAttachmentId() {
            return transportAttachmentId;
        }

        public final void setTransportAttachmentId(String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
        }

        @Override
        public final Builder transportAttachmentId(String transportAttachmentId) {
            this.transportAttachmentId = transportAttachmentId;
            return this;
        }

        public final ConnectAttachmentOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(ConnectAttachmentOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(ConnectAttachmentOptions options) {
            this.options = options;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectAttachmentRequest build() {
            return new CreateConnectAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
