/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomerGatewayAssociationsRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<GetCustomerGatewayAssociationsRequest.Builder, GetCustomerGatewayAssociationsRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(GetCustomerGatewayAssociationsRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<List<String>> CUSTOMER_GATEWAY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomerGatewayArns")
            .getter(getter(GetCustomerGatewayAssociationsRequest::customerGatewayArns))
            .setter(setter(Builder::customerGatewayArns))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("customerGatewayArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCustomerGatewayAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCustomerGatewayAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            CUSTOMER_GATEWAY_ARNS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalNetworkId;

    private final List<String> customerGatewayArns;

    private final Integer maxResults;

    private final String nextToken;

    private GetCustomerGatewayAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.customerGatewayArns = builder.customerGatewayArns;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerGatewayArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomerGatewayArns() {
        return customerGatewayArns != null && !(customerGatewayArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerGatewayArns} method.
     * </p>
     * 
     * @return One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.
     */
    public final List<String> customerGatewayArns() {
        return customerGatewayArns;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerGatewayArns() ? customerGatewayArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomerGatewayAssociationsRequest)) {
            return false;
        }
        GetCustomerGatewayAssociationsRequest other = (GetCustomerGatewayAssociationsRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && hasCustomerGatewayArns() == other.hasCustomerGatewayArns()
                && Objects.equals(customerGatewayArns(), other.customerGatewayArns())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomerGatewayAssociationsRequest").add("GlobalNetworkId", globalNetworkId())
                .add("CustomerGatewayArns", hasCustomerGatewayArns() ? customerGatewayArns() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "CustomerGatewayArns":
            return Optional.ofNullable(clazz.cast(customerGatewayArns()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("globalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("customerGatewayArns", CUSTOMER_GATEWAY_ARNS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCustomerGatewayAssociationsRequest, T> g) {
        return obj -> g.apply((GetCustomerGatewayAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCustomerGatewayAssociationsRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.
         * </p>
         * 
         * @param customerGatewayArns
         *        One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayArns(Collection<String> customerGatewayArns);

        /**
         * <p>
         * One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.
         * </p>
         * 
         * @param customerGatewayArns
         *        One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayArns(String... customerGatewayArns);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private List<String> customerGatewayArns = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomerGatewayAssociationsRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            customerGatewayArns(model.customerGatewayArns);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final Collection<String> getCustomerGatewayArns() {
            if (customerGatewayArns instanceof SdkAutoConstructList) {
                return null;
            }
            return customerGatewayArns;
        }

        public final void setCustomerGatewayArns(Collection<String> customerGatewayArns) {
            this.customerGatewayArns = CustomerGatewayArnListCopier.copy(customerGatewayArns);
        }

        @Override
        public final Builder customerGatewayArns(Collection<String> customerGatewayArns) {
            this.customerGatewayArns = CustomerGatewayArnListCopier.copy(customerGatewayArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayArns(String... customerGatewayArns) {
            customerGatewayArns(Arrays.asList(customerGatewayArns));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCustomerGatewayAssociationsRequest build() {
            return new GetCustomerGatewayAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
