/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransitGatewayRouteTableAttachmentResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetTransitGatewayRouteTableAttachmentResponse.Builder, GetTransitGatewayRouteTableAttachmentResponse> {
    private static final SdkField<TransitGatewayRouteTableAttachment> TRANSIT_GATEWAY_ROUTE_TABLE_ATTACHMENT_FIELD = SdkField
            .<TransitGatewayRouteTableAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayRouteTableAttachment")
            .getter(getter(GetTransitGatewayRouteTableAttachmentResponse::transitGatewayRouteTableAttachment))
            .setter(setter(Builder::transitGatewayRouteTableAttachment))
            .constructor(TransitGatewayRouteTableAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableAttachment")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_ROUTE_TABLE_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayRouteTableAttachment transitGatewayRouteTableAttachment;

    private GetTransitGatewayRouteTableAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTableAttachment = builder.transitGatewayRouteTableAttachment;
    }

    /**
     * <p>
     * Returns information about the transit gateway route table attachment.
     * </p>
     * 
     * @return Returns information about the transit gateway route table attachment.
     */
    public final TransitGatewayRouteTableAttachment transitGatewayRouteTableAttachment() {
        return transitGatewayRouteTableAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayRouteTableAttachmentResponse)) {
            return false;
        }
        GetTransitGatewayRouteTableAttachmentResponse other = (GetTransitGatewayRouteTableAttachmentResponse) obj;
        return Objects.equals(transitGatewayRouteTableAttachment(), other.transitGatewayRouteTableAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransitGatewayRouteTableAttachmentResponse")
                .add("TransitGatewayRouteTableAttachment", transitGatewayRouteTableAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableAttachment":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayRouteTableAttachment", TRANSIT_GATEWAY_ROUTE_TABLE_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayRouteTableAttachmentResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayRouteTableAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransitGatewayRouteTableAttachmentResponse> {
        /**
         * <p>
         * Returns information about the transit gateway route table attachment.
         * </p>
         * 
         * @param transitGatewayRouteTableAttachment
         *        Returns information about the transit gateway route table attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableAttachment(TransitGatewayRouteTableAttachment transitGatewayRouteTableAttachment);

        /**
         * <p>
         * Returns information about the transit gateway route table attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayRouteTableAttachment.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayRouteTableAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayRouteTableAttachment.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transitGatewayRouteTableAttachment(TransitGatewayRouteTableAttachment)}.
         * 
         * @param transitGatewayRouteTableAttachment
         *        a consumer that will call methods on {@link TransitGatewayRouteTableAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayRouteTableAttachment(TransitGatewayRouteTableAttachment)
         */
        default Builder transitGatewayRouteTableAttachment(
                Consumer<TransitGatewayRouteTableAttachment.Builder> transitGatewayRouteTableAttachment) {
            return transitGatewayRouteTableAttachment(TransitGatewayRouteTableAttachment.builder()
                    .applyMutation(transitGatewayRouteTableAttachment).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private TransitGatewayRouteTableAttachment transitGatewayRouteTableAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayRouteTableAttachmentResponse model) {
            super(model);
            transitGatewayRouteTableAttachment(model.transitGatewayRouteTableAttachment);
        }

        public final TransitGatewayRouteTableAttachment.Builder getTransitGatewayRouteTableAttachment() {
            return transitGatewayRouteTableAttachment != null ? transitGatewayRouteTableAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayRouteTableAttachment(
                TransitGatewayRouteTableAttachment.BuilderImpl transitGatewayRouteTableAttachment) {
            this.transitGatewayRouteTableAttachment = transitGatewayRouteTableAttachment != null ? transitGatewayRouteTableAttachment
                    .build() : null;
        }

        @Override
        public final Builder transitGatewayRouteTableAttachment(
                TransitGatewayRouteTableAttachment transitGatewayRouteTableAttachment) {
            this.transitGatewayRouteTableAttachment = transitGatewayRouteTableAttachment;
            return this;
        }

        @Override
        public GetTransitGatewayRouteTableAttachmentResponse build() {
            return new GetTransitGatewayRouteTableAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
