/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttachmentsRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<ListAttachmentsRequest.Builder, ListAttachmentsRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(ListAttachmentsRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("coreNetworkId").build()).build();

    private static final SdkField<String> ATTACHMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentType").getter(getter(ListAttachmentsRequest::attachmentTypeAsString))
            .setter(setter(Builder::attachmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("attachmentType").build())
            .build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(ListAttachmentsRequest::edgeLocation))
            .setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("edgeLocation").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListAttachmentsRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAttachmentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAttachmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            ATTACHMENT_TYPE_FIELD, EDGE_LOCATION_FIELD, STATE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String coreNetworkId;

    private final String attachmentType;

    private final String edgeLocation;

    private final String state;

    private final Integer maxResults;

    private final String nextToken;

    private ListAttachmentsRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.attachmentType = builder.attachmentType;
        this.edgeLocation = builder.edgeLocation;
        this.state = builder.state;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The type of attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentType}
     * will return {@link AttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attachmentTypeAsString}.
     * </p>
     * 
     * @return The type of attachment.
     * @see AttachmentType
     */
    public final AttachmentType attachmentType() {
        return AttachmentType.fromValue(attachmentType);
    }

    /**
     * <p>
     * The type of attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentType}
     * will return {@link AttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attachmentTypeAsString}.
     * </p>
     * 
     * @return The type of attachment.
     * @see AttachmentType
     */
    public final String attachmentTypeAsString() {
        return attachmentType;
    }

    /**
     * <p>
     * The Region where the edge is located.
     * </p>
     * 
     * @return The Region where the edge is located.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the attachment.
     * @see AttachmentState
     */
    public final AttachmentState state() {
        return AttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the attachment.
     * @see AttachmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachmentsRequest)) {
            return false;
        }
        ListAttachmentsRequest other = (ListAttachmentsRequest) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(attachmentTypeAsString(), other.attachmentTypeAsString())
                && Objects.equals(edgeLocation(), other.edgeLocation()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttachmentsRequest").add("CoreNetworkId", coreNetworkId())
                .add("AttachmentType", attachmentTypeAsString()).add("EdgeLocation", edgeLocation())
                .add("State", stateAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "AttachmentType":
            return Optional.ofNullable(clazz.cast(attachmentTypeAsString()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("attachmentType", ATTACHMENT_TYPE_FIELD);
        map.put("edgeLocation", EDGE_LOCATION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAttachmentsRequest, T> g) {
        return obj -> g.apply((ListAttachmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAttachmentsRequest> {
        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The type of attachment.
         * </p>
         * 
         * @param attachmentType
         *        The type of attachment.
         * @see AttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentType
         */
        Builder attachmentType(String attachmentType);

        /**
         * <p>
         * The type of attachment.
         * </p>
         * 
         * @param attachmentType
         *        The type of attachment.
         * @see AttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentType
         */
        Builder attachmentType(AttachmentType attachmentType);

        /**
         * <p>
         * The Region where the edge is located.
         * </p>
         * 
         * @param edgeLocation
         *        The Region where the edge is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The state of the attachment.
         * </p>
         * 
         * @param state
         *        The state of the attachment.
         * @see AttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the attachment.
         * </p>
         * 
         * @param state
         *        The state of the attachment.
         * @see AttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentState
         */
        Builder state(AttachmentState state);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String coreNetworkId;

        private String attachmentType;

        private String edgeLocation;

        private String state;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachmentsRequest model) {
            super(model);
            coreNetworkId(model.coreNetworkId);
            attachmentType(model.attachmentType);
            edgeLocation(model.edgeLocation);
            state(model.state);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getAttachmentType() {
            return attachmentType;
        }

        public final void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        @Override
        public final Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType(attachmentType == null ? null : attachmentType.toString());
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAttachmentsRequest build() {
            return new ListAttachmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
