/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoreNetworksResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<ListCoreNetworksResponse.Builder, ListCoreNetworksResponse> {
    private static final SdkField<List<CoreNetworkSummary>> CORE_NETWORKS_FIELD = SdkField
            .<List<CoreNetworkSummary>> builder(MarshallingType.LIST)
            .memberName("CoreNetworks")
            .getter(getter(ListCoreNetworksResponse::coreNetworks))
            .setter(setter(Builder::coreNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreNetworkSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreNetworkSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCoreNetworksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CoreNetworkSummary> coreNetworks;

    private final String nextToken;

    private ListCoreNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetworks = builder.coreNetworks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CoreNetworks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCoreNetworks() {
        return coreNetworks != null && !(coreNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the list of core networks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoreNetworks} method.
     * </p>
     * 
     * @return Describes the list of core networks.
     */
    public final List<CoreNetworkSummary> coreNetworks() {
        return coreNetworks;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCoreNetworks() ? coreNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreNetworksResponse)) {
            return false;
        }
        ListCoreNetworksResponse other = (ListCoreNetworksResponse) obj;
        return hasCoreNetworks() == other.hasCoreNetworks() && Objects.equals(coreNetworks(), other.coreNetworks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCoreNetworksResponse").add("CoreNetworks", hasCoreNetworks() ? coreNetworks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworks":
            return Optional.ofNullable(clazz.cast(coreNetworks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworks", CORE_NETWORKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCoreNetworksResponse, T> g) {
        return obj -> g.apply((ListCoreNetworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCoreNetworksResponse> {
        /**
         * <p>
         * Describes the list of core networks.
         * </p>
         * 
         * @param coreNetworks
         *        Describes the list of core networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworks(Collection<CoreNetworkSummary> coreNetworks);

        /**
         * <p>
         * Describes the list of core networks.
         * </p>
         * 
         * @param coreNetworks
         *        Describes the list of core networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworks(CoreNetworkSummary... coreNetworks);

        /**
         * <p>
         * Describes the list of core networks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #coreNetworks(List<CoreNetworkSummary>)}.
         * 
         * @param coreNetworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetworks(java.util.Collection<CoreNetworkSummary>)
         */
        Builder coreNetworks(Consumer<CoreNetworkSummary.Builder>... coreNetworks);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<CoreNetworkSummary> coreNetworks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreNetworksResponse model) {
            super(model);
            coreNetworks(model.coreNetworks);
            nextToken(model.nextToken);
        }

        public final List<CoreNetworkSummary.Builder> getCoreNetworks() {
            List<CoreNetworkSummary.Builder> result = CoreNetworkSummaryListCopier.copyToBuilder(this.coreNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoreNetworks(Collection<CoreNetworkSummary.BuilderImpl> coreNetworks) {
            this.coreNetworks = CoreNetworkSummaryListCopier.copyFromBuilder(coreNetworks);
        }

        @Override
        public final Builder coreNetworks(Collection<CoreNetworkSummary> coreNetworks) {
            this.coreNetworks = CoreNetworkSummaryListCopier.copy(coreNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworks(CoreNetworkSummary... coreNetworks) {
            coreNetworks(Arrays.asList(coreNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworks(Consumer<CoreNetworkSummary.Builder>... coreNetworks) {
            coreNetworks(Stream.of(coreNetworks).map(c -> CoreNetworkSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCoreNetworksResponse build() {
            return new ListCoreNetworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
