/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkResource implements SdkPojo, Serializable, ToCopyableBuilder<NetworkResource.Builder, NetworkResource> {
    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredGatewayArn").getter(getter(NetworkResource::registeredGatewayArn))
            .setter(setter(Builder::registeredGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredGatewayArn").build())
            .build();

    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(NetworkResource::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(NetworkResource::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(NetworkResource::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(NetworkResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(NetworkResource::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(NetworkResource::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Definition").getter(getter(NetworkResource::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<Instant> DEFINITION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DefinitionTimestamp").getter(getter(NetworkResource::definitionTimestamp))
            .setter(setter(Builder::definitionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionTimestamp").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(NetworkResource::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Metadata")
            .getter(getter(NetworkResource::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTERED_GATEWAY_ARN_FIELD,
            CORE_NETWORK_ID_FIELD, AWS_REGION_FIELD, ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD,
            RESOURCE_ARN_FIELD, DEFINITION_FIELD, DEFINITION_TIMESTAMP_FIELD, TAGS_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String registeredGatewayArn;

    private final String coreNetworkId;

    private final String awsRegion;

    private final String accountId;

    private final String resourceType;

    private final String resourceId;

    private final String resourceArn;

    private final String definition;

    private final Instant definitionTimestamp;

    private final List<Tag> tags;

    private final Map<String, String> metadata;

    private NetworkResource(BuilderImpl builder) {
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.coreNetworkId = builder.coreNetworkId;
        this.awsRegion = builder.awsRegion;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.definition = builder.definition;
        this.definitionTimestamp = builder.definitionTimestamp;
        this.tags = builder.tags;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The ARN of the gateway.
     * </p>
     * 
     * @return The ARN of the gateway.
     */
    public final String registeredGatewayArn() {
        return registeredGatewayArn;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * The following are the supported resource types for Direct Connect:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>dxcon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dx-gateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dx-vif</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the supported resource types for Network Manager:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>attachment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connect-peer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>core-network</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>device</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>link</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>peering</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>site</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the supported resource types for Amazon VPC:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>customer-gateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-attachment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-connect-peer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-connection</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The resource type.</p>
     *         <p>
     *         The following are the supported resource types for Direct Connect:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>dxcon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dx-gateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dx-vif</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the supported resource types for Network Manager:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>attachment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connect-peer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>core-network</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>device</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>link</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>peering</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>site</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the supported resource types for Amazon VPC:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>customer-gateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-attachment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-connect-peer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-connection</code>
     *         </p>
     *         </li>
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Information about the resource, in JSON format. Network Manager gets this information by describing the resource
     * using its Describe API call.
     * </p>
     * 
     * @return Information about the resource, in JSON format. Network Manager gets this information by describing the
     *         resource using its Describe API call.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The time that the resource definition was retrieved.
     * </p>
     * 
     * @return The time that the resource definition was retrieved.
     */
    public final Instant definitionTimestamp() {
        return definitionTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The resource metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The resource metadata.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(definitionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResource)) {
            return false;
        }
        NetworkResource other = (NetworkResource) obj;
        return Objects.equals(registeredGatewayArn(), other.registeredGatewayArn())
                && Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(definition(), other.definition())
                && Objects.equals(definitionTimestamp(), other.definitionTimestamp()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkResource").add("RegisteredGatewayArn", registeredGatewayArn())
                .add("CoreNetworkId", coreNetworkId()).add("AwsRegion", awsRegion()).add("AccountId", accountId())
                .add("ResourceType", resourceType()).add("ResourceId", resourceId()).add("ResourceArn", resourceArn())
                .add("Definition", definition()).add("DefinitionTimestamp", definitionTimestamp())
                .add("Tags", hasTags() ? tags() : null).add("Metadata", hasMetadata() ? metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegisteredGatewayArn":
            return Optional.ofNullable(clazz.cast(registeredGatewayArn()));
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "DefinitionTimestamp":
            return Optional.ofNullable(clazz.cast(definitionTimestamp()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegisteredGatewayArn", REGISTERED_GATEWAY_ARN_FIELD);
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("AwsRegion", AWS_REGION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("DefinitionTimestamp", DEFINITION_TIMESTAMP_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkResource, T> g) {
        return obj -> g.apply((NetworkResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkResource> {
        /**
         * <p>
         * The ARN of the gateway.
         * </p>
         * 
         * @param registeredGatewayArn
         *        The ARN of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredGatewayArn(String registeredGatewayArn);

        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The resource type.
         * </p>
         * <p>
         * The following are the supported resource types for Direct Connect:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dxcon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dx-gateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dx-vif</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the supported resource types for Network Manager:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connect-peer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>core-network</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>device</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>link</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>peering</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>site</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the supported resource types for Amazon VPC:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-attachment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-connect-peer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type.</p>
         *        <p>
         *        The following are the supported resource types for Direct Connect:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dxcon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dx-gateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dx-vif</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the supported resource types for Network Manager:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connect-peer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>core-network</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>device</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>link</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>peering</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>site</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the supported resource types for Amazon VPC:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-attachment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-connect-peer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Information about the resource, in JSON format. Network Manager gets this information by describing the
         * resource using its Describe API call.
         * </p>
         * 
         * @param definition
         *        Information about the resource, in JSON format. Network Manager gets this information by describing
         *        the resource using its Describe API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The time that the resource definition was retrieved.
         * </p>
         * 
         * @param definitionTimestamp
         *        The time that the resource definition was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionTimestamp(Instant definitionTimestamp);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The resource metadata.
         * </p>
         * 
         * @param metadata
         *        The resource metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);
    }

    static final class BuilderImpl implements Builder {
        private String registeredGatewayArn;

        private String coreNetworkId;

        private String awsRegion;

        private String accountId;

        private String resourceType;

        private String resourceId;

        private String resourceArn;

        private String definition;

        private Instant definitionTimestamp;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResource model) {
            registeredGatewayArn(model.registeredGatewayArn);
            coreNetworkId(model.coreNetworkId);
            awsRegion(model.awsRegion);
            accountId(model.accountId);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourceArn(model.resourceArn);
            definition(model.definition);
            definitionTimestamp(model.definitionTimestamp);
            tags(model.tags);
            metadata(model.metadata);
        }

        public final String getRegisteredGatewayArn() {
            return registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getDefinitionTimestamp() {
            return definitionTimestamp;
        }

        public final void setDefinitionTimestamp(Instant definitionTimestamp) {
            this.definitionTimestamp = definitionTimestamp;
        }

        @Override
        public final Builder definitionTimestamp(Instant definitionTimestamp) {
            this.definitionTimestamp = definitionTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = NetworkResourceMetadataMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = NetworkResourceMetadataMapCopier.copy(metadata);
            return this;
        }

        @Override
        public NetworkResource build() {
            return new NetworkResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
