/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a source or a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteAnalysisEndpointOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteAnalysisEndpointOptions.Builder, RouteAnalysisEndpointOptions> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentArn")
            .getter(getter(RouteAnalysisEndpointOptions::transitGatewayAttachmentArn))
            .setter(setter(Builder::transitGatewayAttachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentArn")
                    .build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayArn").getter(getter(RouteAnalysisEndpointOptions::transitGatewayArn))
            .setter(setter(Builder::transitGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayArn").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(RouteAnalysisEndpointOptions::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ARN_FIELD, TRANSIT_GATEWAY_ARN_FIELD, IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentArn;

    private final String transitGatewayArn;

    private final String ipAddress;

    private RouteAnalysisEndpointOptions(BuilderImpl builder) {
        this.transitGatewayAttachmentArn = builder.transitGatewayAttachmentArn;
        this.transitGatewayArn = builder.transitGatewayArn;
        this.ipAddress = builder.ipAddress;
    }

    /**
     * <p>
     * The ARN of the transit gateway attachment.
     * </p>
     * 
     * @return The ARN of the transit gateway attachment.
     */
    public final String transitGatewayAttachmentArn() {
        return transitGatewayAttachmentArn;
    }

    /**
     * <p>
     * The ARN of the transit gateway.
     * </p>
     * 
     * @return The ARN of the transit gateway.
     */
    public final String transitGatewayArn() {
        return transitGatewayArn;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisEndpointOptions)) {
            return false;
        }
        RouteAnalysisEndpointOptions other = (RouteAnalysisEndpointOptions) obj;
        return Objects.equals(transitGatewayAttachmentArn(), other.transitGatewayAttachmentArn())
                && Objects.equals(transitGatewayArn(), other.transitGatewayArn())
                && Objects.equals(ipAddress(), other.ipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteAnalysisEndpointOptions").add("TransitGatewayAttachmentArn", transitGatewayAttachmentArn())
                .add("TransitGatewayArn", transitGatewayArn()).add("IpAddress", ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentArn":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentArn()));
        case "TransitGatewayArn":
            return Optional.ofNullable(clazz.cast(transitGatewayArn()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayAttachmentArn", TRANSIT_GATEWAY_ATTACHMENT_ARN_FIELD);
        map.put("TransitGatewayArn", TRANSIT_GATEWAY_ARN_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysisEndpointOptions, T> g) {
        return obj -> g.apply((RouteAnalysisEndpointOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteAnalysisEndpointOptions> {
        /**
         * <p>
         * The ARN of the transit gateway attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentArn
         *        The ARN of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentArn(String transitGatewayAttachmentArn);

        /**
         * <p>
         * The ARN of the transit gateway.
         * </p>
         * 
         * @param transitGatewayArn
         *        The ARN of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayArn(String transitGatewayArn);

        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param ipAddress
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentArn;

        private String transitGatewayArn;

        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysisEndpointOptions model) {
            transitGatewayAttachmentArn(model.transitGatewayAttachmentArn);
            transitGatewayArn(model.transitGatewayArn);
            ipAddress(model.ipAddress);
        }

        public final String getTransitGatewayAttachmentArn() {
            return transitGatewayAttachmentArn;
        }

        public final void setTransitGatewayAttachmentArn(String transitGatewayAttachmentArn) {
            this.transitGatewayAttachmentArn = transitGatewayAttachmentArn;
        }

        @Override
        public final Builder transitGatewayAttachmentArn(String transitGatewayAttachmentArn) {
            this.transitGatewayAttachmentArn = transitGatewayAttachmentArn;
            return this;
        }

        public final String getTransitGatewayArn() {
            return transitGatewayArn;
        }

        public final void setTransitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
        }

        @Override
        public final Builder transitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        public RouteAnalysisEndpointOptions build() {
            return new RouteAnalysisEndpointOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
