/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway Connect peer association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayConnectPeerAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayConnectPeerAssociation.Builder, TransitGatewayConnectPeerAssociation> {
    private static final SdkField<String> TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayConnectPeerArn")
            .getter(getter(TransitGatewayConnectPeerAssociation::transitGatewayConnectPeerArn))
            .setter(setter(Builder::transitGatewayConnectPeerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerArn")
                    .build()).build();

    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(TransitGatewayConnectPeerAssociation::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(TransitGatewayConnectPeerAssociation::deviceId))
            .setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LinkId")
            .getter(getter(TransitGatewayConnectPeerAssociation::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(TransitGatewayConnectPeerAssociation::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD, GLOBAL_NETWORK_ID_FIELD, DEVICE_ID_FIELD, LINK_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayConnectPeerArn;

    private final String globalNetworkId;

    private final String deviceId;

    private final String linkId;

    private final String state;

    private TransitGatewayConnectPeerAssociation(BuilderImpl builder) {
        this.transitGatewayConnectPeerArn = builder.transitGatewayConnectPeerArn;
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transit gateway Connect peer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transit gateway Connect peer.
     */
    public final String transitGatewayConnectPeerArn() {
        return transitGatewayConnectPeerArn;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the link.
     * </p>
     * 
     * @return The ID of the link.
     */
    public final String linkId() {
        return linkId;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayConnectPeerAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the association.
     * @see TransitGatewayConnectPeerAssociationState
     */
    public final TransitGatewayConnectPeerAssociationState state() {
        return TransitGatewayConnectPeerAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayConnectPeerAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the association.
     * @see TransitGatewayConnectPeerAssociationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConnectPeerArn());
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectPeerAssociation)) {
            return false;
        }
        TransitGatewayConnectPeerAssociation other = (TransitGatewayConnectPeerAssociation) obj;
        return Objects.equals(transitGatewayConnectPeerArn(), other.transitGatewayConnectPeerArn())
                && Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(linkId(), other.linkId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayConnectPeerAssociation")
                .add("TransitGatewayConnectPeerArn", transitGatewayConnectPeerArn()).add("GlobalNetworkId", globalNetworkId())
                .add("DeviceId", deviceId()).add("LinkId", linkId()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayConnectPeerArn":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeerArn()));
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "LinkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayConnectPeerArn", TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD);
        map.put("GlobalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("LinkId", LINK_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectPeerAssociation, T> g) {
        return obj -> g.apply((TransitGatewayConnectPeerAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayConnectPeerAssociation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transit gateway Connect peer.
         * </p>
         * 
         * @param transitGatewayConnectPeerArn
         *        The Amazon Resource Name (ARN) of the transit gateway Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerArn(String transitGatewayConnectPeerArn);

        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the link.
         * </p>
         * 
         * @param linkId
         *        The ID of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @see TransitGatewayConnectPeerAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayConnectPeerAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @see TransitGatewayConnectPeerAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayConnectPeerAssociationState
         */
        Builder state(TransitGatewayConnectPeerAssociationState state);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayConnectPeerArn;

        private String globalNetworkId;

        private String deviceId;

        private String linkId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectPeerAssociation model) {
            transitGatewayConnectPeerArn(model.transitGatewayConnectPeerArn);
            globalNetworkId(model.globalNetworkId);
            deviceId(model.deviceId);
            linkId(model.linkId);
            state(model.state);
        }

        public final String getTransitGatewayConnectPeerArn() {
            return transitGatewayConnectPeerArn;
        }

        public final void setTransitGatewayConnectPeerArn(String transitGatewayConnectPeerArn) {
            this.transitGatewayConnectPeerArn = transitGatewayConnectPeerArn;
        }

        @Override
        public final Builder transitGatewayConnectPeerArn(String transitGatewayConnectPeerArn) {
            this.transitGatewayConnectPeerArn = transitGatewayConnectPeerArn;
            return this;
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLinkId() {
            return linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayConnectPeerAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public TransitGatewayConnectPeerAssociation build() {
            return new TransitGatewayConnectPeerAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
