/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcAttachment implements SdkPojo, Serializable, ToCopyableBuilder<VpcAttachment.Builder, VpcAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment").getter(getter(VpcAttachment::attachment)).setter(setter(Builder::attachment))
            .constructor(Attachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetArns")
            .getter(getter(VpcAttachment::subnetArns))
            .setter(setter(Builder::subnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcOptions> OPTIONS_FIELD = SdkField.<VpcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(VpcAttachment::options)).setter(setter(Builder::options))
            .constructor(VpcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            SUBNET_ARNS_FIELD, OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Attachment attachment;

    private final List<String> subnetArns;

    private final VpcOptions options;

    private VpcAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.subnetArns = builder.subnetArns;
        this.options = builder.options;
    }

    /**
     * <p>
     * Provides details about the VPC attachment.
     * </p>
     * 
     * @return Provides details about the VPC attachment.
     */
    public final Attachment attachment() {
        return attachment;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetArns() {
        return subnetArns != null && !(subnetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetArns} method.
     * </p>
     * 
     * @return The subnet ARNs.
     */
    public final List<String> subnetArns() {
        return subnetArns;
    }

    /**
     * <p>
     * Provides details about the VPC attachment.
     * </p>
     * 
     * @return Provides details about the VPC attachment.
     */
    public final VpcOptions options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetArns() ? subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcAttachment)) {
            return false;
        }
        VpcAttachment other = (VpcAttachment) obj;
        return Objects.equals(attachment(), other.attachment()) && hasSubnetArns() == other.hasSubnetArns()
                && Objects.equals(subnetArns(), other.subnetArns()) && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcAttachment").add("Attachment", attachment())
                .add("SubnetArns", hasSubnetArns() ? subnetArns() : null).add("Options", options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "SubnetArns":
            return Optional.ofNullable(clazz.cast(subnetArns()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("SubnetArns", SUBNET_ARNS_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcAttachment, T> g) {
        return obj -> g.apply((VpcAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcAttachment> {
        /**
         * <p>
         * Provides details about the VPC attachment.
         * </p>
         * 
         * @param attachment
         *        Provides details about the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(Attachment attachment);

        /**
         * <p>
         * Provides details about the VPC attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachment.Builder} avoiding the need to
         * create one manually via {@link Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attachment.Builder#build()} is called immediately and its result
         * is passed to {@link #attachment(Attachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(Attachment)
         */
        default Builder attachment(Consumer<Attachment.Builder> attachment) {
            return attachment(Attachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The subnet ARNs.
         * </p>
         * 
         * @param subnetArns
         *        The subnet ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(Collection<String> subnetArns);

        /**
         * <p>
         * The subnet ARNs.
         * </p>
         * 
         * @param subnetArns
         *        The subnet ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(String... subnetArns);

        /**
         * <p>
         * Provides details about the VPC attachment.
         * </p>
         * 
         * @param options
         *        Provides details about the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpcOptions options);

        /**
         * <p>
         * Provides details about the VPC attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOptions.Builder} avoiding the need to
         * create one manually via {@link VpcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #options(VpcOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link VpcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(VpcOptions)
         */
        default Builder options(Consumer<VpcOptions.Builder> options) {
            return options(VpcOptions.builder().applyMutation(options).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Attachment attachment;

        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();

        private VpcOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcAttachment model) {
            attachment(model.attachment);
            subnetArns(model.subnetArns);
            options(model.options);
        }

        public final Attachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final Collection<String> getSubnetArns() {
            if (subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetArns;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String... subnetArns) {
            subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final VpcOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(VpcOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(VpcOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public VpcAttachment build() {
            return new VpcAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
