/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes connection health.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionHealth implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionHealth.Builder, ConnectionHealth> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConnectionHealth::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ConnectionHealth::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(ConnectionHealth::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD,
            TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String status;

    private final Instant timestamp;

    private ConnectionHealth(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The connection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The connection type.
     * @see ConnectionType
     */
    public final ConnectionType type() {
        return ConnectionType.fromValue(type);
    }

    /**
     * <p>
     * The connection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The connection type.
     * @see ConnectionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The connection status.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The connection status.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the status was last updated.
     * </p>
     * 
     * @return The time the status was last updated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionHealth)) {
            return false;
        }
        ConnectionHealth other = (ConnectionHealth) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionHealth").add("Type", typeAsString()).add("Status", statusAsString())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionHealth, T> g) {
        return obj -> g.apply((ConnectionHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionHealth> {
        /**
         * <p>
         * The connection type.
         * </p>
         * 
         * @param type
         *        The connection type.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The connection type.
         * </p>
         * 
         * @param type
         *        The connection type.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder type(ConnectionType type);

        /**
         * <p>
         * The connection status.
         * </p>
         * 
         * @param status
         *        The connection status.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The connection status.
         * </p>
         * 
         * @param status
         *        The connection status.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);

        /**
         * <p>
         * The time the status was last updated.
         * </p>
         * 
         * @param timestamp
         *        The time the status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String status;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionHealth model) {
            type(model.type);
            status(model.status);
            timestamp(model.timestamp);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ConnectionHealth build() {
            return new ConnectionHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
