/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkNetworkFunctionGroupIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkNetworkFunctionGroupIdentifier.Builder, CoreNetworkNetworkFunctionGroupIdentifier> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CoreNetworkNetworkFunctionGroupIdentifier::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> NETWORK_FUNCTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkFunctionGroupName")
            .getter(getter(CoreNetworkNetworkFunctionGroupIdentifier::networkFunctionGroupName))
            .setter(setter(Builder::networkFunctionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroupName").build())
            .build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(CoreNetworkNetworkFunctionGroupIdentifier::edgeLocation))
            .setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            NETWORK_FUNCTION_GROUP_NAME_FIELD, EDGE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String coreNetworkId;

    private final String networkFunctionGroupName;

    private final String edgeLocation;

    private CoreNetworkNetworkFunctionGroupIdentifier(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.networkFunctionGroupName = builder.networkFunctionGroupName;
        this.edgeLocation = builder.edgeLocation;
    }

    /**
     * <p>
     * The ID of the core network.
     * </p>
     * 
     * @return The ID of the core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The network function group name.
     * </p>
     * 
     * @return The network function group name.
     */
    public final String networkFunctionGroupName() {
        return networkFunctionGroupName;
    }

    /**
     * <p>
     * The location for the core network edge.
     * </p>
     * 
     * @return The location for the core network edge.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(networkFunctionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkNetworkFunctionGroupIdentifier)) {
            return false;
        }
        CoreNetworkNetworkFunctionGroupIdentifier other = (CoreNetworkNetworkFunctionGroupIdentifier) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(networkFunctionGroupName(), other.networkFunctionGroupName())
                && Objects.equals(edgeLocation(), other.edgeLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkNetworkFunctionGroupIdentifier").add("CoreNetworkId", coreNetworkId())
                .add("NetworkFunctionGroupName", networkFunctionGroupName()).add("EdgeLocation", edgeLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "NetworkFunctionGroupName":
            return Optional.ofNullable(clazz.cast(networkFunctionGroupName()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("NetworkFunctionGroupName", NETWORK_FUNCTION_GROUP_NAME_FIELD);
        map.put("EdgeLocation", EDGE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkNetworkFunctionGroupIdentifier, T> g) {
        return obj -> g.apply((CoreNetworkNetworkFunctionGroupIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkNetworkFunctionGroupIdentifier> {
        /**
         * <p>
         * The ID of the core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of the core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The network function group name.
         * </p>
         * 
         * @param networkFunctionGroupName
         *        The network function group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFunctionGroupName(String networkFunctionGroupName);

        /**
         * <p>
         * The location for the core network edge.
         * </p>
         * 
         * @param edgeLocation
         *        The location for the core network edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkId;

        private String networkFunctionGroupName;

        private String edgeLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkNetworkFunctionGroupIdentifier model) {
            coreNetworkId(model.coreNetworkId);
            networkFunctionGroupName(model.networkFunctionGroupName);
            edgeLocation(model.edgeLocation);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getNetworkFunctionGroupName() {
            return networkFunctionGroupName;
        }

        public final void setNetworkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
        }

        @Override
        public final Builder networkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        @Override
        public CoreNetworkNetworkFunctionGroupIdentifier build() {
            return new CoreNetworkNetworkFunctionGroupIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
