/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcAttachmentResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<CreateVpcAttachmentResponse.Builder, CreateVpcAttachmentResponse> {
    private static final SdkField<VpcAttachment> VPC_ATTACHMENT_FIELD = SdkField
            .<VpcAttachment> builder(MarshallingType.SDK_POJO).memberName("VpcAttachment")
            .getter(getter(CreateVpcAttachmentResponse::vpcAttachment)).setter(setter(Builder::vpcAttachment))
            .constructor(VpcAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcAttachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcAttachment vpcAttachment;

    private CreateVpcAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.vpcAttachment = builder.vpcAttachment;
    }

    /**
     * <p>
     * Provides details about the VPC attachment.
     * </p>
     * 
     * @return Provides details about the VPC attachment.
     */
    public final VpcAttachment vpcAttachment() {
        return vpcAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAttachmentResponse)) {
            return false;
        }
        CreateVpcAttachmentResponse other = (CreateVpcAttachmentResponse) obj;
        return Objects.equals(vpcAttachment(), other.vpcAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcAttachmentResponse").add("VpcAttachment", vpcAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcAttachment":
            return Optional.ofNullable(clazz.cast(vpcAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcAttachment", VPC_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcAttachmentResponse, T> g) {
        return obj -> g.apply((CreateVpcAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcAttachmentResponse> {
        /**
         * <p>
         * Provides details about the VPC attachment.
         * </p>
         * 
         * @param vpcAttachment
         *        Provides details about the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachment(VpcAttachment vpcAttachment);

        /**
         * <p>
         * Provides details about the VPC attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcAttachment.Builder} avoiding the need
         * to create one manually via {@link VpcAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcAttachment.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcAttachment(VpcAttachment)}.
         * 
         * @param vpcAttachment
         *        a consumer that will call methods on {@link VpcAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcAttachment(VpcAttachment)
         */
        default Builder vpcAttachment(Consumer<VpcAttachment.Builder> vpcAttachment) {
            return vpcAttachment(VpcAttachment.builder().applyMutation(vpcAttachment).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private VpcAttachment vpcAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAttachmentResponse model) {
            super(model);
            vpcAttachment(model.vpcAttachment);
        }

        public final VpcAttachment.Builder getVpcAttachment() {
            return vpcAttachment != null ? vpcAttachment.toBuilder() : null;
        }

        public final void setVpcAttachment(VpcAttachment.BuilderImpl vpcAttachment) {
            this.vpcAttachment = vpcAttachment != null ? vpcAttachment.build() : null;
        }

        @Override
        public final Builder vpcAttachment(VpcAttachment vpcAttachment) {
            this.vpcAttachment = vpcAttachment;
            return this;
        }

        @Override
        public CreateVpcAttachmentResponse build() {
            return new CreateVpcAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
