/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateConnectPeerResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<DisassociateConnectPeerResponse.Builder, DisassociateConnectPeerResponse> {
    private static final SdkField<ConnectPeerAssociation> CONNECT_PEER_ASSOCIATION_FIELD = SdkField
            .<ConnectPeerAssociation> builder(MarshallingType.SDK_POJO).memberName("ConnectPeerAssociation")
            .getter(getter(DisassociateConnectPeerResponse::connectPeerAssociation))
            .setter(setter(Builder::connectPeerAssociation)).constructor(ConnectPeerAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONNECT_PEER_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConnectPeerAssociation connectPeerAssociation;

    private DisassociateConnectPeerResponse(BuilderImpl builder) {
        super(builder);
        this.connectPeerAssociation = builder.connectPeerAssociation;
    }

    /**
     * <p>
     * Describes the Connect peer association.
     * </p>
     * 
     * @return Describes the Connect peer association.
     */
    public final ConnectPeerAssociation connectPeerAssociation() {
        return connectPeerAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectPeerAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateConnectPeerResponse)) {
            return false;
        }
        DisassociateConnectPeerResponse other = (DisassociateConnectPeerResponse) obj;
        return Objects.equals(connectPeerAssociation(), other.connectPeerAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateConnectPeerResponse").add("ConnectPeerAssociation", connectPeerAssociation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectPeerAssociation":
            return Optional.ofNullable(clazz.cast(connectPeerAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectPeerAssociation", CONNECT_PEER_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateConnectPeerResponse, T> g) {
        return obj -> g.apply((DisassociateConnectPeerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateConnectPeerResponse> {
        /**
         * <p>
         * Describes the Connect peer association.
         * </p>
         * 
         * @param connectPeerAssociation
         *        Describes the Connect peer association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectPeerAssociation(ConnectPeerAssociation connectPeerAssociation);

        /**
         * <p>
         * Describes the Connect peer association.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectPeerAssociation.Builder} avoiding
         * the need to create one manually via {@link ConnectPeerAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectPeerAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #connectPeerAssociation(ConnectPeerAssociation)}.
         * 
         * @param connectPeerAssociation
         *        a consumer that will call methods on {@link ConnectPeerAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectPeerAssociation(ConnectPeerAssociation)
         */
        default Builder connectPeerAssociation(Consumer<ConnectPeerAssociation.Builder> connectPeerAssociation) {
            return connectPeerAssociation(ConnectPeerAssociation.builder().applyMutation(connectPeerAssociation).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private ConnectPeerAssociation connectPeerAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateConnectPeerResponse model) {
            super(model);
            connectPeerAssociation(model.connectPeerAssociation);
        }

        public final ConnectPeerAssociation.Builder getConnectPeerAssociation() {
            return connectPeerAssociation != null ? connectPeerAssociation.toBuilder() : null;
        }

        public final void setConnectPeerAssociation(ConnectPeerAssociation.BuilderImpl connectPeerAssociation) {
            this.connectPeerAssociation = connectPeerAssociation != null ? connectPeerAssociation.build() : null;
        }

        @Override
        public final Builder connectPeerAssociation(ConnectPeerAssociation connectPeerAssociation) {
            this.connectPeerAssociation = connectPeerAssociation;
            return this;
        }

        @Override
        public DisassociateConnectPeerResponse build() {
            return new DisassociateConnectPeerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
