/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkResourceSummary.Builder, NetworkResourceSummary> {
    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredGatewayArn").getter(getter(NetworkResourceSummary::registeredGatewayArn))
            .setter(setter(Builder::registeredGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredGatewayArn").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(NetworkResourceSummary::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(NetworkResourceSummary::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Definition").getter(getter(NetworkResourceSummary::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> NAME_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameTag").getter(getter(NetworkResourceSummary::nameTag)).setter(setter(Builder::nameTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameTag").build()).build();

    private static final SdkField<Boolean> IS_MIDDLEBOX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMiddlebox").getter(getter(NetworkResourceSummary::isMiddlebox)).setter(setter(Builder::isMiddlebox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMiddlebox").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTERED_GATEWAY_ARN_FIELD,
            RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, DEFINITION_FIELD, NAME_TAG_FIELD, IS_MIDDLEBOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String registeredGatewayArn;

    private final String resourceArn;

    private final String resourceType;

    private final String definition;

    private final String nameTag;

    private final Boolean isMiddlebox;

    private NetworkResourceSummary(BuilderImpl builder) {
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.definition = builder.definition;
        this.nameTag = builder.nameTag;
        this.isMiddlebox = builder.isMiddlebox;
    }

    /**
     * <p>
     * The ARN of the gateway.
     * </p>
     * 
     * @return The ARN of the gateway.
     */
    public final String registeredGatewayArn() {
        return registeredGatewayArn;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Information about the resource, in JSON format. Network Manager gets this information by describing the resource
     * using its Describe API call.
     * </p>
     * 
     * @return Information about the resource, in JSON format. Network Manager gets this information by describing the
     *         resource using its Describe API call.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The value for the Name tag.
     * </p>
     * 
     * @return The value for the Name tag.
     */
    public final String nameTag() {
        return nameTag;
    }

    /**
     * <p>
     * Indicates whether this is a middlebox appliance.
     * </p>
     * 
     * @return Indicates whether this is a middlebox appliance.
     */
    public final Boolean isMiddlebox() {
        return isMiddlebox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(nameTag());
        hashCode = 31 * hashCode + Objects.hashCode(isMiddlebox());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResourceSummary)) {
            return false;
        }
        NetworkResourceSummary other = (NetworkResourceSummary) obj;
        return Objects.equals(registeredGatewayArn(), other.registeredGatewayArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(definition(), other.definition()) && Objects.equals(nameTag(), other.nameTag())
                && Objects.equals(isMiddlebox(), other.isMiddlebox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkResourceSummary").add("RegisteredGatewayArn", registeredGatewayArn())
                .add("ResourceArn", resourceArn()).add("ResourceType", resourceType()).add("Definition", definition())
                .add("NameTag", nameTag()).add("IsMiddlebox", isMiddlebox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegisteredGatewayArn":
            return Optional.ofNullable(clazz.cast(registeredGatewayArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "NameTag":
            return Optional.ofNullable(clazz.cast(nameTag()));
        case "IsMiddlebox":
            return Optional.ofNullable(clazz.cast(isMiddlebox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegisteredGatewayArn", REGISTERED_GATEWAY_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("NameTag", NAME_TAG_FIELD);
        map.put("IsMiddlebox", IS_MIDDLEBOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkResourceSummary, T> g) {
        return obj -> g.apply((NetworkResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkResourceSummary> {
        /**
         * <p>
         * The ARN of the gateway.
         * </p>
         * 
         * @param registeredGatewayArn
         *        The ARN of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredGatewayArn(String registeredGatewayArn);

        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Information about the resource, in JSON format. Network Manager gets this information by describing the
         * resource using its Describe API call.
         * </p>
         * 
         * @param definition
         *        Information about the resource, in JSON format. Network Manager gets this information by describing
         *        the resource using its Describe API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The value for the Name tag.
         * </p>
         * 
         * @param nameTag
         *        The value for the Name tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameTag(String nameTag);

        /**
         * <p>
         * Indicates whether this is a middlebox appliance.
         * </p>
         * 
         * @param isMiddlebox
         *        Indicates whether this is a middlebox appliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMiddlebox(Boolean isMiddlebox);
    }

    static final class BuilderImpl implements Builder {
        private String registeredGatewayArn;

        private String resourceArn;

        private String resourceType;

        private String definition;

        private String nameTag;

        private Boolean isMiddlebox;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResourceSummary model) {
            registeredGatewayArn(model.registeredGatewayArn);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            definition(model.definition);
            nameTag(model.nameTag);
            isMiddlebox(model.isMiddlebox);
        }

        public final String getRegisteredGatewayArn() {
            return registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getNameTag() {
            return nameTag;
        }

        public final void setNameTag(String nameTag) {
            this.nameTag = nameTag;
        }

        @Override
        public final Builder nameTag(String nameTag) {
            this.nameTag = nameTag;
            return this;
        }

        public final Boolean getIsMiddlebox() {
            return isMiddlebox;
        }

        public final void setIsMiddlebox(Boolean isMiddlebox) {
            this.isMiddlebox = isMiddlebox;
        }

        @Override
        public final Builder isMiddlebox(Boolean isMiddlebox) {
            this.isMiddlebox = isMiddlebox;
            return this;
        }

        @Override
        public NetworkResourceSummary build() {
            return new NetworkResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
