/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of an Amazon Web Services Organization and the accounts within that organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationStatus.Builder, OrganizationStatus> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(OrganizationStatus::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ORGANIZATION_AWS_SERVICE_ACCESS_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationAwsServiceAccessStatus")
            .getter(getter(OrganizationStatus::organizationAwsServiceAccessStatus))
            .setter(setter(Builder::organizationAwsServiceAccessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAwsServiceAccessStatus")
                    .build()).build();

    private static final SdkField<String> SLR_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SLRDeploymentStatus").getter(getter(OrganizationStatus::slrDeploymentStatus))
            .setter(setter(Builder::slrDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SLRDeploymentStatus").build())
            .build();

    private static final SdkField<List<AccountStatus>> ACCOUNT_STATUS_LIST_FIELD = SdkField
            .<List<AccountStatus>> builder(MarshallingType.LIST)
            .memberName("AccountStatusList")
            .getter(getter(OrganizationStatus::accountStatusList))
            .setter(setter(Builder::accountStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ORGANIZATION_AWS_SERVICE_ACCESS_STATUS_FIELD, SLR_DEPLOYMENT_STATUS_FIELD, ACCOUNT_STATUS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String organizationId;

    private final String organizationAwsServiceAccessStatus;

    private final String slrDeploymentStatus;

    private final List<AccountStatus> accountStatusList;

    private OrganizationStatus(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.organizationAwsServiceAccessStatus = builder.organizationAwsServiceAccessStatus;
        this.slrDeploymentStatus = builder.slrDeploymentStatus;
        this.accountStatusList = builder.accountStatusList;
    }

    /**
     * <p>
     * The ID of an Amazon Web Services Organization.
     * </p>
     * 
     * @return The ID of an Amazon Web Services Organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The status of the organization's AWS service access. This will be <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * 
     * @return The status of the organization's AWS service access. This will be <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     */
    public final String organizationAwsServiceAccessStatus() {
        return organizationAwsServiceAccessStatus;
    }

    /**
     * <p>
     * The status of the SLR deployment for the account. This will be either <code>SUCCEEDED</code> or
     * <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return The status of the SLR deployment for the account. This will be either <code>SUCCEEDED</code> or
     *         <code>IN_PROGRESS</code>.
     */
    public final String slrDeploymentStatus() {
        return slrDeploymentStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountStatusList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountStatusList() {
        return accountStatusList != null && !(accountStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's accounts. This
     * will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountStatusList} method.
     * </p>
     * 
     * @return The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's
     *         accounts. This will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
     */
    public final List<AccountStatus> accountStatusList() {
        return accountStatusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationAwsServiceAccessStatus());
        hashCode = 31 * hashCode + Objects.hashCode(slrDeploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountStatusList() ? accountStatusList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationStatus)) {
            return false;
        }
        OrganizationStatus other = (OrganizationStatus) obj;
        return Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(organizationAwsServiceAccessStatus(), other.organizationAwsServiceAccessStatus())
                && Objects.equals(slrDeploymentStatus(), other.slrDeploymentStatus())
                && hasAccountStatusList() == other.hasAccountStatusList()
                && Objects.equals(accountStatusList(), other.accountStatusList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationStatus").add("OrganizationId", organizationId())
                .add("OrganizationAwsServiceAccessStatus", organizationAwsServiceAccessStatus())
                .add("SLRDeploymentStatus", slrDeploymentStatus())
                .add("AccountStatusList", hasAccountStatusList() ? accountStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "OrganizationAwsServiceAccessStatus":
            return Optional.ofNullable(clazz.cast(organizationAwsServiceAccessStatus()));
        case "SLRDeploymentStatus":
            return Optional.ofNullable(clazz.cast(slrDeploymentStatus()));
        case "AccountStatusList":
            return Optional.ofNullable(clazz.cast(accountStatusList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("OrganizationAwsServiceAccessStatus", ORGANIZATION_AWS_SERVICE_ACCESS_STATUS_FIELD);
        map.put("SLRDeploymentStatus", SLR_DEPLOYMENT_STATUS_FIELD);
        map.put("AccountStatusList", ACCOUNT_STATUS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationStatus, T> g) {
        return obj -> g.apply((OrganizationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationStatus> {
        /**
         * <p>
         * The ID of an Amazon Web Services Organization.
         * </p>
         * 
         * @param organizationId
         *        The ID of an Amazon Web Services Organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The status of the organization's AWS service access. This will be <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param organizationAwsServiceAccessStatus
         *        The status of the organization's AWS service access. This will be <code>ENABLED</code> or
         *        <code>DISABLED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationAwsServiceAccessStatus(String organizationAwsServiceAccessStatus);

        /**
         * <p>
         * The status of the SLR deployment for the account. This will be either <code>SUCCEEDED</code> or
         * <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param slrDeploymentStatus
         *        The status of the SLR deployment for the account. This will be either <code>SUCCEEDED</code> or
         *        <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slrDeploymentStatus(String slrDeploymentStatus);

        /**
         * <p>
         * The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's accounts.
         * This will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param accountStatusList
         *        The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's
         *        accounts. This will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountStatusList(Collection<AccountStatus> accountStatusList);

        /**
         * <p>
         * The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's accounts.
         * This will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param accountStatusList
         *        The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's
         *        accounts. This will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountStatusList(AccountStatus... accountStatusList);

        /**
         * <p>
         * The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's accounts.
         * This will be either <code>SUCCEEDED</code> or <code>IN_PROGRESS</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.AccountStatus.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.networkmanager.model.AccountStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.AccountStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #accountStatusList(List<AccountStatus>)}.
         * 
         * @param accountStatusList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.AccountStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountStatusList(java.util.Collection<AccountStatus>)
         */
        Builder accountStatusList(Consumer<AccountStatus.Builder>... accountStatusList);
    }

    static final class BuilderImpl implements Builder {
        private String organizationId;

        private String organizationAwsServiceAccessStatus;

        private String slrDeploymentStatus;

        private List<AccountStatus> accountStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationStatus model) {
            organizationId(model.organizationId);
            organizationAwsServiceAccessStatus(model.organizationAwsServiceAccessStatus);
            slrDeploymentStatus(model.slrDeploymentStatus);
            accountStatusList(model.accountStatusList);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getOrganizationAwsServiceAccessStatus() {
            return organizationAwsServiceAccessStatus;
        }

        public final void setOrganizationAwsServiceAccessStatus(String organizationAwsServiceAccessStatus) {
            this.organizationAwsServiceAccessStatus = organizationAwsServiceAccessStatus;
        }

        @Override
        public final Builder organizationAwsServiceAccessStatus(String organizationAwsServiceAccessStatus) {
            this.organizationAwsServiceAccessStatus = organizationAwsServiceAccessStatus;
            return this;
        }

        public final String getSlrDeploymentStatus() {
            return slrDeploymentStatus;
        }

        public final void setSlrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
        }

        @Override
        public final Builder slrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
            return this;
        }

        public final List<AccountStatus.Builder> getAccountStatusList() {
            List<AccountStatus.Builder> result = AccountStatusListCopier.copyToBuilder(this.accountStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountStatusList(Collection<AccountStatus.BuilderImpl> accountStatusList) {
            this.accountStatusList = AccountStatusListCopier.copyFromBuilder(accountStatusList);
        }

        @Override
        public final Builder accountStatusList(Collection<AccountStatus> accountStatusList) {
            this.accountStatusList = AccountStatusListCopier.copy(accountStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountStatusList(AccountStatus... accountStatusList) {
            accountStatusList(Arrays.asList(accountStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountStatusList(Consumer<AccountStatus.Builder>... accountStatusList) {
            accountStatusList(Stream.of(accountStatusList).map(c -> AccountStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OrganizationStatus build() {
            return new OrganizationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
