/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes proposed changes to a network function group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProposedNetworkFunctionGroupChange implements SdkPojo, Serializable,
        ToCopyableBuilder<ProposedNetworkFunctionGroupChange.Builder, ProposedNetworkFunctionGroupChange> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ProposedNetworkFunctionGroupChange::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> ATTACHMENT_POLICY_RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AttachmentPolicyRuleNumber")
            .getter(getter(ProposedNetworkFunctionGroupChange::attachmentPolicyRuleNumber))
            .setter(setter(Builder::attachmentPolicyRuleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentPolicyRuleNumber").build())
            .build();

    private static final SdkField<String> NETWORK_FUNCTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkFunctionGroupName").getter(getter(ProposedNetworkFunctionGroupChange::networkFunctionGroupName))
            .setter(setter(Builder::networkFunctionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD,
            ATTACHMENT_POLICY_RULE_NUMBER_FIELD, NETWORK_FUNCTION_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Tag> tags;

    private final Integer attachmentPolicyRuleNumber;

    private final String networkFunctionGroupName;

    private ProposedNetworkFunctionGroupChange(BuilderImpl builder) {
        this.tags = builder.tags;
        this.attachmentPolicyRuleNumber = builder.attachmentPolicyRuleNumber;
        this.networkFunctionGroupName = builder.networkFunctionGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of proposed changes to the key-value tags associated with the network function group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of proposed changes to the key-value tags associated with the network function group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The proposed new attachment policy rule number for the network function group.
     * </p>
     * 
     * @return The proposed new attachment policy rule number for the network function group.
     */
    public final Integer attachmentPolicyRuleNumber() {
        return attachmentPolicyRuleNumber;
    }

    /**
     * <p>
     * The proposed name change for the network function group name.
     * </p>
     * 
     * @return The proposed name change for the network function group name.
     */
    public final String networkFunctionGroupName() {
        return networkFunctionGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attachmentPolicyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(networkFunctionGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposedNetworkFunctionGroupChange)) {
            return false;
        }
        ProposedNetworkFunctionGroupChange other = (ProposedNetworkFunctionGroupChange) obj;
        return hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(attachmentPolicyRuleNumber(), other.attachmentPolicyRuleNumber())
                && Objects.equals(networkFunctionGroupName(), other.networkFunctionGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProposedNetworkFunctionGroupChange").add("Tags", hasTags() ? tags() : null)
                .add("AttachmentPolicyRuleNumber", attachmentPolicyRuleNumber())
                .add("NetworkFunctionGroupName", networkFunctionGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AttachmentPolicyRuleNumber":
            return Optional.ofNullable(clazz.cast(attachmentPolicyRuleNumber()));
        case "NetworkFunctionGroupName":
            return Optional.ofNullable(clazz.cast(networkFunctionGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tags", TAGS_FIELD);
        map.put("AttachmentPolicyRuleNumber", ATTACHMENT_POLICY_RULE_NUMBER_FIELD);
        map.put("NetworkFunctionGroupName", NETWORK_FUNCTION_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProposedNetworkFunctionGroupChange, T> g) {
        return obj -> g.apply((ProposedNetworkFunctionGroupChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProposedNetworkFunctionGroupChange> {
        /**
         * <p>
         * The list of proposed changes to the key-value tags associated with the network function group.
         * </p>
         * 
         * @param tags
         *        The list of proposed changes to the key-value tags associated with the network function group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of proposed changes to the key-value tags associated with the network function group.
         * </p>
         * 
         * @param tags
         *        The list of proposed changes to the key-value tags associated with the network function group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of proposed changes to the key-value tags associated with the network function group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The proposed new attachment policy rule number for the network function group.
         * </p>
         * 
         * @param attachmentPolicyRuleNumber
         *        The proposed new attachment policy rule number for the network function group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber);

        /**
         * <p>
         * The proposed name change for the network function group name.
         * </p>
         * 
         * @param networkFunctionGroupName
         *        The proposed name change for the network function group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFunctionGroupName(String networkFunctionGroupName);
    }

    static final class BuilderImpl implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Integer attachmentPolicyRuleNumber;

        private String networkFunctionGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProposedNetworkFunctionGroupChange model) {
            tags(model.tags);
            attachmentPolicyRuleNumber(model.attachmentPolicyRuleNumber);
            networkFunctionGroupName(model.networkFunctionGroupName);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getAttachmentPolicyRuleNumber() {
            return attachmentPolicyRuleNumber;
        }

        public final void setAttachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
        }

        @Override
        public final Builder attachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
            return this;
        }

        public final String getNetworkFunctionGroupName() {
            return networkFunctionGroupName;
        }

        public final void setNetworkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
        }

        @Override
        public final Builder networkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        @Override
        public ProposedNetworkFunctionGroupChange build() {
            return new ProposedNetworkFunctionGroupChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
