/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOrganizationServiceAccessUpdateResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<StartOrganizationServiceAccessUpdateResponse.Builder, StartOrganizationServiceAccessUpdateResponse> {
    private static final SdkField<OrganizationStatus> ORGANIZATION_STATUS_FIELD = SdkField
            .<OrganizationStatus> builder(MarshallingType.SDK_POJO).memberName("OrganizationStatus")
            .getter(getter(StartOrganizationServiceAccessUpdateResponse::organizationStatus))
            .setter(setter(Builder::organizationStatus)).constructor(OrganizationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OrganizationStatus organizationStatus;

    private StartOrganizationServiceAccessUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.organizationStatus = builder.organizationStatus;
    }

    /**
     * <p>
     * The status of the service access update request for an Amazon Web Services Organization.
     * </p>
     * 
     * @return The status of the service access update request for an Amazon Web Services Organization.
     */
    public final OrganizationStatus organizationStatus() {
        return organizationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOrganizationServiceAccessUpdateResponse)) {
            return false;
        }
        StartOrganizationServiceAccessUpdateResponse other = (StartOrganizationServiceAccessUpdateResponse) obj;
        return Objects.equals(organizationStatus(), other.organizationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartOrganizationServiceAccessUpdateResponse").add("OrganizationStatus", organizationStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationStatus":
            return Optional.ofNullable(clazz.cast(organizationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationStatus", ORGANIZATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartOrganizationServiceAccessUpdateResponse, T> g) {
        return obj -> g.apply((StartOrganizationServiceAccessUpdateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartOrganizationServiceAccessUpdateResponse> {
        /**
         * <p>
         * The status of the service access update request for an Amazon Web Services Organization.
         * </p>
         * 
         * @param organizationStatus
         *        The status of the service access update request for an Amazon Web Services Organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationStatus(OrganizationStatus organizationStatus);

        /**
         * <p>
         * The status of the service access update request for an Amazon Web Services Organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationStatus.Builder} avoiding the
         * need to create one manually via {@link OrganizationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #organizationStatus(OrganizationStatus)}.
         * 
         * @param organizationStatus
         *        a consumer that will call methods on {@link OrganizationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationStatus(OrganizationStatus)
         */
        default Builder organizationStatus(Consumer<OrganizationStatus.Builder> organizationStatus) {
            return organizationStatus(OrganizationStatus.builder().applyMutation(organizationStatus).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private OrganizationStatus organizationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOrganizationServiceAccessUpdateResponse model) {
            super(model);
            organizationStatus(model.organizationStatus);
        }

        public final OrganizationStatus.Builder getOrganizationStatus() {
            return organizationStatus != null ? organizationStatus.toBuilder() : null;
        }

        public final void setOrganizationStatus(OrganizationStatus.BuilderImpl organizationStatus) {
            this.organizationStatus = organizationStatus != null ? organizationStatus.build() : null;
        }

        @Override
        public final Builder organizationStatus(OrganizationStatus organizationStatus) {
            this.organizationStatus = organizationStatus;
            return this;
        }

        @Override
        public StartOrganizationServiceAccessUpdateResponse build() {
            return new StartOrganizationServiceAccessUpdateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
