/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectConnectGatewayAttachmentRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<UpdateDirectConnectGatewayAttachmentRequest.Builder, UpdateDirectConnectGatewayAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(UpdateDirectConnectGatewayAttachmentRequest::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("attachmentId").build()).build();

    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EdgeLocations")
            .getter(getter(UpdateDirectConnectGatewayAttachmentRequest::edgeLocations))
            .setter(setter(Builder::edgeLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            EDGE_LOCATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String attachmentId;

    private final List<String> edgeLocations;

    private UpdateDirectConnectGatewayAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.edgeLocations = builder.edgeLocations;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway attachment for the updated edge locations.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway attachment for the updated edge locations.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeLocations() {
        return edgeLocations != null && !(edgeLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more edge locations to update for the Direct Connect gateway attachment. The updated array of edge
     * locations overwrites the previous array of locations. <code>EdgeLocations</code> is only used for Direct Connect
     * gateway attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeLocations} method.
     * </p>
     * 
     * @return One or more edge locations to update for the Direct Connect gateway attachment. The updated array of edge
     *         locations overwrites the previous array of locations. <code>EdgeLocations</code> is only used for Direct
     *         Connect gateway attachments.
     */
    public final List<String> edgeLocations() {
        return edgeLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeLocations() ? edgeLocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayAttachmentRequest)) {
            return false;
        }
        UpdateDirectConnectGatewayAttachmentRequest other = (UpdateDirectConnectGatewayAttachmentRequest) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && hasEdgeLocations() == other.hasEdgeLocations()
                && Objects.equals(edgeLocations(), other.edgeLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDirectConnectGatewayAttachmentRequest").add("AttachmentId", attachmentId())
                .add("EdgeLocations", hasEdgeLocations() ? edgeLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "EdgeLocations":
            return Optional.ofNullable(clazz.cast(edgeLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayAttachmentRequest, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDirectConnectGatewayAttachmentRequest> {
        /**
         * <p>
         * The ID of the Direct Connect gateway attachment for the updated edge locations.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the Direct Connect gateway attachment for the updated edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * One or more edge locations to update for the Direct Connect gateway attachment. The updated array of edge
         * locations overwrites the previous array of locations. <code>EdgeLocations</code> is only used for Direct
         * Connect gateway attachments.
         * </p>
         * 
         * @param edgeLocations
         *        One or more edge locations to update for the Direct Connect gateway attachment. The updated array of
         *        edge locations overwrites the previous array of locations. <code>EdgeLocations</code> is only used for
         *        Direct Connect gateway attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(Collection<String> edgeLocations);

        /**
         * <p>
         * One or more edge locations to update for the Direct Connect gateway attachment. The updated array of edge
         * locations overwrites the previous array of locations. <code>EdgeLocations</code> is only used for Direct
         * Connect gateway attachments.
         * </p>
         * 
         * @param edgeLocations
         *        One or more edge locations to update for the Direct Connect gateway attachment. The updated array of
         *        edge locations overwrites the previous array of locations. <code>EdgeLocations</code> is only used for
         *        Direct Connect gateway attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(String... edgeLocations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String attachmentId;

        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayAttachmentRequest model) {
            super(model);
            attachmentId(model.attachmentId);
            edgeLocations(model.edgeLocations);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String... edgeLocations) {
            edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayAttachmentRequest build() {
            return new UpdateDirectConnectGatewayAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
