/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEulasResponse extends NimbleResponse implements
        ToCopyableBuilder<ListEulasResponse.Builder, ListEulasResponse> {
    private static final SdkField<List<Eula>> EULAS_FIELD = SdkField
            .<List<Eula>> builder(MarshallingType.LIST)
            .memberName("eulas")
            .getter(getter(ListEulasResponse::eulas))
            .setter(setter(Builder::eulas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Eula> builder(MarshallingType.SDK_POJO)
                                            .constructor(Eula::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEulasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EULAS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Eula> eulas;

    private final String nextToken;

    private ListEulasResponse(BuilderImpl builder) {
        super(builder);
        this.eulas = builder.eulas;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Eulas property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEulas() {
        return eulas != null && !(eulas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of EULA resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEulas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of EULA resources.
     */
    public final List<Eula> eulas() {
        return eulas;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEulas() ? eulas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEulasResponse)) {
            return false;
        }
        ListEulasResponse other = (ListEulasResponse) obj;
        return hasEulas() == other.hasEulas() && Objects.equals(eulas(), other.eulas())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEulasResponse").add("Eulas", hasEulas() ? eulas() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eulas":
            return Optional.ofNullable(clazz.cast(eulas()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEulasResponse, T> g) {
        return obj -> g.apply((ListEulasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEulasResponse> {
        /**
         * <p>
         * A collection of EULA resources.
         * </p>
         * 
         * @param eulas
         *        A collection of EULA resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulas(Collection<Eula> eulas);

        /**
         * <p>
         * A collection of EULA resources.
         * </p>
         * 
         * @param eulas
         *        A collection of EULA resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulas(Eula... eulas);

        /**
         * <p>
         * A collection of EULA resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Eula>.Builder} avoiding the need to create
         * one manually via {@link List<Eula>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Eula>.Builder#build()} is called immediately and its result
         * is passed to {@link #eulas(List<Eula>)}.
         * 
         * @param eulas
         *        a consumer that will call methods on {@link List<Eula>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eulas(List<Eula>)
         */
        Builder eulas(Consumer<Eula.Builder>... eulas);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private List<Eula> eulas = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEulasResponse model) {
            super(model);
            eulas(model.eulas);
            nextToken(model.nextToken);
        }

        public final List<Eula.Builder> getEulas() {
            List<Eula.Builder> result = EulaListCopier.copyToBuilder(this.eulas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder eulas(Collection<Eula> eulas) {
            this.eulas = EulaListCopier.copy(eulas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulas(Eula... eulas) {
            eulas(Arrays.asList(eulas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulas(Consumer<Eula.Builder>... eulas) {
            eulas(Stream.of(eulas).map(c -> Eula.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEulas(Collection<Eula.BuilderImpl> eulas) {
            this.eulas = EulaListCopier.copyFromBuilder(eulas);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEulasResponse build() {
            return new ListEulasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
