/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a shared file storage system that is associated with a studio resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharedFileSystemConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SharedFileSystemConfiguration.Builder, SharedFileSystemConfiguration> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(SharedFileSystemConfiguration::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystemId").getter(getter(SharedFileSystemConfiguration::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()).build();

    private static final SdkField<String> LINUX_MOUNT_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("linuxMountPoint").getter(getter(SharedFileSystemConfiguration::linuxMountPoint))
            .setter(setter(Builder::linuxMountPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxMountPoint").build()).build();

    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareName").getter(getter(SharedFileSystemConfiguration::shareName)).setter(setter(Builder::shareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()).build();

    private static final SdkField<String> WINDOWS_MOUNT_DRIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("windowsMountDrive").getter(getter(SharedFileSystemConfiguration::windowsMountDrive))
            .setter(setter(Builder::windowsMountDrive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windowsMountDrive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            FILE_SYSTEM_ID_FIELD, LINUX_MOUNT_POINT_FIELD, SHARE_NAME_FIELD, WINDOWS_MOUNT_DRIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final String fileSystemId;

    private final String linuxMountPoint;

    private final String shareName;

    private final String windowsMountDrive;

    private SharedFileSystemConfiguration(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.fileSystemId = builder.fileSystemId;
        this.linuxMountPoint = builder.linuxMountPoint;
        this.shareName = builder.shareName;
        this.windowsMountDrive = builder.windowsMountDrive;
    }

    /**
     * <p>
     * The endpoint of the shared file system that is accessed by the studio component resource.
     * </p>
     * 
     * @return The endpoint of the shared file system that is accessed by the studio component resource.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The unique identifier for a file system.
     * </p>
     * 
     * @return The unique identifier for a file system.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The mount location for a shared file system on a Linux virtual workstation.
     * </p>
     * 
     * @return The mount location for a shared file system on a Linux virtual workstation.
     */
    public final String linuxMountPoint() {
        return linuxMountPoint;
    }

    /**
     * <p>
     * The name of the file share.
     * </p>
     * 
     * @return The name of the file share.
     */
    public final String shareName() {
        return shareName;
    }

    /**
     * <p>
     * The mount location for a shared file system on a Windows virtual workstation.
     * </p>
     * 
     * @return The mount location for a shared file system on a Windows virtual workstation.
     */
    public final String windowsMountDrive() {
        return windowsMountDrive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(linuxMountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(shareName());
        hashCode = 31 * hashCode + Objects.hashCode(windowsMountDrive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedFileSystemConfiguration)) {
            return false;
        }
        SharedFileSystemConfiguration other = (SharedFileSystemConfiguration) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(linuxMountPoint(), other.linuxMountPoint()) && Objects.equals(shareName(), other.shareName())
                && Objects.equals(windowsMountDrive(), other.windowsMountDrive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SharedFileSystemConfiguration").add("Endpoint", endpoint()).add("FileSystemId", fileSystemId())
                .add("LinuxMountPoint", linuxMountPoint()).add("ShareName", shareName())
                .add("WindowsMountDrive", windowsMountDrive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "fileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "linuxMountPoint":
            return Optional.ofNullable(clazz.cast(linuxMountPoint()));
        case "shareName":
            return Optional.ofNullable(clazz.cast(shareName()));
        case "windowsMountDrive":
            return Optional.ofNullable(clazz.cast(windowsMountDrive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SharedFileSystemConfiguration, T> g) {
        return obj -> g.apply((SharedFileSystemConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharedFileSystemConfiguration> {
        /**
         * <p>
         * The endpoint of the shared file system that is accessed by the studio component resource.
         * </p>
         * 
         * @param endpoint
         *        The endpoint of the shared file system that is accessed by the studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The unique identifier for a file system.
         * </p>
         * 
         * @param fileSystemId
         *        The unique identifier for a file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The mount location for a shared file system on a Linux virtual workstation.
         * </p>
         * 
         * @param linuxMountPoint
         *        The mount location for a shared file system on a Linux virtual workstation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linuxMountPoint(String linuxMountPoint);

        /**
         * <p>
         * The name of the file share.
         * </p>
         * 
         * @param shareName
         *        The name of the file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareName(String shareName);

        /**
         * <p>
         * The mount location for a shared file system on a Windows virtual workstation.
         * </p>
         * 
         * @param windowsMountDrive
         *        The mount location for a shared file system on a Windows virtual workstation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsMountDrive(String windowsMountDrive);
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private String fileSystemId;

        private String linuxMountPoint;

        private String shareName;

        private String windowsMountDrive;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedFileSystemConfiguration model) {
            endpoint(model.endpoint);
            fileSystemId(model.fileSystemId);
            linuxMountPoint(model.linuxMountPoint);
            shareName(model.shareName);
            windowsMountDrive(model.windowsMountDrive);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getLinuxMountPoint() {
            return linuxMountPoint;
        }

        @Override
        public final Builder linuxMountPoint(String linuxMountPoint) {
            this.linuxMountPoint = linuxMountPoint;
            return this;
        }

        public final void setLinuxMountPoint(String linuxMountPoint) {
            this.linuxMountPoint = linuxMountPoint;
        }

        public final String getShareName() {
            return shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        public final String getWindowsMountDrive() {
            return windowsMountDrive;
        }

        @Override
        public final Builder windowsMountDrive(String windowsMountDrive) {
            this.windowsMountDrive = windowsMountDrive;
            return this;
        }

        public final void setWindowsMountDrive(String windowsMountDrive) {
            this.windowsMountDrive = windowsMountDrive;
        }

        @Override
        public SharedFileSystemConfiguration build() {
            return new SharedFileSystemConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
