/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingSession implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingSession.Builder, StreamingSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StreamingSession::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(StreamingSession::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(StreamingSession::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceType").getter(getter(StreamingSession::ec2InstanceType))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceType").build()).build();

    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchProfileId").getter(getter(StreamingSession::launchProfileId))
            .setter(setter(Builder::launchProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(StreamingSession::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(StreamingSession::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(StreamingSession::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(StreamingSession::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamingImageId").getter(getter(StreamingSession::streamingImageId))
            .setter(setter(Builder::streamingImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImageId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StreamingSession::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> TERMINATE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("terminateAt")
            .getter(getter(StreamingSession::terminateAt))
            .setter(setter(Builder::terminateAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(StreamingSession::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(StreamingSession::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            CREATED_BY_FIELD, EC2_INSTANCE_TYPE_FIELD, LAUNCH_PROFILE_ID_FIELD, SESSION_ID_FIELD, STATE_FIELD, STATUS_CODE_FIELD,
            STATUS_MESSAGE_FIELD, STREAMING_IMAGE_ID_FIELD, TAGS_FIELD, TERMINATE_AT_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String createdBy;

    private final String ec2InstanceType;

    private final String launchProfileId;

    private final String sessionId;

    private final String state;

    private final String statusCodeValue;

    private final String statusMessage;

    private final String streamingImageId;

    private final Map<String, String> tags;

    private final Instant terminateAt;

    private final Instant updatedAt;

    private final String updatedBy;

    private StreamingSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.launchProfileId = builder.launchProfileId;
        this.sessionId = builder.sessionId;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.streamingImageId = builder.streamingImageId;
        this.tags = builder.tags;
        this.terminateAt = builder.terminateAt;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was created.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user ID of the user that created the streaming session.
     * </p>
     * 
     * @return The user ID of the user that created the streaming session.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The EC2 Instance type used for the streaming session.
     * </p>
     * 
     * @return The EC2 Instance type used for the streaming session.
     */
    public final String ec2InstanceType() {
        return ec2InstanceType;
    }

    /**
     * <p>
     * The ID of the launch profile used to control access from the streaming session.
     * </p>
     * 
     * @return The ID of the launch profile used to control access from the streaming session.
     */
    public final String launchProfileId() {
        return launchProfileId;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamingSessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StreamingSessionState
     */
    public final StreamingSessionState state() {
        return StreamingSessionState.fromValue(state);
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamingSessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StreamingSessionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StreamingSessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StreamingSessionStatusCode
     */
    public final StreamingSessionStatusCode statusCode() {
        return StreamingSessionStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StreamingSessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StreamingSessionStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The status message for the streaming session.
     * </p>
     * 
     * @return The status message for the streaming session.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The ID of the streaming image.
     * </p>
     * 
     * @return The ID of the streaming image.
     */
    public final String streamingImageId() {
        return streamingImageId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key:value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of labels, in the form of key:value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The time the streaming session will automatically terminate if not terminated by the user.
     * </p>
     * 
     * @return The time the streaming session will automatically terminate if not terminated by the user.
     */
    public final Instant terminateAt() {
        return terminateAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was updated.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user ID of the user that most recently updated the resource.
     * </p>
     * 
     * @return The user ID of the user that most recently updated the resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(terminateAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingSession)) {
            return false;
        }
        StreamingSession other = (StreamingSession) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(ec2InstanceType(), other.ec2InstanceType())
                && Objects.equals(launchProfileId(), other.launchProfileId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(streamingImageId(), other.streamingImageId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(terminateAt(), other.terminateAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingSession").add("Arn", arn()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Ec2InstanceType", ec2InstanceType()).add("LaunchProfileId", launchProfileId())
                .add("SessionId", sessionId()).add("State", stateAsString()).add("StatusCode", statusCodeAsString())
                .add("StatusMessage", statusMessage()).add("StreamingImageId", streamingImageId())
                .add("Tags", hasTags() ? tags() : null).add("TerminateAt", terminateAt()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ec2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceType()));
        case "launchProfileId":
            return Optional.ofNullable(clazz.cast(launchProfileId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "streamingImageId":
            return Optional.ofNullable(clazz.cast(streamingImageId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "terminateAt":
            return Optional.ofNullable(clazz.cast(terminateAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingSession, T> g) {
        return obj -> g.apply((StreamingSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingSession> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp in seconds for when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user ID of the user that created the streaming session.
         * </p>
         * 
         * @param createdBy
         *        The user ID of the user that created the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The EC2 Instance type used for the streaming session.
         * </p>
         * 
         * @param ec2InstanceType
         *        The EC2 Instance type used for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * The ID of the launch profile used to control access from the streaming session.
         * </p>
         * 
         * @param launchProfileId
         *        The ID of the launch profile used to control access from the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileId(String launchProfileId);

        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StreamingSessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StreamingSessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionState
         */
        Builder state(StreamingSessionState state);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StreamingSessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StreamingSessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingSessionStatusCode
         */
        Builder statusCode(StreamingSessionStatusCode statusCodeValue);

        /**
         * <p>
         * The status message for the streaming session.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The ID of the streaming image.
         * </p>
         * 
         * @param streamingImageId
         *        The ID of the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImageId(String streamingImageId);

        /**
         * <p>
         * A collection of labels, in the form of key:value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key:value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The time the streaming session will automatically terminate if not terminated by the user.
         * </p>
         * 
         * @param terminateAt
         *        The time the streaming session will automatically terminate if not terminated by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateAt(Instant terminateAt);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix epoch timestamp in seconds for when the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user ID of the user that most recently updated the resource.
         * </p>
         * 
         * @param updatedBy
         *        The user ID of the user that most recently updated the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String createdBy;

        private String ec2InstanceType;

        private String launchProfileId;

        private String sessionId;

        private String state;

        private String statusCodeValue;

        private String statusMessage;

        private String streamingImageId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant terminateAt;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingSession model) {
            arn(model.arn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            ec2InstanceType(model.ec2InstanceType);
            launchProfileId(model.launchProfileId);
            sessionId(model.sessionId);
            state(model.state);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
            streamingImageId(model.streamingImageId);
            tags(model.tags);
            terminateAt(model.terminateAt);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final String getLaunchProfileId() {
            return launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamingSessionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(StreamingSessionStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getStreamingImageId() {
            return streamingImageId;
        }

        @Override
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Instant getTerminateAt() {
            return terminateAt;
        }

        @Override
        public final Builder terminateAt(Instant terminateAt) {
            this.terminateAt = terminateAt;
            return this;
        }

        public final void setTerminateAt(Instant terminateAt) {
            this.terminateAt = terminateAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public StreamingSession build() {
            return new StreamingSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
