/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamingImageResponse extends NimbleResponse implements
        ToCopyableBuilder<GetStreamingImageResponse.Builder, GetStreamingImageResponse> {
    private static final SdkField<StreamingImage> STREAMING_IMAGE_FIELD = SdkField
            .<StreamingImage> builder(MarshallingType.SDK_POJO).memberName("streamingImage")
            .getter(getter(GetStreamingImageResponse::streamingImage)).setter(setter(Builder::streamingImage))
            .constructor(StreamingImage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_IMAGE_FIELD));

    private final StreamingImage streamingImage;

    private GetStreamingImageResponse(BuilderImpl builder) {
        super(builder);
        this.streamingImage = builder.streamingImage;
    }

    /**
     * <p>
     * The streaming image.
     * </p>
     * 
     * @return The streaming image.
     */
    public final StreamingImage streamingImage() {
        return streamingImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingImageResponse)) {
            return false;
        }
        GetStreamingImageResponse other = (GetStreamingImageResponse) obj;
        return Objects.equals(streamingImage(), other.streamingImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamingImageResponse").add("StreamingImage", streamingImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamingImage":
            return Optional.ofNullable(clazz.cast(streamingImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamingImageResponse, T> g) {
        return obj -> g.apply((GetStreamingImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamingImageResponse> {
        /**
         * <p>
         * The streaming image.
         * </p>
         * 
         * @param streamingImage
         *        The streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImage(StreamingImage streamingImage);

        /**
         * <p>
         * The streaming image.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingImage.Builder} avoiding the need to
         * create one manually via {@link StreamingImage#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingImage.Builder#build()} is called immediately and its
         * result is passed to {@link #streamingImage(StreamingImage)}.
         * 
         * @param streamingImage
         *        a consumer that will call methods on {@link StreamingImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingImage(StreamingImage)
         */
        default Builder streamingImage(Consumer<StreamingImage.Builder> streamingImage) {
            return streamingImage(StreamingImage.builder().applyMutation(streamingImage).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private StreamingImage streamingImage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingImageResponse model) {
            super(model);
            streamingImage(model.streamingImage);
        }

        public final StreamingImage.Builder getStreamingImage() {
            return streamingImage != null ? streamingImage.toBuilder() : null;
        }

        @Override
        public final Builder streamingImage(StreamingImage streamingImage) {
            this.streamingImage = streamingImage;
            return this;
        }

        public final void setStreamingImage(StreamingImage.BuilderImpl streamingImage) {
            this.streamingImage = streamingImage != null ? streamingImage.build() : null;
        }

        @Override
        public GetStreamingImageResponse build() {
            return new GetStreamingImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
