/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStudioRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, UpdateStudioRequest> {
    private static final SdkField<String> ADMIN_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminRoleArn").getter(UpdateStudioRequest.getter(UpdateStudioRequest::adminRoleArn)).setter(UpdateStudioRequest.setter(Builder::adminRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminRoleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateStudioRequest.getter(UpdateStudioRequest::clientToken)).setter(UpdateStudioRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateStudioRequest.getter(UpdateStudioRequest::displayName)).setter(UpdateStudioRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(UpdateStudioRequest.getter(UpdateStudioRequest::studioId)).setter(UpdateStudioRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final SdkField<String> USER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userRoleArn").getter(UpdateStudioRequest.getter(UpdateStudioRequest::userRoleArn)).setter(UpdateStudioRequest.setter(Builder::userRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, STUDIO_ID_FIELD, USER_ROLE_ARN_FIELD));
    private final String adminRoleArn;
    private final String clientToken;
    private final String displayName;
    private final String studioId;
    private final String userRoleArn;

    private UpdateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.adminRoleArn = builder.adminRoleArn;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.studioId = builder.studioId;
        this.userRoleArn = builder.userRoleArn;
    }

    public final String adminRoleArn() {
        return this.adminRoleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final String userRoleArn() {
        return this.userRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStudioRequest)) {
            return false;
        }
        UpdateStudioRequest other = (UpdateStudioRequest)((Object)obj);
        return Objects.equals(this.adminRoleArn(), other.adminRoleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.userRoleArn(), other.userRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStudioRequest").add("AdminRoleArn", (Object)this.adminRoleArn()).add("ClientToken", (Object)this.clientToken()).add("DisplayName", (Object)this.displayName()).add("StudioId", (Object)this.studioId()).add("UserRoleArn", (Object)this.userRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminRoleArn": {
                return Optional.ofNullable(clazz.cast(this.adminRoleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "userRoleArn": {
                return Optional.ofNullable(clazz.cast(this.userRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStudioRequest, T> g) {
        return obj -> g.apply((UpdateStudioRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String adminRoleArn;
        private String clientToken;
        private String displayName;
        private String studioId;
        private String userRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStudioRequest model) {
            super(model);
            this.adminRoleArn(model.adminRoleArn);
            this.clientToken(model.clientToken);
            this.displayName(model.displayName);
            this.studioId(model.studioId);
            this.userRoleArn(model.userRoleArn);
        }

        public final String getAdminRoleArn() {
            return this.adminRoleArn;
        }

        @Override
        public final Builder adminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
            return this;
        }

        public final void setAdminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        public final String getUserRoleArn() {
            return this.userRoleArn;
        }

        @Override
        public final Builder userRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
            return this;
        }

        public final void setUserRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStudioRequest build() {
            return new UpdateStudioRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStudioRequest> {
        public Builder adminRoleArn(String var1);

        public Builder clientToken(String var1);

        public Builder displayName(String var1);

        public Builder studioId(String var1);

        public Builder userRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

