/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchProfileInitializationRequest extends NimbleRequest implements
        ToCopyableBuilder<GetLaunchProfileInitializationRequest.Builder, GetLaunchProfileInitializationRequest> {
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchProfileId").getter(getter(GetLaunchProfileInitializationRequest::launchProfileId))
            .setter(setter(Builder::launchProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("launchProfileId").build()).build();

    private static final SdkField<List<String>> LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("launchProfileProtocolVersions")
            .getter(getter(GetLaunchProfileInitializationRequest::launchProfileProtocolVersions))
            .setter(setter(Builder::launchProfileProtocolVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("launchProfileProtocolVersions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAUNCH_PURPOSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchPurpose").getter(getter(GetLaunchProfileInitializationRequest::launchPurpose))
            .setter(setter(Builder::launchPurpose))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("launchPurpose").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(GetLaunchProfileInitializationRequest::platform))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platform").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(GetLaunchProfileInitializationRequest::studioId))
            .setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PROFILE_ID_FIELD,
            LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD, LAUNCH_PURPOSE_FIELD, PLATFORM_FIELD, STUDIO_ID_FIELD));

    private final String launchProfileId;

    private final List<String> launchProfileProtocolVersions;

    private final String launchPurpose;

    private final String platform;

    private final String studioId;

    private GetLaunchProfileInitializationRequest(BuilderImpl builder) {
        super(builder);
        this.launchProfileId = builder.launchProfileId;
        this.launchProfileProtocolVersions = builder.launchProfileProtocolVersions;
        this.launchPurpose = builder.launchPurpose;
        this.platform = builder.platform;
        this.studioId = builder.studioId;
    }

    /**
     * <p>
     * The launch profile ID.
     * </p>
     * 
     * @return The launch profile ID.
     */
    public final String launchProfileId() {
        return launchProfileId;
    }

    /**
     * Returns true if the LaunchProfileProtocolVersions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasLaunchProfileProtocolVersions() {
        return launchProfileProtocolVersions != null && !(launchProfileProtocolVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of launch profile protocol versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchProfileProtocolVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of launch profile protocol versions.
     */
    public final List<String> launchProfileProtocolVersions() {
        return launchProfileProtocolVersions;
    }

    /**
     * <p>
     * The launch purpose.
     * </p>
     * 
     * @return The launch purpose.
     */
    public final String launchPurpose() {
        return launchPurpose;
    }

    /**
     * <p>
     * The platform.
     * </p>
     * 
     * @return The platform.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchProfileProtocolVersions() ? launchProfileProtocolVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(launchPurpose());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchProfileInitializationRequest)) {
            return false;
        }
        GetLaunchProfileInitializationRequest other = (GetLaunchProfileInitializationRequest) obj;
        return Objects.equals(launchProfileId(), other.launchProfileId())
                && hasLaunchProfileProtocolVersions() == other.hasLaunchProfileProtocolVersions()
                && Objects.equals(launchProfileProtocolVersions(), other.launchProfileProtocolVersions())
                && Objects.equals(launchPurpose(), other.launchPurpose()) && Objects.equals(platform(), other.platform())
                && Objects.equals(studioId(), other.studioId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetLaunchProfileInitializationRequest")
                .add("LaunchProfileId", launchProfileId())
                .add("LaunchProfileProtocolVersions", hasLaunchProfileProtocolVersions() ? launchProfileProtocolVersions() : null)
                .add("LaunchPurpose", launchPurpose()).add("Platform", platform()).add("StudioId", studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchProfileId":
            return Optional.ofNullable(clazz.cast(launchProfileId()));
        case "launchProfileProtocolVersions":
            return Optional.ofNullable(clazz.cast(launchProfileProtocolVersions()));
        case "launchPurpose":
            return Optional.ofNullable(clazz.cast(launchPurpose()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchProfileInitializationRequest, T> g) {
        return obj -> g.apply((GetLaunchProfileInitializationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLaunchProfileInitializationRequest> {
        /**
         * <p>
         * The launch profile ID.
         * </p>
         * 
         * @param launchProfileId
         *        The launch profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileId(String launchProfileId);

        /**
         * <p>
         * A collection of launch profile protocol versions.
         * </p>
         * 
         * @param launchProfileProtocolVersions
         *        A collection of launch profile protocol versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions);

        /**
         * <p>
         * A collection of launch profile protocol versions.
         * </p>
         * 
         * @param launchProfileProtocolVersions
         *        A collection of launch profile protocol versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileProtocolVersions(String... launchProfileProtocolVersions);

        /**
         * <p>
         * The launch purpose.
         * </p>
         * 
         * @param launchPurpose
         *        The launch purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPurpose(String launchPurpose);

        /**
         * <p>
         * The platform.
         * </p>
         * 
         * @param platform
         *        The platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String launchProfileId;

        private List<String> launchProfileProtocolVersions = DefaultSdkAutoConstructList.getInstance();

        private String launchPurpose;

        private String platform;

        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchProfileInitializationRequest model) {
            super(model);
            launchProfileId(model.launchProfileId);
            launchProfileProtocolVersions(model.launchProfileProtocolVersions);
            launchPurpose(model.launchPurpose);
            platform(model.platform);
            studioId(model.studioId);
        }

        public final String getLaunchProfileId() {
            return launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        public final Collection<String> getLaunchProfileProtocolVersions() {
            if (launchProfileProtocolVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return launchProfileProtocolVersions;
        }

        @Override
        public final Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = _multiValueQueryStringListCopier.copy(launchProfileProtocolVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchProfileProtocolVersions(String... launchProfileProtocolVersions) {
            launchProfileProtocolVersions(Arrays.asList(launchProfileProtocolVersions));
            return this;
        }

        public final void setLaunchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = _multiValueQueryStringListCopier.copy(launchProfileProtocolVersions);
        }

        public final String getLaunchPurpose() {
            return launchPurpose;
        }

        @Override
        public final Builder launchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
            return this;
        }

        public final void setLaunchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getStudioId() {
            return studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLaunchProfileInitializationRequest build() {
            return new GetLaunchProfileInitializationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
