/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchProfileInitializationScript implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchProfileInitializationScript.Builder, LaunchProfileInitializationScript> {
    private static final SdkField<String> SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("script")
            .getter(getter(LaunchProfileInitializationScript::script)).setter(setter(Builder::script))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()).build();

    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioComponentId").getter(getter(LaunchProfileInitializationScript::studioComponentId))
            .setter(setter(Builder::studioComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentId").build()).build();

    private static final SdkField<String> STUDIO_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioComponentName").getter(getter(LaunchProfileInitializationScript::studioComponentName))
            .setter(setter(Builder::studioComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_FIELD,
            STUDIO_COMPONENT_ID_FIELD, STUDIO_COMPONENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String script;

    private final String studioComponentId;

    private final String studioComponentName;

    private LaunchProfileInitializationScript(BuilderImpl builder) {
        this.script = builder.script;
        this.studioComponentId = builder.studioComponentId;
        this.studioComponentName = builder.studioComponentName;
    }

    /**
     * <p>
     * The initialization script.
     * </p>
     * 
     * @return The initialization script.
     */
    public final String script() {
        return script;
    }

    /**
     * <p>
     * The unique identifier for a studio component resource.
     * </p>
     * 
     * @return The unique identifier for a studio component resource.
     */
    public final String studioComponentId() {
        return studioComponentId;
    }

    /**
     * <p>
     * The name for the studio component.
     * </p>
     * 
     * @return The name for the studio component.
     */
    public final String studioComponentName() {
        return studioComponentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(script());
        hashCode = 31 * hashCode + Objects.hashCode(studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(studioComponentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitializationScript)) {
            return false;
        }
        LaunchProfileInitializationScript other = (LaunchProfileInitializationScript) obj;
        return Objects.equals(script(), other.script()) && Objects.equals(studioComponentId(), other.studioComponentId())
                && Objects.equals(studioComponentName(), other.studioComponentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchProfileInitializationScript").add("Script", script())
                .add("StudioComponentId", studioComponentId()).add("StudioComponentName", studioComponentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "script":
            return Optional.ofNullable(clazz.cast(script()));
        case "studioComponentId":
            return Optional.ofNullable(clazz.cast(studioComponentId()));
        case "studioComponentName":
            return Optional.ofNullable(clazz.cast(studioComponentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfileInitializationScript, T> g) {
        return obj -> g.apply((LaunchProfileInitializationScript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchProfileInitializationScript> {
        /**
         * <p>
         * The initialization script.
         * </p>
         * 
         * @param script
         *        The initialization script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder script(String script);

        /**
         * <p>
         * The unique identifier for a studio component resource.
         * </p>
         * 
         * @param studioComponentId
         *        The unique identifier for a studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentId(String studioComponentId);

        /**
         * <p>
         * The name for the studio component.
         * </p>
         * 
         * @param studioComponentName
         *        The name for the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentName(String studioComponentName);
    }

    static final class BuilderImpl implements Builder {
        private String script;

        private String studioComponentId;

        private String studioComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfileInitializationScript model) {
            script(model.script);
            studioComponentId(model.studioComponentId);
            studioComponentName(model.studioComponentName);
        }

        public final String getScript() {
            return script;
        }

        @Override
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        public final String getStudioComponentId() {
            return studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        public final String getStudioComponentName() {
            return studioComponentName;
        }

        @Override
        public final Builder studioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
            return this;
        }

        public final void setStudioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
        }

        @Override
        public LaunchProfileInitializationScript build() {
            return new LaunchProfileInitializationScript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
