/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.EulaAcceptance;
import software.amazon.awssdk.services.nimble.model.EulaAcceptanceListCopier;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEulaAcceptancesResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListEulaAcceptancesResponse> {
    private static final SdkField<List<EulaAcceptance>> EULA_ACCEPTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eulaAcceptances").getter(ListEulaAcceptancesResponse.getter(ListEulaAcceptancesResponse::eulaAcceptances)).setter(ListEulaAcceptancesResponse.setter(Builder::eulaAcceptances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaAcceptances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EulaAcceptance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEulaAcceptancesResponse.getter(ListEulaAcceptancesResponse::nextToken)).setter(ListEulaAcceptancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EULA_ACCEPTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<EulaAcceptance> eulaAcceptances;
    private final String nextToken;

    private ListEulaAcceptancesResponse(BuilderImpl builder) {
        super(builder);
        this.eulaAcceptances = builder.eulaAcceptances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEulaAcceptances() {
        return this.eulaAcceptances != null && !(this.eulaAcceptances instanceof SdkAutoConstructList);
    }

    public final List<EulaAcceptance> eulaAcceptances() {
        return this.eulaAcceptances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEulaAcceptances() ? this.eulaAcceptances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEulaAcceptancesResponse)) {
            return false;
        }
        ListEulaAcceptancesResponse other = (ListEulaAcceptancesResponse)((Object)obj);
        return this.hasEulaAcceptances() == other.hasEulaAcceptances() && Objects.equals(this.eulaAcceptances(), other.eulaAcceptances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEulaAcceptancesResponse").add("EulaAcceptances", this.hasEulaAcceptances() ? this.eulaAcceptances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eulaAcceptances": {
                return Optional.ofNullable(clazz.cast(this.eulaAcceptances()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEulaAcceptancesResponse, T> g) {
        return obj -> g.apply((ListEulaAcceptancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private List<EulaAcceptance> eulaAcceptances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEulaAcceptancesResponse model) {
            super(model);
            this.eulaAcceptances(model.eulaAcceptances);
            this.nextToken(model.nextToken);
        }

        public final List<EulaAcceptance.Builder> getEulaAcceptances() {
            List<EulaAcceptance.Builder> result = EulaAcceptanceListCopier.copyToBuilder(this.eulaAcceptances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder eulaAcceptances(Collection<EulaAcceptance> eulaAcceptances) {
            this.eulaAcceptances = EulaAcceptanceListCopier.copy(eulaAcceptances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulaAcceptances(EulaAcceptance ... eulaAcceptances) {
            this.eulaAcceptances(Arrays.asList(eulaAcceptances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulaAcceptances(Consumer<EulaAcceptance.Builder> ... eulaAcceptances) {
            this.eulaAcceptances(Stream.of(eulaAcceptances).map(c -> (EulaAcceptance)((EulaAcceptance.Builder)EulaAcceptance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEulaAcceptances(Collection<EulaAcceptance.BuilderImpl> eulaAcceptances) {
            this.eulaAcceptances = EulaAcceptanceListCopier.copyFromBuilder(eulaAcceptances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEulaAcceptancesResponse build() {
            return new ListEulaAcceptancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEulaAcceptancesResponse> {
        public Builder eulaAcceptances(Collection<EulaAcceptance> var1);

        public Builder eulaAcceptances(EulaAcceptance ... var1);

        public Builder eulaAcceptances(Consumer<EulaAcceptance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

