/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StudioEncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StudioEncryptionConfiguration> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyArn").getter(StudioEncryptionConfiguration.getter(StudioEncryptionConfiguration::keyArn)).setter(StudioEncryptionConfiguration.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyArn").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyType").getter(StudioEncryptionConfiguration.getter(StudioEncryptionConfiguration::keyTypeAsString)).setter(StudioEncryptionConfiguration.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyArn;
    private final String keyType;

    private StudioEncryptionConfiguration(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.keyType = builder.keyType;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public final StudioEncryptionConfigurationKeyType keyType() {
        return StudioEncryptionConfigurationKeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioEncryptionConfiguration)) {
            return false;
        }
        StudioEncryptionConfiguration other = (StudioEncryptionConfiguration)obj;
        return Objects.equals(this.keyArn(), other.keyArn()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StudioEncryptionConfiguration").add("KeyArn", (Object)this.keyArn()).add("KeyType", (Object)this.keyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
            case "keyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioEncryptionConfiguration, T> g) {
        return obj -> g.apply((StudioEncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyArn;
        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioEncryptionConfiguration model) {
            this.keyArn(model.keyArn);
            this.keyType(model.keyType);
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(StudioEncryptionConfigurationKeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public StudioEncryptionConfiguration build() {
            return new StudioEncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StudioEncryptionConfiguration> {
        public Builder keyArn(String var1);

        public Builder keyType(String var1);

        public Builder keyType(StudioEncryptionConfigurationKeyType var1);
    }
}

