/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.nimble.model.AcceptEulasRequest;
import software.amazon.awssdk.services.nimble.model.AcceptEulasResponse;
import software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.CreateStudioRequest;
import software.amazon.awssdk.services.nimble.model.CreateStudioResponse;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioMemberResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioResponse;
import software.amazon.awssdk.services.nimble.model.GetEulaRequest;
import software.amazon.awssdk.services.nimble.model.GetEulaResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioResponse;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse;
import software.amazon.awssdk.services.nimble.model.ListEulasRequest;
import software.amazon.awssdk.services.nimble.model.ListEulasResponse;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.ListStudiosRequest;
import software.amazon.awssdk.services.nimble.model.ListStudiosResponse;
import software.amazon.awssdk.services.nimble.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersResponse;
import software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.PutStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairRequest;
import software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairResponse;
import software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.TagResourceRequest;
import software.amazon.awssdk.services.nimble.model.TagResourceResponse;
import software.amazon.awssdk.services.nimble.model.UntagResourceRequest;
import software.amazon.awssdk.services.nimble.model.UntagResourceResponse;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStudioRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStudioResponse;
import software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher;
import software.amazon.awssdk.services.nimble.waiters.NimbleAsyncWaiter;

/**
 * Service client for accessing AmazonNimbleStudio asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Welcome to the Amazon Nimble Studio API reference. This API reference provides methods, schema, resources,
 * parameters, and more to help you get the most out of Nimble Studio.
 * </p>
 * <p>
 * Nimble Studio is a virtual studio that empowers visual effects, animation, and interactive content teams to create
 * content securely within a scalable, private cloud service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NimbleAsyncClient extends SdkClient {
    String SERVICE_NAME = "nimble";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "nimble";

    /**
     * Create a {@link NimbleAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NimbleAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NimbleAsyncClient}.
     */
    static NimbleAsyncClientBuilder builder() {
        return new DefaultNimbleAsyncClientBuilder();
    }

    /**
     * <p>
     * Accept EULAs.
     * </p>
     *
     * @param acceptEulasRequest
     * @return A Java Future containing the result of the AcceptEulas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.AcceptEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/AcceptEulas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptEulasResponse> acceptEulas(AcceptEulasRequest acceptEulasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accept EULAs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptEulasRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptEulasRequest#builder()}
     * </p>
     *
     * @param acceptEulasRequest
     *        A {@link Consumer} that will call methods on {@link AcceptEulasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptEulas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.AcceptEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/AcceptEulas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptEulasResponse> acceptEulas(Consumer<AcceptEulasRequest.Builder> acceptEulasRequest) {
        return acceptEulas(AcceptEulasRequest.builder().applyMutation(acceptEulasRequest).build());
    }

    /**
     * <p>
     * Create a launch profile.
     * </p>
     *
     * @param createLaunchProfileRequest
     * @return A Java Future containing the result of the CreateLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLaunchProfileResponse> createLaunchProfile(
            CreateLaunchProfileRequest createLaunchProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a launch profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLaunchProfileRequest#builder()}
     * </p>
     *
     * @param createLaunchProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLaunchProfileResponse> createLaunchProfile(
            Consumer<CreateLaunchProfileRequest.Builder> createLaunchProfileRequest) {
        return createLaunchProfile(CreateLaunchProfileRequest.builder().applyMutation(createLaunchProfileRequest).build());
    }

    /**
     * <p>
     * Creates a streaming image resource in a studio.
     * </p>
     *
     * @param createStreamingImageRequest
     * @return A Java Future containing the result of the CreateStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStreamingImageResponse> createStreamingImage(
            CreateStreamingImageRequest createStreamingImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a streaming image resource in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingImageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStreamingImageRequest#builder()}
     * </p>
     *
     * @param createStreamingImageRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStreamingImageResponse> createStreamingImage(
            Consumer<CreateStreamingImageRequest.Builder> createStreamingImageRequest) {
        return createStreamingImage(CreateStreamingImageRequest.builder().applyMutation(createStreamingImageRequest).build());
    }

    /**
     * <p>
     * Creates a streaming session in a studio.
     * </p>
     * <p>
     * After invoking this operation, you must poll GetStreamingSession until the streaming session is in state READY.
     * </p>
     *
     * @param createStreamingSessionRequest
     * @return A Java Future containing the result of the CreateStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStreamingSessionResponse> createStreamingSession(
            CreateStreamingSessionRequest createStreamingSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a streaming session in a studio.
     * </p>
     * <p>
     * After invoking this operation, you must poll GetStreamingSession until the streaming session is in state READY.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingSessionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStreamingSessionRequest#builder()}
     * </p>
     *
     * @param createStreamingSessionRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStreamingSessionResponse> createStreamingSession(
            Consumer<CreateStreamingSessionRequest.Builder> createStreamingSessionRequest) {
        return createStreamingSession(CreateStreamingSessionRequest.builder().applyMutation(createStreamingSessionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a streaming session stream for a streaming session.
     * </p>
     * <p>
     * After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until
     * it is in state READY.
     * </p>
     *
     * @param createStreamingSessionStreamRequest
     * @return A Java Future containing the result of the CreateStreamingSessionStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingSessionStreamResponse> createStreamingSessionStream(
            CreateStreamingSessionStreamRequest createStreamingSessionStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a streaming session stream for a streaming session.
     * </p>
     * <p>
     * After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until
     * it is in state READY.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingSessionStreamRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingSessionStreamRequest#builder()}
     * </p>
     *
     * @param createStreamingSessionStreamRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingSessionStreamRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateStreamingSessionStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingSessionStreamResponse> createStreamingSessionStream(
            Consumer<CreateStreamingSessionStreamRequest.Builder> createStreamingSessionStreamRequest) {
        return createStreamingSessionStream(CreateStreamingSessionStreamRequest.builder()
                .applyMutation(createStreamingSessionStreamRequest).build());
    }

    /**
     * <p>
     * Create a new Studio.
     * </p>
     * <p>
     * When creating a Studio, two IAM roles must be provided: the admin role and the user Role. These roles are assumed
     * by your users when they log in to the Nimble Studio portal.
     * </p>
     * <p>
     * The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function
     * properly.
     * </p>
     * <p>
     * The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function
     * properly.
     * </p>
     * <p>
     * You may optionally specify a KMS key in the StudioEncryptionConfiguration.
     * </p>
     * <p>
     * In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always
     * encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your
     * behalf. You may provide your own KMS key when calling CreateStudio to encrypt this data using a key you own and
     * manage.
     * </p>
     * <p>
     * When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide
     * your studio user and admin roles access to these KMS keys.
     * </p>
     * <p>
     * If you delete this grant, the studio will no longer be accessible to your portal users.
     * </p>
     * <p>
     * If you delete the studio KMS key, your studio will no longer be accessible.
     * </p>
     *
     * @param createStudioRequest
     * @return A Java Future containing the result of the CreateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStudioResponse> createStudio(CreateStudioRequest createStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new Studio.
     * </p>
     * <p>
     * When creating a Studio, two IAM roles must be provided: the admin role and the user Role. These roles are assumed
     * by your users when they log in to the Nimble Studio portal.
     * </p>
     * <p>
     * The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function
     * properly.
     * </p>
     * <p>
     * The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function
     * properly.
     * </p>
     * <p>
     * You may optionally specify a KMS key in the StudioEncryptionConfiguration.
     * </p>
     * <p>
     * In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always
     * encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your
     * behalf. You may provide your own KMS key when calling CreateStudio to encrypt this data using a key you own and
     * manage.
     * </p>
     * <p>
     * When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide
     * your studio user and admin roles access to these KMS keys.
     * </p>
     * <p>
     * If you delete this grant, the studio will no longer be accessible to your portal users.
     * </p>
     * <p>
     * If you delete the studio KMS key, your studio will no longer be accessible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStudioRequest#builder()}
     * </p>
     *
     * @param createStudioRequest
     *        A {@link Consumer} that will call methods on {@link CreateStudioRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStudioResponse> createStudio(Consumer<CreateStudioRequest.Builder> createStudioRequest) {
        return createStudio(CreateStudioRequest.builder().applyMutation(createStudioRequest).build());
    }

    /**
     * <p>
     * Creates a studio component resource.
     * </p>
     *
     * @param createStudioComponentRequest
     * @return A Java Future containing the result of the CreateStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStudioComponentResponse> createStudioComponent(
            CreateStudioComponentRequest createStudioComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a studio component resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioComponentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStudioComponentRequest#builder()}
     * </p>
     *
     * @param createStudioComponentRequest
     *        A {@link Consumer} that will call methods on {@link CreateStudioComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStudioComponentResponse> createStudioComponent(
            Consumer<CreateStudioComponentRequest.Builder> createStudioComponentRequest) {
        return createStudioComponent(CreateStudioComponentRequest.builder().applyMutation(createStudioComponentRequest).build());
    }

    /**
     * <p>
     * Permanently delete a launch profile.
     * </p>
     *
     * @param deleteLaunchProfileRequest
     * @return A Java Future containing the result of the DeleteLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchProfileResponse> deleteLaunchProfile(
            DeleteLaunchProfileRequest deleteLaunchProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently delete a launch profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLaunchProfileRequest#builder()}
     * </p>
     *
     * @param deleteLaunchProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchProfileResponse> deleteLaunchProfile(
            Consumer<DeleteLaunchProfileRequest.Builder> deleteLaunchProfileRequest) {
        return deleteLaunchProfile(DeleteLaunchProfileRequest.builder().applyMutation(deleteLaunchProfileRequest).build());
    }

    /**
     * <p>
     * Delete a user from launch profile membership.
     * </p>
     *
     * @param deleteLaunchProfileMemberRequest
     * @return A Java Future containing the result of the DeleteLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchProfileMemberResponse> deleteLaunchProfileMember(
            DeleteLaunchProfileMemberRequest deleteLaunchProfileMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a user from launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchProfileMemberRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLaunchProfileMemberRequest#builder()}
     * </p>
     *
     * @param deleteLaunchProfileMemberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchProfileMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchProfileMemberResponse> deleteLaunchProfileMember(
            Consumer<DeleteLaunchProfileMemberRequest.Builder> deleteLaunchProfileMemberRequest) {
        return deleteLaunchProfileMember(DeleteLaunchProfileMemberRequest.builder()
                .applyMutation(deleteLaunchProfileMemberRequest).build());
    }

    /**
     * <p>
     * Delete streaming image.
     * </p>
     *
     * @param deleteStreamingImageRequest
     * @return A Java Future containing the result of the DeleteStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingImageResponse> deleteStreamingImage(
            DeleteStreamingImageRequest deleteStreamingImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete streaming image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamingImageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStreamingImageRequest#builder()}
     * </p>
     *
     * @param deleteStreamingImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamingImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingImageResponse> deleteStreamingImage(
            Consumer<DeleteStreamingImageRequest.Builder> deleteStreamingImageRequest) {
        return deleteStreamingImage(DeleteStreamingImageRequest.builder().applyMutation(deleteStreamingImageRequest).build());
    }

    /**
     * <p>
     * Deletes streaming session resource.
     * </p>
     * <p>
     * After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a DELETED
     * state.
     * </p>
     * <p>
     * A streaming session will count against your streaming session quota until it is marked DELETED.
     * </p>
     *
     * @param deleteStreamingSessionRequest
     * @return A Java Future containing the result of the DeleteStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingSessionResponse> deleteStreamingSession(
            DeleteStreamingSessionRequest deleteStreamingSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes streaming session resource.
     * </p>
     * <p>
     * After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a DELETED
     * state.
     * </p>
     * <p>
     * A streaming session will count against your streaming session quota until it is marked DELETED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamingSessionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStreamingSessionRequest#builder()}
     * </p>
     *
     * @param deleteStreamingSessionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamingSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingSessionResponse> deleteStreamingSession(
            Consumer<DeleteStreamingSessionRequest.Builder> deleteStreamingSessionRequest) {
        return deleteStreamingSession(DeleteStreamingSessionRequest.builder().applyMutation(deleteStreamingSessionRequest)
                .build());
    }

    /**
     * <p>
     * Delete a studio resource.
     * </p>
     *
     * @param deleteStudioRequest
     * @return A Java Future containing the result of the DeleteStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStudioResponse> deleteStudio(DeleteStudioRequest deleteStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a studio resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStudioRequest#builder()}
     * </p>
     *
     * @param deleteStudioRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStudioResponse> deleteStudio(Consumer<DeleteStudioRequest.Builder> deleteStudioRequest) {
        return deleteStudio(DeleteStudioRequest.builder().applyMutation(deleteStudioRequest).build());
    }

    /**
     * <p>
     * Deletes a studio component resource.
     * </p>
     *
     * @param deleteStudioComponentRequest
     * @return A Java Future containing the result of the DeleteStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStudioComponentResponse> deleteStudioComponent(
            DeleteStudioComponentRequest deleteStudioComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a studio component resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioComponentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStudioComponentRequest#builder()}
     * </p>
     *
     * @param deleteStudioComponentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStudioComponentResponse> deleteStudioComponent(
            Consumer<DeleteStudioComponentRequest.Builder> deleteStudioComponentRequest) {
        return deleteStudioComponent(DeleteStudioComponentRequest.builder().applyMutation(deleteStudioComponentRequest).build());
    }

    /**
     * <p>
     * Delete a user from studio membership.
     * </p>
     *
     * @param deleteStudioMemberRequest
     * @return A Java Future containing the result of the DeleteStudioMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStudioMemberResponse> deleteStudioMember(DeleteStudioMemberRequest deleteStudioMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a user from studio membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioMemberRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStudioMemberRequest#builder()}
     * </p>
     *
     * @param deleteStudioMemberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStudioMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStudioMemberResponse> deleteStudioMember(
            Consumer<DeleteStudioMemberRequest.Builder> deleteStudioMemberRequest) {
        return deleteStudioMember(DeleteStudioMemberRequest.builder().applyMutation(deleteStudioMemberRequest).build());
    }

    /**
     * <p>
     * Get Eula.
     * </p>
     *
     * @param getEulaRequest
     * @return A Java Future containing the result of the GetEula operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetEula
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetEula" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEulaResponse> getEula(GetEulaRequest getEulaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get Eula.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEulaRequest.Builder} avoiding the need to create
     * one manually via {@link GetEulaRequest#builder()}
     * </p>
     *
     * @param getEulaRequest
     *        A {@link Consumer} that will call methods on {@link GetEulaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEula operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetEula
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetEula" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEulaResponse> getEula(Consumer<GetEulaRequest.Builder> getEulaRequest) {
        return getEula(GetEulaRequest.builder().applyMutation(getEulaRequest).build());
    }

    /**
     * <p>
     * Get a launch profile.
     * </p>
     *
     * @param getLaunchProfileRequest
     * @return A Java Future containing the result of the GetLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileResponse> getLaunchProfile(GetLaunchProfileRequest getLaunchProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a launch profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetLaunchProfileRequest#builder()}
     * </p>
     *
     * @param getLaunchProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileResponse> getLaunchProfile(
            Consumer<GetLaunchProfileRequest.Builder> getLaunchProfileRequest) {
        return getLaunchProfile(GetLaunchProfileRequest.builder().applyMutation(getLaunchProfileRequest).build());
    }

    /**
     * <p>
     * Launch profile details include the launch profile resource and summary information of resources that are used by,
     * or available to, the launch profile. This includes the name and description of all studio components used by the
     * launch profiles, and the name and description of streaming images that can be used with this launch profile.
     * </p>
     *
     * @param getLaunchProfileDetailsRequest
     * @return A Java Future containing the result of the GetLaunchProfileDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileDetailsResponse> getLaunchProfileDetails(
            GetLaunchProfileDetailsRequest getLaunchProfileDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launch profile details include the launch profile resource and summary information of resources that are used by,
     * or available to, the launch profile. This includes the name and description of all studio components used by the
     * launch profiles, and the name and description of streaming images that can be used with this launch profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchProfileDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetLaunchProfileDetailsRequest#builder()}
     * </p>
     *
     * @param getLaunchProfileDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchProfileDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLaunchProfileDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileDetailsResponse> getLaunchProfileDetails(
            Consumer<GetLaunchProfileDetailsRequest.Builder> getLaunchProfileDetailsRequest) {
        return getLaunchProfileDetails(GetLaunchProfileDetailsRequest.builder().applyMutation(getLaunchProfileDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Get a launch profile initialization.
     * </p>
     *
     * @param getLaunchProfileInitializationRequest
     * @return A Java Future containing the result of the GetLaunchProfileInitialization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileInitialization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileInitialization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileInitializationResponse> getLaunchProfileInitialization(
            GetLaunchProfileInitializationRequest getLaunchProfileInitializationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a launch profile initialization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchProfileInitializationRequest.Builder}
     * avoiding the need to create one manually via {@link GetLaunchProfileInitializationRequest#builder()}
     * </p>
     *
     * @param getLaunchProfileInitializationRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchProfileInitializationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLaunchProfileInitialization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileInitialization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileInitialization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileInitializationResponse> getLaunchProfileInitialization(
            Consumer<GetLaunchProfileInitializationRequest.Builder> getLaunchProfileInitializationRequest) {
        return getLaunchProfileInitialization(GetLaunchProfileInitializationRequest.builder()
                .applyMutation(getLaunchProfileInitializationRequest).build());
    }

    /**
     * <p>
     * Get a user persona in launch profile membership.
     * </p>
     *
     * @param getLaunchProfileMemberRequest
     * @return A Java Future containing the result of the GetLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileMemberResponse> getLaunchProfileMember(
            GetLaunchProfileMemberRequest getLaunchProfileMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a user persona in launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchProfileMemberRequest.Builder} avoiding the
     * need to create one manually via {@link GetLaunchProfileMemberRequest#builder()}
     * </p>
     *
     * @param getLaunchProfileMemberRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchProfileMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLaunchProfileMemberResponse> getLaunchProfileMember(
            Consumer<GetLaunchProfileMemberRequest.Builder> getLaunchProfileMemberRequest) {
        return getLaunchProfileMember(GetLaunchProfileMemberRequest.builder().applyMutation(getLaunchProfileMemberRequest)
                .build());
    }

    /**
     * <p>
     * Get streaming image.
     * </p>
     *
     * @param getStreamingImageRequest
     * @return A Java Future containing the result of the GetStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStreamingImageResponse> getStreamingImage(GetStreamingImageRequest getStreamingImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get streaming image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingImageRequest.Builder} avoiding the need
     * to create one manually via {@link GetStreamingImageRequest#builder()}
     * </p>
     *
     * @param getStreamingImageRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStreamingImageResponse> getStreamingImage(
            Consumer<GetStreamingImageRequest.Builder> getStreamingImageRequest) {
        return getStreamingImage(GetStreamingImageRequest.builder().applyMutation(getStreamingImageRequest).build());
    }

    /**
     * <p>
     * Gets StreamingSession resource.
     * </p>
     * <p>
     * anvoke this operation to poll for a streaming session state while creating or deleting a session.
     * </p>
     *
     * @param getStreamingSessionRequest
     * @return A Java Future containing the result of the GetStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStreamingSessionResponse> getStreamingSession(
            GetStreamingSessionRequest getStreamingSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets StreamingSession resource.
     * </p>
     * <p>
     * anvoke this operation to poll for a streaming session state while creating or deleting a session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingSessionRequest.Builder} avoiding the
     * need to create one manually via {@link GetStreamingSessionRequest#builder()}
     * </p>
     *
     * @param getStreamingSessionRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStreamingSessionResponse> getStreamingSession(
            Consumer<GetStreamingSessionRequest.Builder> getStreamingSessionRequest) {
        return getStreamingSession(GetStreamingSessionRequest.builder().applyMutation(getStreamingSessionRequest).build());
    }

    /**
     * <p>
     * Gets a StreamingSessionStream for a streaming session.
     * </p>
     * <p>
     * Invoke this operation to poll the resource after invoking CreateStreamingSessionStream.
     * </p>
     * <p>
     * After the StreamingSessionStream changes to the state READY, the url property will contain a stream to be used
     * with the DCV streaming client.
     * </p>
     *
     * @param getStreamingSessionStreamRequest
     * @return A Java Future containing the result of the GetStreamingSessionStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingSessionStreamResponse> getStreamingSessionStream(
            GetStreamingSessionStreamRequest getStreamingSessionStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a StreamingSessionStream for a streaming session.
     * </p>
     * <p>
     * Invoke this operation to poll the resource after invoking CreateStreamingSessionStream.
     * </p>
     * <p>
     * After the StreamingSessionStream changes to the state READY, the url property will contain a stream to be used
     * with the DCV streaming client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingSessionStreamRequest.Builder} avoiding
     * the need to create one manually via {@link GetStreamingSessionStreamRequest#builder()}
     * </p>
     *
     * @param getStreamingSessionStreamRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingSessionStreamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStreamingSessionStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingSessionStreamResponse> getStreamingSessionStream(
            Consumer<GetStreamingSessionStreamRequest.Builder> getStreamingSessionStreamRequest) {
        return getStreamingSessionStream(GetStreamingSessionStreamRequest.builder()
                .applyMutation(getStreamingSessionStreamRequest).build());
    }

    /**
     * <p>
     * Get a Studio resource.
     * </p>
     *
     * @param getStudioRequest
     * @return A Java Future containing the result of the GetStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStudioResponse> getStudio(GetStudioRequest getStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a Studio resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStudioRequest.Builder} avoiding the need to
     * create one manually via {@link GetStudioRequest#builder()}
     * </p>
     *
     * @param getStudioRequest
     *        A {@link Consumer} that will call methods on {@link GetStudioRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStudioResponse> getStudio(Consumer<GetStudioRequest.Builder> getStudioRequest) {
        return getStudio(GetStudioRequest.builder().applyMutation(getStudioRequest).build());
    }

    /**
     * <p>
     * Gets a studio component resource.
     * </p>
     *
     * @param getStudioComponentRequest
     * @return A Java Future containing the result of the GetStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStudioComponentResponse> getStudioComponent(GetStudioComponentRequest getStudioComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a studio component resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStudioComponentRequest.Builder} avoiding the
     * need to create one manually via {@link GetStudioComponentRequest#builder()}
     * </p>
     *
     * @param getStudioComponentRequest
     *        A {@link Consumer} that will call methods on {@link GetStudioComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStudioComponentResponse> getStudioComponent(
            Consumer<GetStudioComponentRequest.Builder> getStudioComponentRequest) {
        return getStudioComponent(GetStudioComponentRequest.builder().applyMutation(getStudioComponentRequest).build());
    }

    /**
     * <p>
     * Get a user's membership in a studio.
     * </p>
     *
     * @param getStudioMemberRequest
     * @return A Java Future containing the result of the GetStudioMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStudioMemberResponse> getStudioMember(GetStudioMemberRequest getStudioMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a user's membership in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStudioMemberRequest.Builder} avoiding the need
     * to create one manually via {@link GetStudioMemberRequest#builder()}
     * </p>
     *
     * @param getStudioMemberRequest
     *        A {@link Consumer} that will call methods on {@link GetStudioMemberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStudioMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStudioMemberResponse> getStudioMember(
            Consumer<GetStudioMemberRequest.Builder> getStudioMemberRequest) {
        return getStudioMember(GetStudioMemberRequest.builder().applyMutation(getStudioMemberRequest).build());
    }

    /**
     * <p>
     * List Eula Acceptances.
     * </p>
     *
     * @param listEulaAcceptancesRequest
     * @return A Java Future containing the result of the ListEulaAcceptances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEulaAcceptancesResponse> listEulaAcceptances(
            ListEulaAcceptancesRequest listEulaAcceptancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Eula Acceptances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEulaAcceptancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEulaAcceptancesRequest#builder()}
     * </p>
     *
     * @param listEulaAcceptancesRequest
     *        A {@link Consumer} that will call methods on {@link ListEulaAcceptancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEulaAcceptances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEulaAcceptancesResponse> listEulaAcceptances(
            Consumer<ListEulaAcceptancesRequest.Builder> listEulaAcceptancesRequest) {
        return listEulaAcceptances(ListEulaAcceptancesRequest.builder().applyMutation(listEulaAcceptancesRequest).build());
    }

    /**
     * <p>
     * List Eula Acceptances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEulaAcceptances(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher publisher = client.listEulaAcceptancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher publisher = client.listEulaAcceptancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEulaAcceptances(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEulaAcceptancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEulaAcceptancesPublisher listEulaAcceptancesPaginator(ListEulaAcceptancesRequest listEulaAcceptancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Eula Acceptances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEulaAcceptances(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher publisher = client.listEulaAcceptancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher publisher = client.listEulaAcceptancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEulaAcceptances(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEulaAcceptancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEulaAcceptancesRequest#builder()}
     * </p>
     *
     * @param listEulaAcceptancesRequest
     *        A {@link Consumer} that will call methods on {@link ListEulaAcceptancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEulaAcceptancesPublisher listEulaAcceptancesPaginator(
            Consumer<ListEulaAcceptancesRequest.Builder> listEulaAcceptancesRequest) {
        return listEulaAcceptancesPaginator(ListEulaAcceptancesRequest.builder().applyMutation(listEulaAcceptancesRequest)
                .build());
    }

    /**
     * <p>
     * List Eulas.
     * </p>
     *
     * @param listEulasRequest
     * @return A Java Future containing the result of the ListEulas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEulasResponse> listEulas(ListEulasRequest listEulasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Eulas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEulasRequest.Builder} avoiding the need to
     * create one manually via {@link ListEulasRequest#builder()}
     * </p>
     *
     * @param listEulasRequest
     *        A {@link Consumer} that will call methods on {@link ListEulasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEulas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEulasResponse> listEulas(Consumer<ListEulasRequest.Builder> listEulasRequest) {
        return listEulas(ListEulasRequest.builder().applyMutation(listEulasRequest).build());
    }

    /**
     * <p>
     * List Eulas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEulas(software.amazon.awssdk.services.nimble.model.ListEulasRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher publisher = client.listEulasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher publisher = client.listEulasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListEulasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListEulasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEulas(software.amazon.awssdk.services.nimble.model.ListEulasRequest)} operation.</b>
     * </p>
     *
     * @param listEulasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEulasPublisher listEulasPaginator(ListEulasRequest listEulasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Eulas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEulas(software.amazon.awssdk.services.nimble.model.ListEulasRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher publisher = client.listEulasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher publisher = client.listEulasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListEulasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListEulasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEulas(software.amazon.awssdk.services.nimble.model.ListEulasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEulasRequest.Builder} avoiding the need to
     * create one manually via {@link ListEulasRequest#builder()}
     * </p>
     *
     * @param listEulasRequest
     *        A {@link Consumer} that will call methods on {@link ListEulasRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEulasPublisher listEulasPaginator(Consumer<ListEulasRequest.Builder> listEulasRequest) {
        return listEulasPaginator(ListEulasRequest.builder().applyMutation(listEulasRequest).build());
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     * @return A Java Future containing the result of the ListLaunchProfileMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLaunchProfileMembersResponse> listLaunchProfileMembers(
            ListLaunchProfileMembersRequest listLaunchProfileMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchProfileMembersRequest.Builder} avoiding
     * the need to create one manually via {@link ListLaunchProfileMembersRequest#builder()}
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchProfileMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLaunchProfileMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLaunchProfileMembersResponse> listLaunchProfileMembers(
            Consumer<ListLaunchProfileMembersRequest.Builder> listLaunchProfileMembersRequest) {
        return listLaunchProfileMembers(ListLaunchProfileMembersRequest.builder().applyMutation(listLaunchProfileMembersRequest)
                .build());
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchProfileMembers(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher publisher = client.listLaunchProfileMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher publisher = client.listLaunchProfileMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchProfileMembers(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchProfileMembersPublisher listLaunchProfileMembersPaginator(
            ListLaunchProfileMembersRequest listLaunchProfileMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchProfileMembers(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher publisher = client.listLaunchProfileMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher publisher = client.listLaunchProfileMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchProfileMembers(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchProfileMembersRequest.Builder} avoiding
     * the need to create one manually via {@link ListLaunchProfileMembersRequest#builder()}
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchProfileMembersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchProfileMembersPublisher listLaunchProfileMembersPaginator(
            Consumer<ListLaunchProfileMembersRequest.Builder> listLaunchProfileMembersRequest) {
        return listLaunchProfileMembersPaginator(ListLaunchProfileMembersRequest.builder()
                .applyMutation(listLaunchProfileMembersRequest).build());
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     *
     * @param listLaunchProfilesRequest
     * @return A Java Future containing the result of the ListLaunchProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLaunchProfilesResponse> listLaunchProfiles(ListLaunchProfilesRequest listLaunchProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListLaunchProfilesRequest#builder()}
     * </p>
     *
     * @param listLaunchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLaunchProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLaunchProfilesResponse> listLaunchProfiles(
            Consumer<ListLaunchProfilesRequest.Builder> listLaunchProfilesRequest) {
        return listLaunchProfiles(ListLaunchProfilesRequest.builder().applyMutation(listLaunchProfilesRequest).build());
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchProfiles(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher publisher = client.listLaunchProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher publisher = client.listLaunchProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchProfiles(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLaunchProfilesPublisher listLaunchProfilesPaginator(ListLaunchProfilesRequest listLaunchProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchProfiles(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher publisher = client.listLaunchProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher publisher = client.listLaunchProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchProfiles(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListLaunchProfilesRequest#builder()}
     * </p>
     *
     * @param listLaunchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLaunchProfilesPublisher listLaunchProfilesPaginator(
            Consumer<ListLaunchProfilesRequest.Builder> listLaunchProfilesRequest) {
        return listLaunchProfilesPaginator(ListLaunchProfilesRequest.builder().applyMutation(listLaunchProfilesRequest).build());
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     *
     * @param listStreamingImagesRequest
     * @return A Java Future containing the result of the ListStreamingImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStreamingImagesResponse> listStreamingImages(
            ListStreamingImagesRequest listStreamingImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingImagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamingImagesRequest#builder()}
     * </p>
     *
     * @param listStreamingImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingImagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStreamingImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStreamingImagesResponse> listStreamingImages(
            Consumer<ListStreamingImagesRequest.Builder> listStreamingImagesRequest) {
        return listStreamingImages(ListStreamingImagesRequest.builder().applyMutation(listStreamingImagesRequest).build());
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamingImages(software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher publisher = client.listStreamingImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher publisher = client.listStreamingImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingImages(software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamingImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamingImagesPublisher listStreamingImagesPaginator(ListStreamingImagesRequest listStreamingImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamingImages(software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher publisher = client.listStreamingImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher publisher = client.listStreamingImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingImages(software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingImagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamingImagesRequest#builder()}
     * </p>
     *
     * @param listStreamingImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingImagesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamingImagesPublisher listStreamingImagesPaginator(
            Consumer<ListStreamingImagesRequest.Builder> listStreamingImagesRequest) {
        return listStreamingImagesPaginator(ListStreamingImagesRequest.builder().applyMutation(listStreamingImagesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the streaming image resources in a studio.
     * </p>
     *
     * @param listStreamingSessionsRequest
     * @return A Java Future containing the result of the ListStreamingSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStreamingSessionsResponse> listStreamingSessions(
            ListStreamingSessionsRequest listStreamingSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the streaming image resources in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamingSessionsRequest#builder()}
     * </p>
     *
     * @param listStreamingSessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStreamingSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStreamingSessionsResponse> listStreamingSessions(
            Consumer<ListStreamingSessionsRequest.Builder> listStreamingSessionsRequest) {
        return listStreamingSessions(ListStreamingSessionsRequest.builder().applyMutation(listStreamingSessionsRequest).build());
    }

    /**
     * <p>
     * Lists the streaming image resources in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamingSessions(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher publisher = client.listStreamingSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher publisher = client.listStreamingSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingSessions(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamingSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamingSessionsPublisher listStreamingSessionsPaginator(
            ListStreamingSessionsRequest listStreamingSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the streaming image resources in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamingSessions(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher publisher = client.listStreamingSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher publisher = client.listStreamingSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingSessions(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamingSessionsRequest#builder()}
     * </p>
     *
     * @param listStreamingSessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamingSessionsPublisher listStreamingSessionsPaginator(
            Consumer<ListStreamingSessionsRequest.Builder> listStreamingSessionsRequest) {
        return listStreamingSessionsPaginator(ListStreamingSessionsRequest.builder().applyMutation(listStreamingSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the StudioComponents in a studio.
     * </p>
     *
     * @param listStudioComponentsRequest
     * @return A Java Future containing the result of the ListStudioComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStudioComponentsResponse> listStudioComponents(
            ListStudioComponentsRequest listStudioComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the StudioComponents in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioComponentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStudioComponentsRequest#builder()}
     * </p>
     *
     * @param listStudioComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioComponentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStudioComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStudioComponentsResponse> listStudioComponents(
            Consumer<ListStudioComponentsRequest.Builder> listStudioComponentsRequest) {
        return listStudioComponents(ListStudioComponentsRequest.builder().applyMutation(listStudioComponentsRequest).build());
    }

    /**
     * <p>
     * Lists the StudioComponents in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioComponents(software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher publisher = client.listStudioComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher publisher = client.listStudioComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioComponents(software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStudioComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudioComponentsPublisher listStudioComponentsPaginator(ListStudioComponentsRequest listStudioComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the StudioComponents in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioComponents(software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher publisher = client.listStudioComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher publisher = client.listStudioComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioComponents(software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioComponentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStudioComponentsRequest#builder()}
     * </p>
     *
     * @param listStudioComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioComponentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudioComponentsPublisher listStudioComponentsPaginator(
            Consumer<ListStudioComponentsRequest.Builder> listStudioComponentsRequest) {
        return listStudioComponentsPaginator(ListStudioComponentsRequest.builder().applyMutation(listStudioComponentsRequest)
                .build());
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note>
     *
     * @param listStudioMembersRequest
     * @return A Java Future containing the result of the ListStudioMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStudioMembersResponse> listStudioMembers(ListStudioMembersRequest listStudioMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListStudioMembersRequest#builder()}
     * </p>
     *
     * @param listStudioMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStudioMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStudioMembersResponse> listStudioMembers(
            Consumer<ListStudioMembersRequest.Builder> listStudioMembersRequest) {
        return listStudioMembers(ListStudioMembersRequest.builder().applyMutation(listStudioMembersRequest).build());
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listStudioMembers(software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher publisher = client.listStudioMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher publisher = client.listStudioMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioMembers(software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest)} operation.</b>
     * </p>
     *
     * @param listStudioMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStudioMembersPublisher listStudioMembersPaginator(ListStudioMembersRequest listStudioMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listStudioMembers(software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher publisher = client.listStudioMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher publisher = client.listStudioMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioMembers(software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListStudioMembersRequest#builder()}
     * </p>
     *
     * @param listStudioMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStudioMembersPublisher listStudioMembersPaginator(
            Consumer<ListStudioMembersRequest.Builder> listStudioMembersRequest) {
        return listStudioMembersPaginator(ListStudioMembersRequest.builder().applyMutation(listStudioMembersRequest).build());
    }

    /**
     * <p>
     * List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
     * </p>
     *
     * @param listStudiosRequest
     * @return A Java Future containing the result of the ListStudios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStudiosResponse> listStudios(ListStudiosRequest listStudiosRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudiosRequest.Builder} avoiding the need to
     * create one manually via {@link ListStudiosRequest#builder()}
     * </p>
     *
     * @param listStudiosRequest
     *        A {@link Consumer} that will call methods on {@link ListStudiosRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStudios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStudiosResponse> listStudios(Consumer<ListStudiosRequest.Builder> listStudiosRequest) {
        return listStudios(ListStudiosRequest.builder().applyMutation(listStudiosRequest).build());
    }

    /**
     * <p>
     * List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.nimble.model.ListStudiosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudiosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudiosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.nimble.model.ListStudiosRequest)} operation.</b>
     * </p>
     *
     * @param listStudiosRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStudiosPublisher listStudiosPaginator(ListStudiosRequest listStudiosRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.nimble.model.ListStudiosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudiosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudiosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.nimble.model.ListStudiosRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudiosRequest.Builder} avoiding the need to
     * create one manually via {@link ListStudiosRequest#builder()}
     * </p>
     *
     * @param listStudiosRequest
     *        A {@link Consumer} that will call methods on {@link ListStudiosRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStudiosPublisher listStudiosPaginator(Consumer<ListStudiosRequest.Builder> listStudiosRequest) {
        return listStudiosPaginator(ListStudiosRequest.builder().applyMutation(listStudiosRequest).build());
    }

    /**
     * <p>
     * Gets the tags for a resource, given its Amazon Resource Names (ARN).
     * </p>
     * <p>
     * This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio
     * component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain
     * an ARN property, so you do not have to create this ARN yourself.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the tags for a resource, given its Amazon Resource Names (ARN).
     * </p>
     * <p>
     * This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio
     * component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain
     * an ARN property, so you do not have to create this ARN yourself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Add/update users with given persona to launch profile membership.
     * </p>
     *
     * @param putLaunchProfileMembersRequest
     * @return A Java Future containing the result of the PutLaunchProfileMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.PutLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLaunchProfileMembersResponse> putLaunchProfileMembers(
            PutLaunchProfileMembersRequest putLaunchProfileMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add/update users with given persona to launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLaunchProfileMembersRequest.Builder} avoiding
     * the need to create one manually via {@link PutLaunchProfileMembersRequest#builder()}
     * </p>
     *
     * @param putLaunchProfileMembersRequest
     *        A {@link Consumer} that will call methods on {@link PutLaunchProfileMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLaunchProfileMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.PutLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLaunchProfileMembersResponse> putLaunchProfileMembers(
            Consumer<PutLaunchProfileMembersRequest.Builder> putLaunchProfileMembersRequest) {
        return putLaunchProfileMembers(PutLaunchProfileMembersRequest.builder().applyMutation(putLaunchProfileMembersRequest)
                .build());
    }

    /**
     * <p>
     * Add/update users with given persona to studio membership.
     * </p>
     *
     * @param putStudioMembersRequest
     * @return A Java Future containing the result of the PutStudioMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.PutStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutStudioMembersResponse> putStudioMembers(PutStudioMembersRequest putStudioMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add/update users with given persona to studio membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutStudioMembersRequest.Builder} avoiding the need
     * to create one manually via {@link PutStudioMembersRequest#builder()}
     * </p>
     *
     * @param putStudioMembersRequest
     *        A {@link Consumer} that will call methods on {@link PutStudioMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutStudioMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.PutStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutStudioMembersResponse> putStudioMembers(
            Consumer<PutStudioMembersRequest.Builder> putStudioMembersRequest) {
        return putStudioMembers(PutStudioMembersRequest.builder().applyMutation(putStudioMembersRequest).build());
    }

    /**
     * <p>
     * Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS state is the intermediate
     * state between the STOPPED and READY states.
     * </p>
     *
     * @param startStreamingSessionRequest
     * @return A Java Future containing the result of the StartStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StartStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartStreamingSessionResponse> startStreamingSession(
            StartStreamingSessionRequest startStreamingSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS state is the intermediate
     * state between the STOPPED and READY states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStreamingSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StartStreamingSessionRequest#builder()}
     * </p>
     *
     * @param startStreamingSessionRequest
     *        A {@link Consumer} that will call methods on {@link StartStreamingSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StartStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartStreamingSessionResponse> startStreamingSession(
            Consumer<StartStreamingSessionRequest.Builder> startStreamingSessionRequest) {
        return startStreamingSession(StartStreamingSessionRequest.builder().applyMutation(startStreamingSessionRequest).build());
    }

    /**
     * <p>
     * Repairs the Amazon Web Services SSO configuration for a given studio.
     * </p>
     * <p>
     * If the studio has a valid Amazon Web Services SSO configuration currently associated with it, this operation will
     * fail with a validation error.
     * </p>
     * <p>
     * If the studio does not have a valid Amazon Web Services SSO configuration currently associated with it, then a
     * new Amazon Web Services SSO application is created for the studio and the studio is changed to the READY state.
     * </p>
     * <p>
     * After the Amazon Web Services SSO application is repaired, you must use the Amazon Nimble Studio console to add
     * administrators and users to your studio.
     * </p>
     *
     * @param startStudioSsoConfigurationRepairRequest
     * @return A Java Future containing the result of the StartStudioSSOConfigurationRepair operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StartStudioSSOConfigurationRepair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStudioSSOConfigurationRepair"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartStudioSsoConfigurationRepairResponse> startStudioSSOConfigurationRepair(
            StartStudioSsoConfigurationRepairRequest startStudioSsoConfigurationRepairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Repairs the Amazon Web Services SSO configuration for a given studio.
     * </p>
     * <p>
     * If the studio has a valid Amazon Web Services SSO configuration currently associated with it, this operation will
     * fail with a validation error.
     * </p>
     * <p>
     * If the studio does not have a valid Amazon Web Services SSO configuration currently associated with it, then a
     * new Amazon Web Services SSO application is created for the studio and the studio is changed to the READY state.
     * </p>
     * <p>
     * After the Amazon Web Services SSO application is repaired, you must use the Amazon Nimble Studio console to add
     * administrators and users to your studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStudioSsoConfigurationRepairRequest.Builder}
     * avoiding the need to create one manually via {@link StartStudioSsoConfigurationRepairRequest#builder()}
     * </p>
     *
     * @param startStudioSsoConfigurationRepairRequest
     *        A {@link Consumer} that will call methods on {@link StartStudioSSOConfigurationRepairRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartStudioSSOConfigurationRepair operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StartStudioSSOConfigurationRepair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStudioSSOConfigurationRepair"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartStudioSsoConfigurationRepairResponse> startStudioSSOConfigurationRepair(
            Consumer<StartStudioSsoConfigurationRepairRequest.Builder> startStudioSsoConfigurationRepairRequest) {
        return startStudioSSOConfigurationRepair(StartStudioSsoConfigurationRepairRequest.builder()
                .applyMutation(startStudioSsoConfigurationRepairRequest).build());
    }

    /**
     * <p>
     * Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS state is the intermediate
     * state between the READY and STOPPED states.
     * </p>
     *
     * @param stopStreamingSessionRequest
     * @return A Java Future containing the result of the StopStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StopStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StopStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopStreamingSessionResponse> stopStreamingSession(
            StopStreamingSessionRequest stopStreamingSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS state is the intermediate
     * state between the READY and STOPPED states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStreamingSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StopStreamingSessionRequest#builder()}
     * </p>
     *
     * @param stopStreamingSessionRequest
     *        A {@link Consumer} that will call methods on {@link StopStreamingSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StopStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StopStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopStreamingSessionResponse> stopStreamingSession(
            Consumer<StopStreamingSessionRequest.Builder> stopStreamingSessionRequest) {
        return stopStreamingSession(StopStreamingSessionRequest.builder().applyMutation(stopStreamingSessionRequest).build());
    }

    /**
     * <p>
     * Creates tags for a resource, given its ARN.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates tags for a resource, given its ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the tags for a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update a launch profile.
     * </p>
     *
     * @param updateLaunchProfileRequest
     * @return A Java Future containing the result of the UpdateLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchProfileResponse> updateLaunchProfile(
            UpdateLaunchProfileRequest updateLaunchProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a launch profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLaunchProfileRequest#builder()}
     * </p>
     *
     * @param updateLaunchProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchProfileResponse> updateLaunchProfile(
            Consumer<UpdateLaunchProfileRequest.Builder> updateLaunchProfileRequest) {
        return updateLaunchProfile(UpdateLaunchProfileRequest.builder().applyMutation(updateLaunchProfileRequest).build());
    }

    /**
     * <p>
     * Update a user persona in launch profile membership.
     * </p>
     *
     * @param updateLaunchProfileMemberRequest
     * @return A Java Future containing the result of the UpdateLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchProfileMemberResponse> updateLaunchProfileMember(
            UpdateLaunchProfileMemberRequest updateLaunchProfileMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a user persona in launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchProfileMemberRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLaunchProfileMemberRequest#builder()}
     * </p>
     *
     * @param updateLaunchProfileMemberRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchProfileMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchProfileMemberResponse> updateLaunchProfileMember(
            Consumer<UpdateLaunchProfileMemberRequest.Builder> updateLaunchProfileMemberRequest) {
        return updateLaunchProfileMember(UpdateLaunchProfileMemberRequest.builder()
                .applyMutation(updateLaunchProfileMemberRequest).build());
    }

    /**
     * <p>
     * Update streaming image.
     * </p>
     *
     * @param updateStreamingImageRequest
     * @return A Java Future containing the result of the UpdateStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStreamingImageResponse> updateStreamingImage(
            UpdateStreamingImageRequest updateStreamingImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update streaming image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStreamingImageRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStreamingImageRequest#builder()}
     * </p>
     *
     * @param updateStreamingImageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStreamingImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStreamingImageResponse> updateStreamingImage(
            Consumer<UpdateStreamingImageRequest.Builder> updateStreamingImageRequest) {
        return updateStreamingImage(UpdateStreamingImageRequest.builder().applyMutation(updateStreamingImageRequest).build());
    }

    /**
     * <p>
     * Update a Studio resource.
     * </p>
     * <p>
     * Currently, this operation only supports updating the displayName of your studio.
     * </p>
     *
     * @param updateStudioRequest
     * @return A Java Future containing the result of the UpdateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStudioResponse> updateStudio(UpdateStudioRequest updateStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a Studio resource.
     * </p>
     * <p>
     * Currently, this operation only supports updating the displayName of your studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStudioRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStudioRequest#builder()}
     * </p>
     *
     * @param updateStudioRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStudioRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStudioResponse> updateStudio(Consumer<UpdateStudioRequest.Builder> updateStudioRequest) {
        return updateStudio(UpdateStudioRequest.builder().applyMutation(updateStudioRequest).build());
    }

    /**
     * <p>
     * Updates a studio component resource.
     * </p>
     *
     * @param updateStudioComponentRequest
     * @return A Java Future containing the result of the UpdateStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStudioComponentResponse> updateStudioComponent(
            UpdateStudioComponentRequest updateStudioComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a studio component resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStudioComponentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStudioComponentRequest#builder()}
     * </p>
     *
     * @param updateStudioComponentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStudioComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStudioComponentResponse> updateStudioComponent(
            Consumer<UpdateStudioComponentRequest.Builder> updateStudioComponentRequest) {
        return updateStudioComponent(UpdateStudioComponentRequest.builder().applyMutation(updateStudioComponentRequest).build());
    }

    /**
     * Create an instance of {@link NimbleAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link NimbleAsyncWaiter}
     */
    default NimbleAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
