/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchProfileDetailsResponse extends NimbleResponse implements
        ToCopyableBuilder<GetLaunchProfileDetailsResponse.Builder, GetLaunchProfileDetailsResponse> {
    private static final SdkField<LaunchProfile> LAUNCH_PROFILE_FIELD = SdkField
            .<LaunchProfile> builder(MarshallingType.SDK_POJO).memberName("launchProfile")
            .getter(getter(GetLaunchProfileDetailsResponse::launchProfile)).setter(setter(Builder::launchProfile))
            .constructor(LaunchProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfile").build()).build();

    private static final SdkField<List<StreamingImage>> STREAMING_IMAGES_FIELD = SdkField
            .<List<StreamingImage>> builder(MarshallingType.LIST)
            .memberName("streamingImages")
            .getter(getter(GetLaunchProfileDetailsResponse::streamingImages))
            .setter(setter(Builder::streamingImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamingImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamingImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StudioComponentSummary>> STUDIO_COMPONENT_SUMMARIES_FIELD = SdkField
            .<List<StudioComponentSummary>> builder(MarshallingType.LIST)
            .memberName("studioComponentSummaries")
            .getter(getter(GetLaunchProfileDetailsResponse::studioComponentSummaries))
            .setter(setter(Builder::studioComponentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StudioComponentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StudioComponentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PROFILE_FIELD,
            STREAMING_IMAGES_FIELD, STUDIO_COMPONENT_SUMMARIES_FIELD));

    private final LaunchProfile launchProfile;

    private final List<StreamingImage> streamingImages;

    private final List<StudioComponentSummary> studioComponentSummaries;

    private GetLaunchProfileDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.launchProfile = builder.launchProfile;
        this.streamingImages = builder.streamingImages;
        this.studioComponentSummaries = builder.studioComponentSummaries;
    }

    /**
     * <p>
     * The launch profile.
     * </p>
     * 
     * @return The launch profile.
     */
    public final LaunchProfile launchProfile() {
        return launchProfile;
    }

    /**
     * For responses, this returns true if the service returned a value for the StreamingImages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStreamingImages() {
        return streamingImages != null && !(streamingImages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of streaming images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreamingImages} method.
     * </p>
     * 
     * @return A collection of streaming images.
     */
    public final List<StreamingImage> streamingImages() {
        return streamingImages;
    }

    /**
     * For responses, this returns true if the service returned a value for the StudioComponentSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStudioComponentSummaries() {
        return studioComponentSummaries != null && !(studioComponentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of studio component summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStudioComponentSummaries} method.
     * </p>
     * 
     * @return A collection of studio component summaries.
     */
    public final List<StudioComponentSummary> studioComponentSummaries() {
        return studioComponentSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchProfile());
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamingImages() ? streamingImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStudioComponentSummaries() ? studioComponentSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchProfileDetailsResponse)) {
            return false;
        }
        GetLaunchProfileDetailsResponse other = (GetLaunchProfileDetailsResponse) obj;
        return Objects.equals(launchProfile(), other.launchProfile()) && hasStreamingImages() == other.hasStreamingImages()
                && Objects.equals(streamingImages(), other.streamingImages())
                && hasStudioComponentSummaries() == other.hasStudioComponentSummaries()
                && Objects.equals(studioComponentSummaries(), other.studioComponentSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLaunchProfileDetailsResponse").add("LaunchProfile", launchProfile())
                .add("StreamingImages", hasStreamingImages() ? streamingImages() : null)
                .add("StudioComponentSummaries", hasStudioComponentSummaries() ? studioComponentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchProfile":
            return Optional.ofNullable(clazz.cast(launchProfile()));
        case "streamingImages":
            return Optional.ofNullable(clazz.cast(streamingImages()));
        case "studioComponentSummaries":
            return Optional.ofNullable(clazz.cast(studioComponentSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchProfileDetailsResponse, T> g) {
        return obj -> g.apply((GetLaunchProfileDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLaunchProfileDetailsResponse> {
        /**
         * <p>
         * The launch profile.
         * </p>
         * 
         * @param launchProfile
         *        The launch profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfile(LaunchProfile launchProfile);

        /**
         * <p>
         * The launch profile.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchProfile.Builder} avoiding the need to
         * create one manually via {@link LaunchProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #launchProfile(LaunchProfile)}.
         * 
         * @param launchProfile
         *        a consumer that will call methods on {@link LaunchProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchProfile(LaunchProfile)
         */
        default Builder launchProfile(Consumer<LaunchProfile.Builder> launchProfile) {
            return launchProfile(LaunchProfile.builder().applyMutation(launchProfile).build());
        }

        /**
         * <p>
         * A collection of streaming images.
         * </p>
         * 
         * @param streamingImages
         *        A collection of streaming images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImages(Collection<StreamingImage> streamingImages);

        /**
         * <p>
         * A collection of streaming images.
         * </p>
         * 
         * @param streamingImages
         *        A collection of streaming images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImages(StreamingImage... streamingImages);

        /**
         * <p>
         * A collection of streaming images.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StreamingImage>.Builder} avoiding the need
         * to create one manually via {@link List<StreamingImage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamingImage>.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingImages(List<StreamingImage>)}.
         * 
         * @param streamingImages
         *        a consumer that will call methods on {@link List<StreamingImage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingImages(List<StreamingImage>)
         */
        Builder streamingImages(Consumer<StreamingImage.Builder>... streamingImages);

        /**
         * <p>
         * A collection of studio component summaries.
         * </p>
         * 
         * @param studioComponentSummaries
         *        A collection of studio component summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentSummaries(Collection<StudioComponentSummary> studioComponentSummaries);

        /**
         * <p>
         * A collection of studio component summaries.
         * </p>
         * 
         * @param studioComponentSummaries
         *        A collection of studio component summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentSummaries(StudioComponentSummary... studioComponentSummaries);

        /**
         * <p>
         * A collection of studio component summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StudioComponentSummary>.Builder} avoiding
         * the need to create one manually via {@link List<StudioComponentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StudioComponentSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #studioComponentSummaries(List<StudioComponentSummary>)}.
         * 
         * @param studioComponentSummaries
         *        a consumer that will call methods on {@link List<StudioComponentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studioComponentSummaries(List<StudioComponentSummary>)
         */
        Builder studioComponentSummaries(Consumer<StudioComponentSummary.Builder>... studioComponentSummaries);
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private LaunchProfile launchProfile;

        private List<StreamingImage> streamingImages = DefaultSdkAutoConstructList.getInstance();

        private List<StudioComponentSummary> studioComponentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchProfileDetailsResponse model) {
            super(model);
            launchProfile(model.launchProfile);
            streamingImages(model.streamingImages);
            studioComponentSummaries(model.studioComponentSummaries);
        }

        public final LaunchProfile.Builder getLaunchProfile() {
            return launchProfile != null ? launchProfile.toBuilder() : null;
        }

        public final void setLaunchProfile(LaunchProfile.BuilderImpl launchProfile) {
            this.launchProfile = launchProfile != null ? launchProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder launchProfile(LaunchProfile launchProfile) {
            this.launchProfile = launchProfile;
            return this;
        }

        public final List<StreamingImage.Builder> getStreamingImages() {
            List<StreamingImage.Builder> result = StreamingImageListCopier.copyToBuilder(this.streamingImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingImages(Collection<StreamingImage.BuilderImpl> streamingImages) {
            this.streamingImages = StreamingImageListCopier.copyFromBuilder(streamingImages);
        }

        @Override
        @Transient
        public final Builder streamingImages(Collection<StreamingImage> streamingImages) {
            this.streamingImages = StreamingImageListCopier.copy(streamingImages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamingImages(StreamingImage... streamingImages) {
            streamingImages(Arrays.asList(streamingImages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamingImages(Consumer<StreamingImage.Builder>... streamingImages) {
            streamingImages(Stream.of(streamingImages).map(c -> StreamingImage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StudioComponentSummary.Builder> getStudioComponentSummaries() {
            List<StudioComponentSummary.Builder> result = StudioComponentSummaryListCopier
                    .copyToBuilder(this.studioComponentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudioComponentSummaries(Collection<StudioComponentSummary.BuilderImpl> studioComponentSummaries) {
            this.studioComponentSummaries = StudioComponentSummaryListCopier.copyFromBuilder(studioComponentSummaries);
        }

        @Override
        @Transient
        public final Builder studioComponentSummaries(Collection<StudioComponentSummary> studioComponentSummaries) {
            this.studioComponentSummaries = StudioComponentSummaryListCopier.copy(studioComponentSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponentSummaries(StudioComponentSummary... studioComponentSummaries) {
            studioComponentSummaries(Arrays.asList(studioComponentSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponentSummaries(Consumer<StudioComponentSummary.Builder>... studioComponentSummaries) {
            studioComponentSummaries(Stream.of(studioComponentSummaries)
                    .map(c -> StudioComponentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLaunchProfileDetailsResponse build() {
            return new GetLaunchProfileDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
