/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopStreamingSessionResponse extends NimbleResponse implements
        ToCopyableBuilder<StopStreamingSessionResponse.Builder, StopStreamingSessionResponse> {
    private static final SdkField<StreamingSession> SESSION_FIELD = SdkField.<StreamingSession> builder(MarshallingType.SDK_POJO)
            .memberName("session").getter(getter(StopStreamingSessionResponse::session)).setter(setter(Builder::session))
            .constructor(StreamingSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("session").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_FIELD));

    private final StreamingSession session;

    private StopStreamingSessionResponse(BuilderImpl builder) {
        super(builder);
        this.session = builder.session;
    }

    /**
     * Returns the value of the Session property for this object.
     * 
     * @return The value of the Session property for this object.
     */
    public final StreamingSession session() {
        return session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(session());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStreamingSessionResponse)) {
            return false;
        }
        StopStreamingSessionResponse other = (StopStreamingSessionResponse) obj;
        return Objects.equals(session(), other.session());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopStreamingSessionResponse").add("Session", session()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "session":
            return Optional.ofNullable(clazz.cast(session()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopStreamingSessionResponse, T> g) {
        return obj -> g.apply((StopStreamingSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopStreamingSessionResponse> {
        /**
         * Sets the value of the Session property for this object.
         *
         * @param session
         *        The new value for the Session property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(StreamingSession session);

        /**
         * Sets the value of the Session property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamingSession.Builder} avoiding the need to
         * create one manually via {@link StreamingSession#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingSession.Builder#build()} is called immediately and its
         * result is passed to {@link #session(StreamingSession)}.
         * 
         * @param session
         *        a consumer that will call methods on {@link StreamingSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #session(StreamingSession)
         */
        default Builder session(Consumer<StreamingSession.Builder> session) {
            return session(StreamingSession.builder().applyMutation(session).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private StreamingSession session;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStreamingSessionResponse model) {
            super(model);
            session(model.session);
        }

        public final StreamingSession.Builder getSession() {
            return session != null ? session.toBuilder() : null;
        }

        public final void setSession(StreamingSession.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        @Override
        @Transient
        public final Builder session(StreamingSession session) {
            this.session = session;
            return this;
        }

        @Override
        public StopStreamingSessionResponse build() {
            return new StopStreamingSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
